/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.raster_service.layer;

import com.northpool.service.client.Client;
import com.northpool.service.config.raster_service.dataset.IRasterDataSet;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.dataset.RasterDataSetShell;
import com.northpool.service.config.raster_service.layer.IRasterLayerLevel;
import com.northpool.service.config.raster_service.layer.RasterLayerLevelBean;
import java.util.Map;

public class RasterLayerLevelShell
implements IRasterLayerLevel {
    private RasterLayerLevelBean layerLevel;
    private IRasterDataSet dataSet;

    public RasterLayerLevelShell(Client client, RasterLayerLevelBean layerLevel, Map<String, RasterDataSetBean> dataSetHashMap) {
        this.layerLevel = layerLevel;
        String dataSetId = layerLevel.getDataSetId();
        RasterDataSetBean dataSet = dataSetHashMap.get(dataSetId);
        if (dataSet == null) {
            throw new RuntimeException(String.format("\u6ca1\u6709\u627e\u5230dataset%s", dataSetId));
        }
        this.dataSet = this.createDataSet(client, dataSet);
    }

    private IRasterDataSet createDataSet(Client client, RasterDataSetBean dataSet) {
        return new RasterDataSetShell(client, dataSet);
    }

    @Override
    public Integer getLevel() {
        return this.layerLevel.getLevel();
    }

    @Override
    public IRasterDataSet getDataSet() {
        return this.dataSet;
    }
}

