/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.raster_service.dataset;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.raster_service.dataset.IRasterDataSet;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;

public class RasterDataSetShell
implements IRasterDataSet {
    protected RasterDataSetBean dataSet;
    protected Client client;
    protected IRasterDataService rasterDataService;

    public RasterDataSetShell(Client client, RasterDataSetBean dataSet) {
        this.client = client;
        this.dataSet = dataSet;
        this.setDataService();
    }

    private void setDataService() {
        if (this.rasterDataService == null) {
            String dataServiceId = this.dataSet.getDataServiceId();
            this.rasterDataService = (IRasterDataService)this.client.getRasterDataServiceManager().get(dataServiceId);
            if (this.rasterDataService == null) {
                throw new RuntimeException(String.format("\u6570\u636e\u670d\u52a1%s\u4e0d\u5b58\u5728", dataServiceId));
            }
        }
    }

    @Override
    public String getSpatialFilter() {
        return this.dataSet.getSpatialFilter();
    }

    @Override
    public IRasterDataService getRasterDataService() {
        return this.rasterDataService;
    }
}

