/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.style;

import com.alibaba.fastjson.JSON;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBean;
import com.northpool.service.config.style.StyleJson;
import java.util.Arrays;
import org.bson.Document;

public class StyleShell
implements IStyleService {
    StyleBean style;

    public StyleShell(StyleBean style) {
        this.style = style;
    }

    public String getId() {
        return this.style.getUuid();
    }

    public String toJson() {
        return this.style.toJson();
    }

    public StyleBean getStyle() {
        return this.style;
    }

    public void setStyle(StyleBean style) {
        this.style = style;
    }

    @Override
    public String getName() {
        return this.style.getName();
    }

    @Override
    public String getOwnServer() {
        return this.style.getOwnServer();
    }

    @Override
    public String getStyleJson() {
        return this.style.getStyleJson();
    }

    @Override
    public String getVersion() {
        return this.style.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.style.setVersion(version);
    }

    @Override
    public String getUuid() {
        return this.style.getUuid();
    }

    @Override
    public StyleBean getBean() {
        return this.style;
    }

    @Override
    public StyleJson getStyleJsonBean() {
        return (StyleJson)JSON.parseObject((String)this.style.getStyleJson(), StyleJson.class);
    }

    @Override
    public void setStyleJson(String styleJson) {
        this.style.setStyleJson(styleJson);
    }

    @Override
    public Double getXmin() {
        return this.style.getXmin();
    }

    @Override
    public Double getYmin() {
        return this.style.getYmin();
    }

    @Override
    public Double getXmax() {
        return this.style.getXmax();
    }

    @Override
    public Double getYmax() {
        return this.style.getYmax();
    }

    public String toString() {
        return this.toJson();
    }

    @Override
    public Document toDocument() {
        Document doc = Document.parse((String)this.toJson());
        doc.remove((Object)"textureLabel");
        doc.remove((Object)"textureLayer");
        if (this.style.getTextureLabel() != null) {
            doc.put("texture_label", Arrays.asList(this.style.getTextureLabel()));
        }
        if (this.style.getTextureLayer() != null) {
            doc.put("texture_layer", Arrays.asList(this.style.getTextureLayer()));
        }
        doc.put("styleLayerJs", (Object)this.style.getStyleLayerJs());
        doc.put("styleLabelJs", (Object)this.style.getStyleLabelJs());
        doc.put("styleAvoidjs", (Object)this.style.getStyleAvoidjs());
        doc.put("queryLayer", (Object)this.style.getQueryLayer());
        doc.put("queryLabel", (Object)this.style.getQueryLabel());
        doc.put("mapboxStyle", (Object)this.style.getMapboxStyle());
        return doc;
    }
}

