/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.terrain_service;

import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.raster_service.IRasterService;
import com.northpool.service.config.raster_service.RasterServiceBean;
import com.northpool.service.config.raster_service.RasterServiceBuilder;
import com.northpool.service.config.raster_service.RasterServiceShell;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.layer.RasterLayerBean;
import com.northpool.service.config.vector_service.exception.DataServiceNotFoundException;
import com.northpool.service.config.vector_service.exception.ServiceNameInvalidException;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.exception.LoadXmlException;
import com.northpool.service.xmlloader.raster_service.TerrainServiceLoader;
import com.northpool.spatial.Constants;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.QuadtreeGrid;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class TerrainServiceBuilder
extends RasterServiceBuilder {
    public IRasterService fromXmlInputStream(InputStream in) throws LoadXmlException {
        TerrainServiceLoader xml = new TerrainServiceLoader(this.client);
        RasterServiceBean service = xml.load(in);
        service.setVersion(String.valueOf(System.currentTimeMillis()));
        RasterServiceShell terrainServiceShell = new RasterServiceShell(this.client, service);
        return terrainServiceShell;
    }

    public IRasterService fromDataService(String serverName, List<String> dataServiceIds) {
        return this.fromDataService(serverName, dataServiceIds, null, null);
    }

    public IRasterService fromDataService(String serverName, List<String> dataServiceIds, int[] origin, double[] resolutions) {
        Constants.GRID_UNIT gridBase;
        Integer srid;
        if (dataServiceIds == null || dataServiceIds.isEmpty()) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)serverName)) {
            throw new ServiceNameInvalidException(serverName);
        }
        RasterServiceBean terrainService = RasterServiceBean.initTerrain();
        terrainService.setId(serverName);
        terrainService.setVersion(String.valueOf(System.currentTimeMillis()));
        LinkedList<IRasterDataService> rasterDataServices = new LinkedList<IRasterDataService>();
        dataServiceIds.stream().forEach(dataServiceId -> {
            IRasterDataService rasterDataService = (IRasterDataService)this.client.getRasterDataServiceManager().get((String)dataServiceId);
            if (rasterDataService != null) {
                Constants.SERVICE_TYPE serviceType = rasterDataService.getServiceType();
                if (serviceType != Constants.SERVICE_TYPE.terrain_data_service) {
                    throw new RuntimeException(StringUtils.join((Object[])new String[]{"\u6570\u636e\u670d\u52a1\u7c7b\u578b\u4e3a\uff1a", serviceType.name(), "\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5730\u5f62\u670d\u52a1\u6210\u5458"}));
                }
            } else {
                throw new DataServiceNotFoundException((String)dataServiceId);
            }
            rasterDataServices.add(rasterDataService);
        });
        try {
            srid = this.getSrid(rasterDataServices);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Constants.GRID_TYPE gridType = Constants.GRID_TYPE.tdt;
        if (origin != null && resolutions != null) {
            gridType = Constants.GRID_TYPE.esri;
        }
        if (null == (gridBase = Constants.getGridUnitBySrid((Integer)srid))) {
            gridBase = Constants.GRID_UNIT.meter;
        }
        String gridTreeName = gridType.name() + "_" + gridBase.name() + "_base512";
        terrainService.setGridTreeName(gridTreeName);
        terrainService.setResolutions(resolutions);
        terrainService.setOrigin(origin);
        QuadtreeGrid grid = GridManager.getQuadtreeGrid((String)gridTreeName);
        Integer startLevel = grid.getBeginLevel();
        Integer endLevel = LayerBean.MAX_LEVEL;
        LinkedHashMap<String, RasterDataSetBean> dataSetMap = this.getDataSetMap(rasterDataServices);
        terrainService.setDataSetMap(dataSetMap);
        LinkedHashMap<String, RasterLayerBean> layerMap = this.getLayerMap(rasterDataServices, dataSetMap, startLevel, endLevel);
        terrainService.setLayerMap(layerMap);
        RasterServiceShell terrainServiceShell = new RasterServiceShell(this.client, terrainService);
        return terrainServiceShell;
    }
}

