/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service;

import com.alibaba.fastjson.JSON;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.CacheInfoBean;
import com.northpool.service.config.vector_service.CacheInfoShell;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.dataset.IDataSet;
import com.northpool.service.config.vector_service.layer.CacheTileLayerBean;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.layer.LayerShell;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import com.northpool.service.config.vector_service.utfgrid.IUtfgridInfo;
import com.northpool.service.config.vector_service.utfgrid.UtfgridInfoBean;
import com.northpool.service.config.vector_service.utfgrid.UtfgridInfoShell;
import com.northpool.spatial.Constants;
import com.northpool.spatial.grid.GridManager;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.QuadtreeGrid;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;

public class VectorServiceShell
implements IVectorService {
    protected Client client;
    protected VectorServiceBean vectorService;
    protected Map<String, ILayer> layerMap;
    protected ICacheable cacheInfo;
    protected IStorageInfo storageInfo;
    protected IUtfgridInfo utfgridInfo;

    public VectorServiceShell(Client client, VectorServiceBean vectorService) {
        this.client = client;
        this.vectorService = vectorService;
        this.layerMap = this.createLayerMap(client, this.vectorService.dataSetMap, this.vectorService.layerMap);
        this.cacheInfo = this.createCacheInfo(client, vectorService.getCacheInfo());
        this.storageInfo = this.createStorage(vectorService.getStorageInfo());
        this.utfgridInfo = this.createUtfgridInfo(vectorService.getUtfgridInfo());
    }

    private IUtfgridInfo createUtfgridInfo(UtfgridInfoBean utfgridInfo) {
        if (utfgridInfo == null) {
            return null;
        }
        UtfgridInfoShell iUtfgridInfo = new UtfgridInfoShell(this.client, utfgridInfo);
        return iUtfgridInfo;
    }

    protected ICacheable createCacheInfo(Client client, CacheInfoBean cacheInfo) {
        if (cacheInfo == null) {
            return null;
        }
        CacheInfoShell cacheShell = new CacheInfoShell(client, cacheInfo);
        return cacheShell;
    }

    protected Map<String, ILayer> createLayerMap(Client client, Map<String, DataSetBean> dataSetMap, Map<String, LayerBean> layerBeanMap) {
        Map layerMap = layerBeanMap.entrySet().stream().map(entry -> {
            LayerShell layerShell = new LayerShell(client, (LayerBean)entry.getValue(), dataSetMap);
            return layerShell;
        }).collect(LinkedHashMap::new, (map, LayerShell2) -> {
            ILayer cfr_ignored_0 = map.put(LayerShell2.getId(), LayerShell2);
        }, Map::putAll);
        return layerMap;
    }

    private IStorageInfo createStorage(StorageInfoBean storage) {
        if (storage != null) {
            return new StorageInfoShell(this.client, storage);
        }
        return null;
    }

    @Override
    public void addStorageInfo(IStorageInfo storageInfo) {
        this.addStorageInfo(storageInfo, null);
    }

    @Override
    public void addStorageInfo(IStorageInfo storageInfo, Map<String, CacheTileLayerBean> updateCacheTileInfo) {
        this.storageInfo = storageInfo;
        if (storageInfo == null) {
            this.getBean().setStorageInfo(null);
        } else {
            this.getBean().setStorageInfo(storageInfo.getBean());
            if (updateCacheTileInfo == null) {
                LinkedHashMap<String, CacheTileLayerBean> cacheTileLayerBeanMap = new LinkedHashMap<String, CacheTileLayerBean>();
                this.getLayerMap().forEach((key, layer) -> {
                    CacheTileLayerBean tile = new CacheTileLayerBean();
                    tile.setId(layer.getId());
                    tile.setDataServiceId(layer.getDataServiceId());
                    cacheTileLayerBeanMap.put(tile.getDataServiceId(), tile);
                });
                this.getBean().setCacheTileLayerInfo(cacheTileLayerBeanMap);
            } else {
                this.getBean().setCacheTileLayerInfo(updateCacheTileInfo);
            }
        }
    }

    @Override
    public void addUtfgridInfo(IUtfgridInfo utfgridInfo) {
        this.utfgridInfo = utfgridInfo;
        if (utfgridInfo == null) {
            this.getBean().setUtfgridInfo(null);
        } else {
            this.getBean().setUtfgridInfo(utfgridInfo.getBean());
        }
    }

    @Override
    public void addCacheInfo(ICacheable cacheInfo) {
        this.cacheInfo = cacheInfo;
        this.getBean().setCacheInfo(cacheInfo.getCacheInfoBean());
    }

    @Override
    public Constants.SERVICE_TYPE getServiceType() {
        return this.vectorService.serviceType;
    }

    public String toJson() {
        return JSON.toJSON((Object)this.vectorService).toString();
    }

    public String mark() {
        return this.vectorService.id;
    }

    @Override
    public void start() {
        this.vectorService.state = CanStartStop.STATE_TYPE.run;
    }

    @Override
    public void stop() {
        this.vectorService.state = CanStartStop.STATE_TYPE.stop;
    }

    @Override
    public String state() {
        return this.vectorService.state.name();
    }

    @Override
    public CanStartStop.STATE_TYPE getState() {
        return this.vectorService.state;
    }

    @Override
    public void rollback(CanStartStop.STATE_TYPE state) {
        this.vectorService.state = state;
    }

    @Override
    public boolean needDataCache() {
        if (this.cacheInfo == null) {
            return false;
        }
        return this.cacheInfo.needDataCache();
    }

    @Override
    public boolean needImgCache() {
        if (this.cacheInfo == null) {
            return false;
        }
        return this.cacheInfo.needImgCache();
    }

    @Override
    public String getImgScript() {
        if (this.cacheInfo == null) {
            return null;
        }
        return this.cacheInfo.getImgScript();
    }

    @Override
    public String getId() {
        return this.vectorService.id;
    }

    @Override
    public String getName() {
        return this.vectorService.name;
    }

    @Override
    public String getVersion() {
        return this.vectorService.version;
    }

    @Override
    public void setVersion(String version) {
        this.vectorService.setVersion(version);
    }

    @Override
    public IGridSystem getGridTree() {
        QuadtreeGrid quadtreeGrid = GridManager.getQuadtreeGrid((String)this.vectorService.getGridTreeName(), (int[])this.vectorService.getOrigin(), (double[])this.vectorService.getResolutions());
        if (quadtreeGrid == null) {
            throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u683c\u7f51\u4e3a" + this.vectorService.gridTreeName);
        }
        return quadtreeGrid;
    }

    @Override
    public String getBbox() {
        return this.vectorService.bbox;
    }

    @Override
    public Integer getBeginLevel() {
        return this.vectorService.beginLevel;
    }

    @Override
    public Integer getEndLevel() {
        return this.vectorService.endLevel;
    }

    @Override
    public Map<String, ILayer> getLayerMap() {
        return this.layerMap;
    }

    @Override
    public Boolean isSinglelayer() {
        return this.layerMap.entrySet().size() == 1;
    }

    @Override
    public IDataSourceInService getDataCacheSource() {
        if (this.cacheInfo == null) {
            return null;
        }
        return this.cacheInfo.getDataCacheSource();
    }

    @Override
    public IDataSourceInService getImgCacheSource() {
        if (this.cacheInfo == null) {
            return null;
        }
        return this.cacheInfo.getImgCacheSource();
    }

    @Override
    public Boolean allowCache() {
        if (this.cacheInfo == null) {
            return false;
        }
        return true;
    }

    @Override
    public VectorServiceBean getBean() {
        return this.vectorService;
    }

    @Override
    public String getDataScript() {
        if (this.cacheInfo == null) {
            return null;
        }
        return this.cacheInfo.getDataScript();
    }

    @Override
    public void refresh() {
        List<IDataService> dataServices = this.getLayerMap().values().stream().flatMap(layer -> layer.getLevelMap().values().stream()).map(layerlevel -> layerlevel.getDataSet().getDataService()).collect(Collectors.toList());
        dataServices.forEach(dataService -> dataService.refresh());
    }

    @Override
    public List<FieldsConfig> getLayerFields(ILayer layer) {
        if (!layer.getLayerType().equals((Object)Constants.LAYER_TYPE.VECTOR)) {
            return null;
        }
        ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
        IDataSet dataSet = layerLevel.getDataSet();
        IDataService dataService = dataSet.getDataService();
        return dataService.getFields();
    }

    @Override
    public String getLayerIdFieldName(ILayer layer) {
        if (!layer.getLayerType().equals((Object)Constants.LAYER_TYPE.VECTOR)) {
            return null;
        }
        ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
        IDataSet dataSet = layerLevel.getDataSet();
        IDataService dataService = dataSet.getDataService();
        return dataService.getIdFieldName();
    }

    @Override
    public String getLayerIdFieldType(ILayer layer) {
        if (!layer.getLayerType().equals((Object)Constants.LAYER_TYPE.VECTOR)) {
            return null;
        }
        ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
        IDataSet dataSet = layerLevel.getDataSet();
        IDataService dataService = dataSet.getDataService();
        return dataService.getIdField().getType();
    }

    @Override
    public String getLayerGeometryType(ILayer layer) {
        if (!layer.getLayerType().equals((Object)Constants.LAYER_TYPE.VECTOR)) {
            return null;
        }
        ILayerLevel layerLevel = layer.getLevelMap().values().iterator().next();
        IDataSet dataSet = layerLevel.getDataSet();
        IDataService dataService = dataSet.getDataService();
        return dataService.getGeoType().name();
    }

    @Override
    public int[] getOrigin() {
        return this.vectorService.getOrigin();
    }

    @Override
    public double[] getResolutions() {
        return this.vectorService.getResolutions();
    }

    @Override
    public List<String> getDataServiceIds() {
        return this.getBean().getDataSetMap().values().parallelStream().map(dataSetBean -> dataSetBean.getDataServiceId()).collect(Collectors.toList());
    }

    @Override
    public ICacheable getCacheInfo() {
        return this.cacheInfo;
    }

    @Override
    public CacheInfoBean getCacheInfoBean() {
        return this.cacheInfo.getCacheInfoBean();
    }

    @Override
    public Map<String, CacheTileLayerBean> getCacheTileLayers() {
        return this.vectorService.getCacheTileLayerInfo();
    }

    @Override
    public void drop(String serverName, String styleId) {
    }

    public void setCacheInfo(ICacheable cacheInfo) {
        this.cacheInfo = cacheInfo;
    }

    @Override
    public IStorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    public void setStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
    }

    @Override
    public IUtfgridInfo getUtfgridInfo() {
        return this.utfgridInfo;
    }

    public void setUtfgridInfo(IUtfgridInfo utfgridInfo) {
        this.utfgridInfo = utfgridInfo;
    }

    @Override
    public Document toDocument() {
        return Document.parse((String)this.toJson());
    }

    @Override
    public Client getClient() {
        return this.client;
    }
}

