/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.abstractclass;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.exception.Message;
import com.northpool.exception.UException;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.exception.IdFieldValueEmptyException;
import com.northpool.service.client.Client;
import com.northpool.service.config.IBeanBuilder;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.manager.IMetaDataManager;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import com.northpool.service.manager.abstractclass.EventMessage;
import com.northpool.service.manager.abstractclass.ExistsIdException;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractManager<T extends Jsonable & Idable<String>, Builder extends JsonableBuilder<T> & DocumentableBuilder<T>>
implements IMetaDataManager<T> {
    Logger logger = LoggerFactory.getLogger(AbstractManager.class);
    protected QueryHashTableHeap<String, T> table;
    protected String idFieldName = "id";
    protected Client client;
    protected Boolean readOnly = false;
    protected String managerRoot;
    protected PathChildrenCache HolderCache;
    protected static final String INFO_FIELD = "data";
    protected Builder beanBuilder;
    protected Boolean isReady = false;
    protected EventContainer<Listener> eventContainer = new EventContainer();
    protected IMetaDataDao<T> metaDataDao;

    public AbstractManager(Builder beanBuilder, String managerRoot) {
        this.managerRoot = managerRoot;
        this.beanBuilder = beanBuilder;
    }

    @Override
    public void init() throws Exception {
        ((IBeanBuilder)this.beanBuilder).setClient(this.client);
        this.table = new QueryHashTableHeap(this.idFieldName);
        this.metaDataDao = this.getMetaDataDao();
        List<T> list = this.metaDataDao.findAll();
        for (Jsonable t : list) {
            this.saveBeanToHashTable(t);
        }
    }

    protected abstract IMetaDataDao<T> getMetaDataDao() throws Exception;

    protected void saveBeanToHashTable(T bean) {
        if (this.table == null) {
            return;
        }
        this.table.insert(bean);
    }

    protected void removeBeanToHashTable(String pk) {
        if (this.table == null) {
            return;
        }
        this.table.remove((Serializable)((Object)pk));
    }

    protected void updateBeanToHashTable(T bean) {
        if (this.table == null) {
            return;
        }
        this.table.update(bean);
    }

    public Boolean exists(String id) throws Exception {
        if (this.table.get((Serializable)((Object)id)) != null) {
            return true;
        }
        return this.metaDataDao.exists(id);
    }

    protected void isReady() throws ZKException {
    }

    protected void doAdd(T t) throws Exception {
        String version;
        this.isReady();
        String id = (String)((Idable)t).getId();
        if (id == null) {
            throw new IdFieldValueEmptyException(this.idFieldName, t);
        }
        if (this.exists(id).booleanValue()) {
            throw new ExistsIdException(id);
        }
        if (t instanceof IVersionAble && (version = ((IVersionAble)t).getVersion()) == null) {
            ((IVersionAble)t).setVersion(new Date().getTime() + "");
        }
        this.saveBeanToHashTable(t);
        try {
            this.metaDataDao.insert(t);
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            this.removeBeanToHashTable(id);
            throw e;
        }
        this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.register.name(), new Object[]{id, t});
    }

    protected void doUpdate(T t) throws Exception {
        this.isReady();
        String id = (String)((Idable)t).getId();
        if (id == null) {
            throw new IdFieldValueEmptyException(this.idFieldName, t);
        }
        if (!this.exists(id).booleanValue()) {
            throw new NotFoundException(id);
        }
        if (t instanceof IVersionAble) {
            IVersionAble versionAble = (IVersionAble)t;
            versionAble.setVersion(new Date().getTime() + "");
        }
        this.updateBeanToHashTable(t);
        try {
            this.metaDataDao.update(t);
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw e;
        }
        this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.update.name(), new Object[]{id, t});
    }

    protected void doRemove(String id) throws Exception {
        this.isReady();
        if (!this.exists(id).booleanValue()) {
            throw new NotFoundException(id);
        }
        this.removeBeanToHashTable(id);
        try {
            this.metaDataDao.delete(id);
        }
        catch (Exception e) {
            UException.printStackTrace((Throwable)e);
            throw e;
        }
        this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.unRegister.name(), new Object[]{id, this.get(id)});
    }

    public void on(EventMessage.EVENT_TYPE type, EventMessage<T> e) {
        this.eventContainer.on(type.name(), parameter -> {
            Jsonable t = parameter[1] == null ? null : (Jsonable)parameter[1];
            e.fire((String)parameter[0], t);
        });
    }

    @Override
    public List<T> list(QueryFilter queryFilter) {
        if (this.table != null) {
            return this.table.query(queryFilter);
        }
        return null;
    }

    @Override
    public List<T> findAll() {
        if (this.table != null) {
            return this.table.query(new QueryFilter());
        }
        return null;
    }

    @Override
    public T findOne(QueryFilter queryFilter) {
        IScroll scroll = this.table.scroll(queryFilter);
        if (scroll.hasNext()) {
            return (T)((Jsonable)scroll.next());
        }
        return null;
    }

    @Override
    public IScroll<T> scroll(QueryFilter queryFilter) {
        if (this.table != null) {
            return this.table.scroll(queryFilter);
        }
        return null;
    }

    @Override
    public T get(String id) {
        Jsonable t = (Jsonable)this.table.get((Serializable)((Object)id));
        if (t == null) {
            try {
                t = (Jsonable)this.metaDataDao.findOne(id);
            }
            catch (Exception e) {
                throw new Message(this.managerRoot + ": id\u4e3a " + id + "\u7684\u6570\u636e\u62c9\u53d6\u5931\u8d25");
            }
            if (t != null) {
                try {
                    this.table.insert((Object)t);
                }
                catch (Exception e) {
                    this.logger.warn("\u7f13\u5b58\u4e2d\u5df2\u7ecf\u5b58\u5728id\u4e3a\uff1a" + id + "\u7684\u6570\u636e\uff0c\u5ffd\u7565\u672c\u6b21\u63d2\u5165");
                }
            }
        }
        return (T)t;
    }

    @Override
    public String getJSON(String id) {
        T bean = this.get(id);
        if (bean != null) {
            return bean.toJson();
        }
        return null;
    }

    @Override
    public void setClient(Client client) {
        this.client = client;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

