/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.node;

import com.northpool.node.NodeZkDao;
import com.northpool.node.config.INodeService;
import com.northpool.node.config.NodeBean;
import com.northpool.node.config.NodeQuery;
import com.northpool.node.config.NodeType;
import com.northpool.node.observer.ConcreteNodeMessage;
import com.northpool.node.observer.Observer;
import com.northpool.node.statistics.StatisticsLog;
import com.northpool.service.client.Client;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.manager.node.INodeManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NodeManager
implements INodeManager {
    Client client;
    protected QueryHashTableHeap<String, INodeService> table;
    private IMetaDataDao<INodeService> metaDataDao;
    private INodeService localNode;
    protected ConcreteNodeMessage nodeMessage;

    @Override
    public void setClient(Client client) throws Exception {
        this.client = client;
    }

    @Override
    public void init() throws Exception {
        this.metaDataDao = this.getMetaDataDao();
    }

    @Override
    public List<INodeService> list(NodeQuery query) {
        try {
            List<INodeService> list = this.metaDataDao.findAll();
            if (query != null && list != null && list.size() > 0) {
                list = list.stream().filter(item -> {
                    NodeBean nodeBean = (NodeBean)item.getBean();
                    if (nodeBean == null) {
                        return false;
                    }
                    if (query == null) {
                        return true;
                    }
                    if (query.getActive() != null && !query.getActive().equals(nodeBean.getActive())) {
                        return false;
                    }
                    if (query.getUrl() != null && !query.getUrl().equals(nodeBean.getUrl())) {
                        return false;
                    }
                    if (query.getName() != null && !query.getName().equals(nodeBean.getName())) {
                        return false;
                    }
                    return query.getType() == null || query.getType().equals((Object)nodeBean.getType());
                }).collect(Collectors.toList());
            }
            return list;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean register(String type, String name, String url, Boolean isLocal) {
        try {
            INodeService node = INodeService.create(url, NodeType.valueOf(type), name);
            if (StringUtils.isBlank((CharSequence)((NodeBean)node.getBean()).getUrl())) {
                throw new RuntimeException("\u5730\u5740\u672a\u8bbe\u7f6e");
            }
            if (((NodeBean)node.getBean()).getType() == null) {
                throw new RuntimeException("\u8282\u70b9\u670d\u52a1\u7c7b\u578b\u672a\u8bbe\u7f6e");
            }
            if (StringUtils.isBlank((CharSequence)node.getName())) {
                throw new RuntimeException("\u540d\u79f0\u672a\u8bbe\u7f6e");
            }
            if (isLocal.booleanValue()) {
                this.localNode = node;
            }
            this.metaDataDao.insert(node);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean unRegister(String type, String name) {
        try {
            String id = type + "_" + name;
            this.metaDataDao.delete(id);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean online(String type, String name) {
        try {
            INodeService node = this.get(type, name);
            ((NodeBean)node.getBean()).setActive(true);
            this.metaDataDao.update(node);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean offline(String type, String name) {
        try {
            INodeService node = this.get(type, name);
            ((NodeBean)node.getBean()).setActive(false);
            this.metaDataDao.update(node);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean refresh(String type, String name) {
        try {
            INodeService node = this.get(type, name);
            ((NodeBean)node.getBean()).setActive(node.isActive());
            this.metaDataDao.update(node);
            return ((NodeBean)node.getBean()).getActive();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean refreshStatisticsLog(String type, String name, StatisticsLog logData) {
        try {
            INodeService node = this.get(type, name);
            node.setStatistics(logData);
            this.metaDataDao.update(node);
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IMetaDataDao<INodeService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null && this.client.getZoo() != null) {
            this.nodeMessage = new ConcreteNodeMessage();
            NodeZkDao zkDao = new NodeZkDao(this.table, this.client, this, this.nodeMessage);
            zkDao.init();
            this.metaDataDao = zkDao;
        }
        return this.metaDataDao;
    }

    @Override
    public INodeService get(String type, String name) {
        try {
            NodeType nodeType = NodeType.valueOf(type);
            String id = NodeBean.buildUUid(nodeType, name);
            INodeService node = this.metaDataDao.findOne(id);
            return node;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public INodeService get(NodeType type, String name) {
        try {
            String id = NodeBean.buildUUid(type, name);
            INodeService node = this.metaDataDao.findOne(id);
            return node;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJSON(NodeType type, String id) {
        return this.get(type, id).toJson();
    }

    @Override
    public List<INodeService> findAll() {
        return this.list(null);
    }

    @Override
    public INodeService findOne(NodeQuery queryFilter) {
        List<INodeService> list = this.list(queryFilter);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public boolean checkVersion(String type, String name, String version) {
        INodeService node = this.get(NodeType.valueOf(type), name);
        if (node != null) {
            return Objects.equals(version, node.getVersion());
        }
        return false;
    }

    @Override
    public void listenNodeUpdate(Observer observer) {
        this.nodeMessage.registerObserver(observer);
    }

    @Override
    public void removeListenNodeUpdate(Observer observer) {
        this.nodeMessage.removeObserver(observer);
    }

    @Override
    public INodeService getLocalNode() {
        return this.localNode;
    }
}

