/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.style;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBean;
import com.northpool.service.config.style.StyleBuilder;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.dao.style.StyleIgniteDao;
import com.northpool.service.dao.style.StyleZkDao;
import com.northpool.service.manager.abstractclass.AbstractManager;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.style.StyleInValidException;
import com.northpool.service.mapserver.MapServerAccess;
import com.northpool.service.mapserver.MapserverAccessException;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleManager
extends AbstractManager<IStyleService, StyleBuilder>
implements IStyleManager {
    Logger logger = LoggerFactory.getLogger(StringBuilder.class);
    protected static final String MANAGER_ROOT = "style";
    protected MapServerAccess mapServerAccess;

    public StyleManager() {
        super(StyleBuilder.getInstance(), MANAGER_ROOT);
        this.idFieldName = "uuid";
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.mapServerAccess = this.client.getMapServerAccess();
    }

    @Override
    public IMetaDataDao<IStyleService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null) {
            if (this.client.getZoo() != null) {
                StyleZkDao styleZkDao = new StyleZkDao(this.idFieldName, (StyleBuilder)this.beanBuilder, (QueryHashTableHeap<String, IStyleService>)this.table, this.client, this.managerRoot, this.readOnly, this);
                styleZkDao.init();
                this.metaDataDao = styleZkDao;
            } else if (this.client.getIgnite() != null) {
                StyleIgniteDao styleIgniteDao = new StyleIgniteDao(this.idFieldName, (QueryHashTableHeap<String, IStyleService>)this.table, this.client, this.managerRoot, this.readOnly, this.client.getIgnite(), this);
                styleIgniteDao.init();
                this.metaDataDao = styleIgniteDao;
            }
        }
        return this.metaDataDao;
    }

    @Override
    public void save(IStyleService style) throws Exception {
        IStyleService finalStyle = style;
        String result = null;
        try {
            result = MapServerAccess.saveStyle(finalStyle.getOwnServer(), finalStyle.getName(), finalStyle.getStyleJson(), finalStyle.getXmin(), finalStyle.getYmin(), finalStyle.getXmax(), finalStyle.getYmax());
        }
        catch (MapserverAccessException e) {
            throw new CompletionException(e);
        }
        this.logger.debug(result);
        JSONObject resultJson = JSON.parseObject((String)result);
        if (!(resultJson.containsKey((Object)"success") && resultJson.get((Object)"success").equals(true) && resultJson.containsKey((Object)"id"))) {
            throw new CompletionException(new StyleInValidException(resultJson.getString("message")));
        }
        Thread.sleep(500L);
        String id = (String)style.getId();
        style = (IStyleService)this.metaDataDao.findOne(id);
        ((StyleBean)style.getBean()).setUuid(id);
        if (this.table.get((Serializable)((Object)id)) == null) {
            this.saveBeanToHashTable(style);
            try {
                this.metaDataDao.insert(style);
            }
            catch (Exception e) {
                this.removeBeanToHashTable((String)style.getId());
                throw e;
            }
        } else {
            this.updateBeanToHashTable(style);
            this.metaDataDao.update(style);
        }
    }

    @Override
    public void remove(String[] ids) throws Exception {
        for (int i = 0; i < ids.length; ++i) {
            try {
                super.doRemove(ids[i]);
                continue;
            }
            catch (NotFoundException e) {
                this.logger.info(e.getMessage());
            }
        }
    }

    @Override
    public IStyleService get(String belongService, String styleId) {
        return (IStyleService)super.get(belongService + "_" + styleId);
    }

    @Override
    public boolean checkVersion(String belongService, String styleId, String version) {
        IStyleService style = this.get(belongService, styleId);
        if (style != null) {
            return Objects.equals(version, style.getVersion());
        }
        return false;
    }

    @Override
    public void update(IStyleService style) throws Exception {
        this.remove(new String[]{style.getUuid()});
        ((StyleBean)style.getBean()).setUuid(style.getOwnServer() + "_" + style.getName());
        this.doAdd(style);
    }
}

