/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.xmlloader;

import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.service.client.Client;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.VectorServiceShell;
import com.northpool.service.exception.ReservedWordsConflictException;
import com.northpool.service.xmlloader.RegisterXmlToServerMessage;
import com.northpool.service.xmlloader.vectorservice.VectorServiceLoader;
import java.io.InputStream;
import java.util.Arrays;

public class RegisterXmlToServer {
    protected Client client;
    protected EventContainer<Listener> eventContainer = new EventContainer();

    public RegisterXmlToServer(Client client) {
        this.client = client;
    }

    public IVectorService register(InputStream inXMl) throws Exception {
        VectorServiceLoader xml = new VectorServiceLoader(this.client);
        VectorServiceBean service = xml.load(inXMl);
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, service);
        this.client.getVectorServiceManager().register(VectorServiceShell2);
        return VectorServiceShell2;
    }

    public IVectorService register(InputStream inXMl, String[] reservedWords) throws Exception {
        VectorServiceLoader xml = new VectorServiceLoader(this.client);
        VectorServiceBean service = xml.load(inXMl);
        String serviceId = service.getId();
        if (Arrays.asList(reservedWords).contains(serviceId)) {
            throw new ReservedWordsConflictException("\u670d\u52a1ID " + serviceId + " \u4e0e\u7cfb\u7edf\u4fdd\u7559\u5b57\u51b2\u7a81");
        }
        VectorServiceShell VectorServiceShell2 = new VectorServiceShell(this.client, service);
        this.client.getVectorServiceManager().register(VectorServiceShell2);
        return VectorServiceShell2;
    }

    public void on(RegisterXmlToServerMessage.EVENT_TYPE type, RegisterXmlToServerMessage e) {
        this.eventContainer.on(type.name(), parameter -> e.fire(parameter[0]));
    }
}

