/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.devtool.model.abstractclass;

import com.northpool.devtool.utils.NetUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNetConnect {
    private static Logger logger = LoggerFactory.getLogger(AbstractNetConnect.class);
    protected String ip;
    protected Integer port;
    protected List<String> hosts;
    protected Boolean isConnect = false;
    final Integer CONNECT_TIME_OUT = 1000;

    public AbstractNetConnect(String uri) {
        this.init(uri);
    }

    public abstract void init(String var1);

    public Boolean getConnect(Boolean loadBalance) {
        if (this.hosts != null && this.hosts.size() > 0) {
            Boolean flag = false;
            for (String item : this.hosts) {
                String[] host = item.split(":");
                String ip = host[0];
                int port = host.length == 1 ? 80 : Integer.parseInt(host[1]);
                Boolean isConnect = NetUtils.testIpAndPort(ip, port, this.CONNECT_TIME_OUT);
                if (loadBalance.booleanValue() && isConnect.booleanValue()) {
                    flag = true;
                    break;
                }
                if (loadBalance.booleanValue() && !isConnect.booleanValue()) {
                    logger.warn("\u8fde\u63a5\u4e0d\u53ef\u7528: {}:{}", (Object)ip, (Object)port);
                    continue;
                }
                if (isConnect.booleanValue()) continue;
                logger.error("\u8fde\u63a5\u4e0d\u53ef\u7528: {}:{}", (Object)ip, (Object)port);
                break;
            }
            return flag;
        }
        return NetUtils.testIpAndPort(this.ip, this.port, this.CONNECT_TIME_OUT);
    }

    public void setConnect(Boolean connect) {
        this.isConnect = connect;
    }
}

