/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.node.config;

import com.northpool.node.config.INodeService;
import com.northpool.node.config.NodeBean;
import com.northpool.node.config.NodeType;
import com.northpool.node.service.ManagerNodeService;
import com.northpool.node.service.MapserverNodeService;
import com.northpool.node.service.abstractclass.AbstractNode;
import com.northpool.node.statistics.StatisticsLog;

public class NodeShell
implements INodeService {
    NodeBean bean;
    AbstractNode node;

    public NodeShell(NodeBean bean) {
        this.bean = bean;
        if (bean.getType().equals((Object)NodeType.Mapserver)) {
            this.node = new MapserverNodeService(bean.getUrl());
        } else if (bean.getType().equals((Object)NodeType.Manager)) {
            this.node = new ManagerNodeService(bean.getUrl());
        } else {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u7c7b\u578b");
        }
    }

    @Override
    public String getId() {
        return this.bean.getUuid();
    }

    @Override
    public Boolean isActive() {
        return this.node.isActive();
    }

    @Override
    public void setStatistics(StatisticsLog log) {
        this.bean.setStatistics(log);
    }

    public String toJson() {
        return this.bean.toJson();
    }

    @Override
    public NodeBean getBean() {
        return this.bean;
    }

    @Override
    public String getVersion() {
        return this.bean.getVersion();
    }

    @Override
    public void setVersion(String version) {
        this.bean.setVersion(version);
    }

    @Override
    public String getName() {
        return this.bean.name;
    }

    public AbstractNode getNode() {
        return this.node;
    }
}

