/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service;

import com.geoway.atlas.license.authorize.LicenseCheck;
import com.northpool.commons.classloader.MemoryClassLoader;
import com.northpool.commons.concurrent.ThreadPoolConf;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.commons.reflect.Reflect;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.diagnose.ProfilingUtil;
import com.northpool.resources.datasource.db.DBPoolParameter;
import com.northpool.service.client.Client;
import com.northpool.service.httpstatistic.AccessLogMonitor;
import com.northpool.service.netty.websocket.WebSocketServer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMain {
    MemoryClassLoader loader;
    Object client;
    Class clientClass;

    public ClientMain(String path, Object[] info) throws Exception {
        String curPath = path;
        this.loader = new MemoryClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        for (int i = 0; i < info.length / 2; ++i) {
            this.loader.loadJar((String)info[i * 2], (byte[])info[i * 2 + 1]);
        }
        Reflect.setClassLoader((ClassLoader)this.loader);
        System.setProperty("APP_HOME", curPath);
        System.out.println("JavaAPP_HOME:" + curPath);
    }

    public void initJavaLogs() {
        Log4jUtil.init2();
        Logger logger = LoggerFactory.getLogger(ClientMain.class);
        logger.info("log for java initialized.");
    }

    public void showSql(boolean onoff) {
        Log4jUtil.setShowSql((boolean)onoff);
    }

    public boolean checkJavaLogs() throws InterruptedException {
        System.out.println("===This line is in Java function===");
        Logger logger = LoggerFactory.getLogger(ClientMain.class);
        logger.info("This log line is in java !!");
        logger.info(Log4jUtil.MARKER_DIAG, "This line is Marked as diagnose logs.");
        for (int i = 0; i < 1000; ++i) {
            logger.info(i + "");
            if (0 == i % 100) {
                logger.info(Log4jUtil.MARKER_DIAG, "Marked: " + i);
            }
            Thread.sleep(10L);
        }
        Thread.sleep(10000L);
        logger.info("test end.");
        return true;
    }

    public Boolean checkIsValid() {
        return LicenseCheck.isValid((int)64809);
    }

    public void setRealtimeTileThreadPoolSize(int threadCount) {
        if (threadCount > 0) {
            ThreadPoolConf.REALTIME_TILE_THREAD_COUNT = threadCount;
        }
    }

    public void setRealtimeDBPoolSize(int size) {
        if (size > 0) {
            DBPoolParameter.DEFAULT.setMaxActive(size);
        }
    }

    public void enableProfiling(boolean onoff) {
        ProfilingUtil.enableProfiling((boolean)onoff);
    }

    public void enableMongoTilesSharding(boolean onoff) {
        GlobalTileSettings.ENABLE_MONGO_SHARDING = onoff;
    }

    public void setAccurateIntersect(boolean onoff) {
        GlobalTileSettings.bAccurateCut = onoff;
    }

    public void startHttpLogMonitor(String accessLogPath, String options) {
        AccessLogMonitor.setLogMonitorOn(accessLogPath, options);
    }

    public Object init(String mongoUri, String zkAddress, String mapserverUrl, Integer tcpPort) throws Exception {
        Thread.currentThread().setContextClassLoader(this.loader);
        this.clientClass = this.loader.loadClass("com.northpool.service.client.Client");
        Constructor constructor = this.clientClass.getDeclaredConstructor(String.class, String.class, String.class);
        this.client = constructor.newInstance(mongoUri, zkAddress, mapserverUrl);
        Logger logger = LoggerFactory.getLogger(ClientMain.class);
        logger.info("\u51c6\u5907\u5f00\u542fWebSocket\u670d\u52a1\uff0c\u7aef\u53e3\uff1a" + tcpPort);
        new WebSocketServer((Client)this.client).bind(tcpPort);
        return this.client;
    }

    public Object initByIgniteMode(String igniteAddress, Integer igniteClientPort, String igniteMcastGrp, String mapserverUrl, Integer tcpPort) throws Exception {
        Thread.currentThread().setContextClassLoader(this.loader);
        this.clientClass = this.loader.loadClass("com.northpool.service.client.Client");
        Constructor constructor = this.clientClass.getDeclaredConstructor(String.class, Integer.class, String.class, String.class);
        this.client = constructor.newInstance(igniteAddress, igniteClientPort, igniteMcastGrp, mapserverUrl);
        new WebSocketServer((Client)this.client).bind(tcpPort);
        return this.client;
    }

    public Object getTextureManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTextureManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getVectorServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getVectorServiceManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getDataSourcesManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getDataSourcesManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getDataServiceManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getDataServiceManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getStyleManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getStyleManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getFontManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getFontManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getNodeManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getNodeManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getTileDataCellManager() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = this.clientClass.getMethod("getTileDataCellManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getRasterDataServiceManager() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = this.clientClass.getMethod("getRasterDataServiceManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getImageServiceManager() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = this.clientClass.getMethod("getImageServiceManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public Object getTerrainServiceManager() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = this.clientClass.getMethod("getTerrainServiceManager", new Class[0]);
        return method.invoke(this.client, new Object[0]);
    }

    public static void main(String[] aaa) throws Exception, ClassNotFoundException, NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ClientMain.runMapserverJavaService();
    }

    private static void runMapserverJavaService() {
        try {
            String rootDir = "D:\\Atlas2022\\Git-vtile\\vtile\\engine\\mapserver3.x\\dist\\java\\lib";
            String mongoBuziUrl = "mongodb://172.16.67.51:27017/sfg1111";
            String zkAddress = "gwatlas.cn:2181";
            String engineUrl = "http://127.0.0.1:8091/mapserver";
            Integer wsPort = 3000;
            ClientMain svr = new ClientMain(rootDir, new Object[0]);
            svr.initJavaLogs();
            svr.checkIsValid();
            svr.setRealtimeTileThreadPoolSize(10);
            svr.setRealtimeDBPoolSize(200);
            svr.enableProfiling(true);
            svr.init(mongoBuziUrl, zkAddress, engineUrl, wsPort);
            svr.setAccurateIntersect(true);
            Client service = (Client)svr.client;
            service.getTileDataCellManager();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}

