/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.data_service.raster;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.northpool.resources.Image;
import com.northpool.resources.image.raster.RasterImageConnection;
import com.northpool.resources.image.raster.RasterImageGDALShell;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.raster.DispelEdgeConfig;
import com.northpool.service.config.data_service.raster.ResampleConfig;
import com.northpool.service.config.data_service.raster.UniformColorTemplate;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.spatial.grid.QuadtreeGrid;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class RasterDataServiceBean {
    private String id;
    private String name;
    private List<Image> images;
    protected Integer[] bands;
    private Boolean terrain;
    private Integer srid;
    private Double[] noDataValue;
    private Constants.RASTER_HANDLE_TYPE rasterHandleType;
    private Integer startLevel;
    private Double startResolution;
    private Integer endLevel;
    private Double endResolution;
    private Double[] bbox;
    private QuadtreeGrid grid;
    private String gridTreeName;
    private List<ResampleConfig> resampleConfigs;
    private List<DispelEdgeConfig> dispelEdgedConfigs;
    private UniformColorTemplate uniformColorTemplate;
    private Constants.SERVICE_TYPE serviceType;
    private CanStartStop.STATE_TYPE state = CanStartStop.STATE_TYPE.standby;
    private StorageInfoBean storageInfo;
    private String version;
    private Integer bandCount;
    private String bandValueToRGBAScript;
    private String mergeScript;

    RasterDataServiceBean() {
    }

    public RasterDataServiceBean(String id, String name, List<Image> images) {
        this(id, name, images, false, null);
    }

    public RasterDataServiceBean(String id, String name, List<Image> images, Integer[] bands) {
        this(id, name, images, false, bands);
    }

    public RasterDataServiceBean(String id, String name, List<Image> images, boolean isTerrain, Integer[] bands) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new RuntimeException("\u5f71\u50cf\u6570\u636e\u670d\u52a1id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (images == null || images.isEmpty() || images.get(0) == null || images.get(0).empty()) {
            throw new RuntimeException("\u5f71\u50cf\u6570\u636e\u670d\u52a1\u5fc5\u987b\u5305\u542b\u81f3\u5c11\u4e00\u4e2a\u6805\u683c\u6587\u4ef6");
        }
        String fileName = images.get(0).getFileName();
        RasterImageConnection connection = new RasterImageConnection(fileName);
        RasterImageGDALShell gdalShell = connection.getRasterImageGDALShell();
        try {
            gdalShell.load();
            this.bandCount = gdalShell.getBandCount();
            if (0 == this.bandCount) {
                throw new RuntimeException("\u975e\u6cd5\u5f71\u50cf\u6587\u4ef6\uff1a\u7f3a\u5c11\u6ce2\u6bb5\uff08\u901a\u9053\uff09\u4fe1\u606f");
            }
            this.noDataValue = gdalShell.getNoDataValue();
            this.srid = Integer.parseInt(gdalShell.getSrid());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(StringUtils.join((Object[])new String[]{"\u5f71\u50cf\u6570\u636e ", fileName, " \u7684\u5750\u6807\u7cfb\u4ee3\u7801 ", gdalShell.getSrid(), " \u4e0d\u662f\u6807\u51c6\u7684\u6574\u578b\u4ee3\u7801"}));
        }
        this.id = id;
        this.name = name;
        this.images = images;
        this.terrain = isTerrain;
        this.bbox = this.calculateBBox();
        if (ArrayUtils.isNotEmpty((Object[])bands)) {
            for (Integer band : bands) {
                if (band > 0 && band <= this.bandCount) continue;
                throw new RuntimeException(StringUtils.join((Object[])new Serializable[]{"\u6805\u683c\u6587\u4ef6\u5761\u6bb5\u6570\u4e3a\uff1a\u3010", this.bandCount, "\u3011\uff1b\u4e0d\u5b58\u5728\u6ce2\u6bb5\uff1a\u3010", band, "\u3011"}));
            }
            this.bands = bands;
        }
        if (isTerrain) {
            if (ArrayUtils.isEmpty((Object[])bands)) {
                this.bands = new Integer[]{1};
            } else {
                int terrainBand = bands[0];
                if (terrainBand <= 0 || terrainBand > this.bandCount) {
                    throw new RuntimeException(StringUtils.join((Object[])new Serializable[]{"\u6805\u683c\u6587\u4ef6\u5761\u6bb5\u6570\u4e3a\uff1a\u3010", this.bandCount, "\u3011\uff1b\u4e0d\u5b58\u5728\u6ce2\u6bb5\uff1a\u3010", Integer.valueOf(terrainBand), "\u3011"}));
                }
                this.bands = new Integer[]{terrainBand};
            }
            this.serviceType = Constants.SERVICE_TYPE.terrain_data_service;
        } else {
            this.serviceType = Constants.SERVICE_TYPE.image_data_service;
        }
    }

    private Double[] calculateBBox() {
        Double[] bbox = new Double[4];
        int len = this.images.size();
        for (int i = 0; i < len; ++i) {
            Image image = this.images.get(i);
            Double[] imageBbox = image.getBbox();
            if (null == bbox[0] || imageBbox[0] < bbox[0]) {
                bbox[0] = imageBbox[0];
            }
            if (null == bbox[1] || imageBbox[1] < bbox[1]) {
                bbox[1] = imageBbox[1];
            }
            if (null == bbox[2] || imageBbox[2] > bbox[2]) {
                bbox[2] = imageBbox[2];
            }
            if (null != bbox[3] && !(imageBbox[3] > bbox[3])) continue;
            bbox[3] = imageBbox[3];
        }
        return bbox;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public Boolean isTerrain() {
        return this.terrain;
    }

    public void setTerrain(Boolean terrain) {
        this.terrain = terrain;
    }

    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public Double[] getNoDataValue() {
        return this.noDataValue;
    }

    public void setNoDataValue(Double[] noDataValue) {
        this.noDataValue = noDataValue;
    }

    public Constants.RASTER_HANDLE_TYPE getRasterHandleType() {
        return this.rasterHandleType;
    }

    public void setRasterHandleType(Constants.RASTER_HANDLE_TYPE rasterHandleType) {
        this.rasterHandleType = rasterHandleType;
    }

    public Integer getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(Integer startLevel) {
        this.startLevel = startLevel;
    }

    public Double getStartResolution() {
        return this.startResolution;
    }

    public void setStartResolution(Double startResolution) {
        this.startResolution = startResolution;
    }

    public Integer getEndLevel() {
        return this.endLevel;
    }

    public void setEndLevel(Integer endLevel) {
        this.endLevel = endLevel;
    }

    public Double getEndResolution() {
        return this.endResolution;
    }

    public void setEndResolution(Double endResolution) {
        this.endResolution = endResolution;
    }

    public Double[] getBbox() {
        return this.bbox;
    }

    public void setBbox(Double[] bbox) {
        this.bbox = bbox;
    }

    public QuadtreeGrid getGrid() {
        return this.grid;
    }

    public void setGrid(QuadtreeGrid grid) {
        this.grid = grid;
    }

    public List<ResampleConfig> getResampleConfigs() {
        return this.resampleConfigs;
    }

    public void setResampleConfigs(List<ResampleConfig> resampleConfigs) {
        this.resampleConfigs = resampleConfigs;
    }

    public List<DispelEdgeConfig> getDispelEdgedConfigs() {
        return this.dispelEdgedConfigs;
    }

    public void setDispelEdgedConfigs(List<DispelEdgeConfig> dispelEdgedConfigs) {
        this.dispelEdgedConfigs = dispelEdgedConfigs;
    }

    public UniformColorTemplate getUniformColorTemplate() {
        return this.uniformColorTemplate;
    }

    public void setUniformColorTemplate(UniformColorTemplate uniformColorTemplate) {
        this.uniformColorTemplate = uniformColorTemplate;
    }

    public Constants.SERVICE_TYPE getServiceType() {
        return this.serviceType;
    }

    public CanStartStop.STATE_TYPE getState() {
        return this.state;
    }

    public void setState(CanStartStop.STATE_TYPE state) {
        this.state = state;
    }

    public StorageInfoBean getStorageInfo() {
        return this.storageInfo;
    }

    public void setStorageInfo(StorageInfoBean storageInfo) {
        this.storageInfo = storageInfo;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toJson() {
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.IgnoreErrorGetter});
    }

    public String images() {
        StringBuilder imageStringBuilder = new StringBuilder();
        for (Image image : this.images) {
            imageStringBuilder.append(image.getDataSourceId());
            imageStringBuilder.append(image.getFileName());
        }
        return imageStringBuilder.toString();
    }

    public String getGridTreeName() {
        return this.gridTreeName;
    }

    public void setGridTreeName(String gridTreeName) {
        this.gridTreeName = gridTreeName;
    }

    public String getGridName() {
        return this.gridTreeName;
    }

    public Integer[] getBands() {
        return this.bands;
    }

    public void setBands(Integer[] bands) {
        this.bands = bands;
    }

    public Integer getBandCount() {
        return this.bandCount;
    }

    public void setBandCount(Integer bandCount) {
        this.bandCount = bandCount;
    }

    public void setServiceType(Constants.SERVICE_TYPE serviceType) {
        this.serviceType = serviceType;
    }

    public String getBandValueToRGBAScript() {
        return this.bandValueToRGBAScript;
    }

    public void setBandValueToRGBAScript(String bandValueToRGBAScript) {
        this.bandValueToRGBAScript = bandValueToRGBAScript;
    }

    public String getMergeScript() {
        return this.mergeScript;
    }

    public void setMergeScript(String mergeScript) {
        this.mergeScript = mergeScript;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RasterDataServiceBean that = (RasterDataServiceBean)o;
        return new EqualsBuilder().append((Object)this.serviceType, (Object)that.getServiceType()).append((Object)this.srid, (Object)that.getSrid()).append((Object)this.getGridName(), (Object)that.getGridName()).append((Object)this.terrain, (Object)that.isTerrain()).append((Object)this.rasterHandleType, (Object)that.getRasterHandleType()).append((Object)this.images(), (Object)that.images()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 51).append((Object)this.serviceType).append((Object)this.srid).append((Object)this.getGridName()).append((Object)this.rasterHandleType).append((Object)this.terrain).append((Object)this.rasterHandleType).append((Object)this.images()).toHashCode();
    }
}

