/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.data_service.raster;

import com.northpool.resources.Image;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.data_service.raster.RasterDataServiceBean;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import java.util.List;
import org.bson.Document;

public class RasterDataServiceShell
implements IRasterDataService {
    private Client client;
    private RasterDataServiceBean dataService;
    private IStorageInfo storageInfo;

    public RasterDataServiceShell(Client client, RasterDataServiceBean dataService) {
        this.client = client;
        this.dataService = dataService;
        this.storageInfo = this.createStorageInfo(dataService.getStorageInfo());
    }

    @Override
    public String getId() {
        return this.dataService.getId();
    }

    @Override
    public String getVersion() {
        return this.dataService.getVersion();
    }

    @Override
    public Constants.SERVICE_TYPE getServiceType() {
        return this.dataService.getServiceType();
    }

    public String toJson() {
        return this.dataService.toJson();
    }

    public String mark() {
        return this.getId();
    }

    @Override
    public Document toDocument() {
        return Document.parse((String)this.toJson());
    }

    @Override
    public void start() {
        this.dataService.setState(CanStartStop.STATE_TYPE.run);
    }

    @Override
    public void stop() {
        this.dataService.setState(CanStartStop.STATE_TYPE.stop);
    }

    @Override
    public String state() {
        return this.getState().name();
    }

    @Override
    public CanStartStop.STATE_TYPE getState() {
        return this.dataService.getState();
    }

    @Override
    public void rollback(CanStartStop.STATE_TYPE state) {
        this.dataService.setState(state);
    }

    @Override
    public void setVersion(String version) {
        this.dataService.setVersion(version);
    }

    @Override
    public Boolean getReadOnly() {
        return true;
    }

    @Override
    public RasterDataServiceBean getBean() {
        return this.dataService;
    }

    @Override
    public String getLayerName() {
        return this.dataService.getName();
    }

    @Override
    public String getName() {
        return this.dataService.getName();
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void refresh() {
        IRasterDataService dataService = (IRasterDataService)this.client.getRasterDataServiceManager().get(this.getId());
        if (dataService == null) {
            return;
        }
        this.dataService = dataService.getBean();
        List<Image> images = this.dataService.getImages();
        for (Image image : images) {
            String dataSourceId = image.getDataSourceId();
            IDataSourceInService dataSourceInService = this.getDataSource(dataSourceId);
            dataSourceInService.refresh();
        }
    }

    private IDataSourceInService getDataSource(String dataSourceId) {
        IDataSourceInService dataSource = (IDataSourceInService)this.client.getDataSourcesManager().get(dataSourceId);
        if (dataSource == null) {
            throw new RuntimeException(String.format("\u6ca1\u6709dataSourceId\u4e3a %s \u7684\u6570\u636e\u6e90", dataSourceId));
        }
        return dataSource;
    }

    @Override
    public void addStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
        this.getBean().setStorageInfo(storageInfo.getBean());
    }

    @Override
    public IStorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    @Override
    public String getStorageName() {
        return this.dataService.getName() + "_" + this.dataService.getId();
    }

    private IStorageInfo createStorageInfo(StorageInfoBean storageInfo) {
        if (storageInfo != null) {
            return new StorageInfoShell(this.client, storageInfo);
        }
        return null;
    }

    @Override
    public Integer getSrid() {
        return this.dataService.getSrid();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RasterDataServiceShell that = (RasterDataServiceShell)obj;
        return this.dataService.equals(that.getBean());
    }
}

