/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.raster_service;

import com.alibaba.fastjson.JSON;
import com.northpool.bean.JsonableBuilder;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.raster.IRasterDataService;
import com.northpool.service.config.raster_service.IRasterService;
import com.northpool.service.config.raster_service.RasterServiceBean;
import com.northpool.service.config.raster_service.RasterServiceShell;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.layer.RasterLayerBean;
import com.northpool.service.config.raster_service.layer.RasterLayerLevelBean;
import com.northpool.service.config.vector_service.exception.DataServiceNameDuplicateException;
import com.northpool.service.config.vector_service.exception.LayerCreateException;
import com.northpool.service.config.vector_service.exception.NoDataServiceNameException;
import com.northpool.service.config.vector_service.exception.NoSpatialReferenceException;
import com.northpool.service.config.vector_service.exception.SpatialReferenceConflictException;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import com.northpool.spatial.Constants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class RasterServiceBuilder
implements JsonableBuilder<IRasterService>,
DocumentableBuilder<IRasterService> {
    protected Client client;

    public RasterServiceBuilder() {
    }

    public RasterServiceBuilder(Client client) {
        this.client = client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    @Override
    public IRasterService fromDocument(Document document) throws Exception {
        document.remove((Object)"_id");
        return this.fromJson(document.toJson());
    }

    public IRasterService fromJson(String str) throws Exception {
        RasterServiceBean imageService = null;
        try {
            imageService = (RasterServiceBean)JSON.parseObject((String)str, RasterServiceBean.class);
            Constants.SERVICE_TYPE serviceType = imageService.getServiceType();
            if (serviceType != Constants.SERVICE_TYPE.image_service && serviceType != Constants.SERVICE_TYPE.terrain_service) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception(String.format("\u89e3\u6790JSON\u5931\u8d25:%s \u4e0d\u80fd\u7ffb\u8bd1\u6210\u5f71\u50cf\u670d\u52a1\u6216\u5730\u5f62\u670d\u52a1", str));
        }
        RasterServiceShell imageServiceShell = new RasterServiceShell(this.client, imageService);
        return imageServiceShell;
    }

    protected Integer getSrid(List<IRasterDataService> rasterDataServices) {
        HashSet<Integer> sridSet = new HashSet<Integer>();
        HashSet<String> namesSet = new HashSet<String>();
        for (IRasterDataService rasterDataService : rasterDataServices) {
            String dataServiceName = rasterDataService.getName();
            if (StringUtils.isBlank((CharSequence)dataServiceName)) {
                throw new NoDataServiceNameException();
            }
            if (namesSet.contains(dataServiceName)) {
                throw new DataServiceNameDuplicateException(dataServiceName);
            }
            namesSet.add(dataServiceName);
            Integer srid = rasterDataService.getSrid();
            if (srid == null) {
                throw new NoSpatialReferenceException();
            }
            if (!sridSet.contains(srid)) {
                sridSet.add(srid);
            }
            if (sridSet.size() <= 1) continue;
            throw new SpatialReferenceConflictException(sridSet);
        }
        return (Integer)sridSet.iterator().next();
    }

    protected LinkedHashMap<String, RasterDataSetBean> getDataSetMap(List<IRasterDataService> rasterDataServices) {
        LinkedHashMap rasterDataSetMap = rasterDataServices.stream().map(dataService -> {
            RasterDataSetBean dataSet = new RasterDataSetBean();
            dataSet.setId(dataService.getName());
            dataSet.setDataServiceId((String)dataService.getId());
            return dataSet;
        }).collect(Collectors.toMap(dataSetBean -> dataSetBean.getId(), dataSetBean -> dataSetBean, (x, y) -> y, LinkedHashMap::new));
        return rasterDataSetMap;
    }

    protected LinkedHashMap<String, RasterLayerBean> getLayerMap(List<IRasterDataService> rasterDataServices, LinkedHashMap<String, RasterDataSetBean> dataSetMap, Integer beginLevel, Integer endLevel) {
        LinkedHashMap rasterLayerMap = rasterDataServices.stream().map(dataService -> {
            try {
                return this.createRasterLayer((IRasterDataService)dataService, (RasterDataSetBean)dataSetMap.get(dataService.getName()), beginLevel, endLevel);
            }
            catch (Exception e) {
                throw new LayerCreateException(dataService.getName());
            }
        }).collect(Collectors.toMap(layerBean -> layerBean.getId(), layerBean -> layerBean, (x, y) -> y, LinkedHashMap::new));
        return rasterLayerMap;
    }

    protected RasterLayerBean createRasterLayer(IRasterDataService dataService, RasterDataSetBean dataSet, Integer beginLevel, Integer endLevel) {
        RasterLayerBean layer = new RasterLayerBean();
        layer.setBeginLevel(beginLevel);
        layer.setEndLevel(endLevel);
        layer.setId(dataService.getName());
        layer.setLayerType(Constants.LAYER_TYPE.RASTER);
        HashMap<Integer, RasterLayerLevelBean> allLayerLevel = new HashMap<Integer, RasterLayerLevelBean>();
        Integer i = layer.getBeginLevel();
        while (i <= layer.getEndLevel()) {
            RasterLayerLevelBean layerLevel = new RasterLayerLevelBean();
            layerLevel.setDataSetId(dataSet.getId());
            layerLevel.setLevel(i);
            allLayerLevel.put(i, layerLevel);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        layer.setLevelMap(allLayerLevel);
        return layer;
    }
}

