/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.dao;

import com.northpool.bean.Idable;
import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.IBeanShell;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.dao.EventMessage;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.manager.IMetaDataManager;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.message.MetaDataChangeMessage;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.cache.Cache;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteMessaging;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIgniteDao<B, T extends Idable<String> & IBeanShell<B>>
implements IMetaDataDao<T> {
    Logger logger = LoggerFactory.getLogger(AbstractIgniteDao.class);
    protected Ignite ignite;
    protected IgniteMessaging rmtMsg;
    protected IgniteCache<String, B> cache;
    protected QueryHashTableHeap<String, T> table;
    protected String idFieldName;
    protected Client client;
    protected final Boolean readOnly;
    protected String managerRoot;
    protected Boolean isReady = false;
    protected EventContainer<Listener> eventContainer = new EventContainer();
    protected IMetaDataManager<T> manager;
    protected static boolean hasListener = false;
    protected static CompletableFuture<String> listener;
    protected static CompletableFuture<CompletableFuture> listenerIsSet;
    protected static ThreadPoolExecutor pool;

    public AbstractIgniteDao(String idFieldName, QueryHashTableHeap<String, T> table, Client client, String managerRoot, Boolean readOnly, Ignite ignite) {
        this.idFieldName = idFieldName;
        this.table = table;
        this.readOnly = readOnly;
        this.managerRoot = managerRoot;
        this.client = client;
        this.ignite = ignite;
        this.rmtMsg = ignite.message(ignite.cluster().forRemotes());
    }

    @Override
    public void init() {
        try {
            IgniteCache cache = this.ignite.cache(this.managerRoot);
            this.cache = cache == null ? this.createCache() : cache;
            this.addIgniteMessageListener();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.isReady = true;
    }

    protected IgniteCache<String, B> createCache() throws Exception {
        Field[] declaredFields;
        CacheConfiguration cacheCfg = new CacheConfiguration();
        cacheCfg.setName(this.managerRoot);
        cacheCfg.setCacheMode(CacheMode.REPLICATED);
        cacheCfg.setSqlSchema("PUBLIC");
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        Class entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        QueryEntity queryEntity = new QueryEntity(String.class, entityClass);
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            queryEntity.addQueryField(field.getName(), field.getType().getName(), null);
        }
        queryEntity.setKeyFieldName(this.idFieldName);
        queryEntity.setKeyType(String.class.getName());
        cacheCfg.setQueryEntities(Arrays.asList(queryEntity));
        IgniteCache cache = this.ignite.createCache(cacheCfg);
        return cache;
    }

    @Override
    public List<T> findAll() throws Exception {
        Iterator iterator = this.cache.iterator();
        ArrayList<T> list = new ArrayList<T>(this.cache.size(new CachePeekMode[0]));
        while (iterator.hasNext()) {
            Cache.Entry entry = (Cache.Entry)iterator.next();
            list.add(this.getShell(entry.getValue()));
        }
        return list;
    }

    @Override
    public T findOne(String id) throws Exception {
        return this.getShell(this.cache.get((Object)id));
    }

    @Override
    public void insert(T t) throws Exception {
        this.cache.put(t.getId(), ((IBeanShell)t).getBean());
        this.syncWait((String)t.getId(), MetaDataChangeMessage.MetaDataChangeType.CHILD_ADDED);
    }

    @Override
    public boolean exists(String id) throws ZKException {
        return this.cache.containsKey((Object)id);
    }

    @Override
    public void delete(String id) throws Exception {
        this.cache.remove((Object)id);
        this.syncWait(id, MetaDataChangeMessage.MetaDataChangeType.CHILD_REMOVED);
    }

    @Override
    public void update(T t) throws ZKException {
        this.cache.put(t.getId(), ((IBeanShell)t).getBean());
        this.syncWait((String)t.getId(), MetaDataChangeMessage.MetaDataChangeType.CHILD_UPDATED);
    }

    private void syncWait(String id, MetaDataChangeMessage.MetaDataChangeType type) {
        int remoteNodesSize = this.ignite.cluster().forServers().nodes().size() - 1;
        if (remoteNodesSize > 0) {
            MetaDataChangeMessage msg = new MetaDataChangeMessage(type, id, this.path(id) + new Date().getTime());
            this.rmtMsg.send((Object)this.managerRoot, (Object)msg);
            IgniteCountDownLatch latch = this.ignite.countDownLatch(msg.getCountDownId(), remoteNodesSize, true, true);
            latch.await(10L, TimeUnit.SECONDS);
        }
    }

    protected void saveBeanToHashTable(T bean) {
        this.table.insert(bean);
    }

    protected void removeBeanToHashTable(String pk) {
        this.table.remove((Serializable)((Object)pk));
    }

    protected void updateBeanToHashTable(T bean) {
        this.table.update(bean);
    }

    protected abstract T getShell(B var1);

    private void addIgniteMessageListener() throws Exception {
        String listenterPath = this.managerRoot;
        this.rmtMsg.localListen((Object)listenterPath, (IgniteBiPredicate)new IgniteBiPredicate<UUID, MetaDataChangeMessage>(){

            public boolean apply(UUID nodeId, MetaDataChangeMessage msg) {
                IgniteCountDownLatch latch = AbstractIgniteDao.this.ignite.countDownLatch(msg.getCountDownId(), 0, true, false);
                if (latch == null) {
                    AbstractIgniteDao.this.logger.error("\u540c\u6b65\u8ba1\u6570\u5668\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
                }
                String id = msg.getId();
                String path = AbstractIgniteDao.this.path(id);
                MetaDataChangeMessage.MetaDataChangeType type = msg.getType();
                switch (type) {
                    case CHILD_ADDED: {
                        Object bean = AbstractIgniteDao.this.cache.get((Object)id);
                        try {
                            Object shell = AbstractIgniteDao.this.getShell(bean);
                            if (shell instanceof IDataService) {
                                IDataService dataService = (IDataService)shell;
                                ((IDataSource)dataService.getDataSource().getBean()).getTable(dataService.getTableName()).reload();
                            }
                            AbstractIgniteDao.this.saveBeanToHashTable(shell);
                            AbstractIgniteDao.this.triggerEvent(id, type);
                        }
                        catch (Exception e) {
                            AbstractIgniteDao.this.logger.error(AbstractIgniteDao.this.managerRoot + ":" + id + "\u5143\u6570\u636e\u63d2\u5165\u5931\u8d25", (Throwable)e);
                        }
                        break;
                    }
                    case CHILD_REMOVED: {
                        try {
                            AbstractIgniteDao.this.removeBeanToHashTable(id);
                            AbstractIgniteDao.this.triggerEvent(id, type);
                        }
                        catch (Exception e) {
                            AbstractIgniteDao.this.logger.error(AbstractIgniteDao.this.managerRoot + ":" + id + "\u5143\u6570\u636e\u5220\u9664\u5931\u8d25", (Throwable)e);
                        }
                        break;
                    }
                    case CHILD_UPDATED: {
                        Object bean = AbstractIgniteDao.this.cache.get((Object)id);
                        try {
                            Object shell = AbstractIgniteDao.this.getShell(bean);
                            if (shell instanceof IDataService) {
                                IDataService dataService = (IDataService)shell;
                                ((IDataSource)dataService.getDataSource().getBean()).getTable(dataService.getTableName()).reload();
                            }
                            AbstractIgniteDao.this.updateBeanToHashTable(shell);
                            AbstractIgniteDao.this.triggerEvent(id, type);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            AbstractIgniteDao.this.logger.error(AbstractIgniteDao.this.managerRoot + ":" + id + "\u5143\u6570\u636e\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                        }
                        break;
                    }
                }
                latch.countDown();
                return true;
            }
        });
    }

    private void triggerEvent(String id, MetaDataChangeMessage.MetaDataChangeType eventType) throws ExecutionException, InterruptedException {
        System.out.println(this.manager == null);
        System.out.println(hasListener);
        if (hasListener && this.manager != null) {
            CompletableFuture<String> future = null;
            EventMessage message = new EventMessage();
            try {
                future = AbstractIgniteDao.getListener();
                listener = null;
                listenerIsSet = null;
                message.setBeanType(this.managerRoot);
                message.setEventType(eventType.name());
                message.setId(id);
                if (eventType != MetaDataChangeMessage.MetaDataChangeType.CHILD_REMOVED) {
                    message.setBean(this.manager.getJSON(id));
                }
            }
            catch (Exception e) {
                this.logger.error("\u5f15\u64ce\u540c\u6b65\u89e6\u53d1\u5f02\u5e38", (Throwable)e);
                future.completeExceptionally(e);
            }
            future.complete(message.toString());
        }
    }

    private String path(String id) {
        String path = this.managerRoot + "/" + id;
        return path;
    }

    public static CompletableFuture<String> getListener() throws ExecutionException, InterruptedException {
        if (listener != null) {
            return listener;
        }
        listenerIsSet = new CompletableFuture();
        return listenerIsSet.get();
    }

    public static void setListener(Consumer callback, Function exception) {
        hasListener = true;
        listener = new CompletableFuture();
        if (callback != null) {
            listener.thenAcceptAsync(callback);
        }
        if (exception != null) {
            listener.exceptionally(exception);
        }
        if (listenerIsSet != null) {
            listenerIsSet.complete(listener);
        }
    }

    static {
        pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100000), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                throw new RuntimeException("\u961f\u5217\u5df2\u6ee1");
            }
        });
    }
}

