/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.dao.data_sources;

import com.northpool.resources.datasource.IDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.dao.AbstractIgniteDao;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.Arrays;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;

public class DataSourceIgniteDao
extends AbstractIgniteDao<IDataSource, IDataSourceInService> {
    public DataSourceIgniteDao(String idFieldName, QueryHashTableHeap<String, IDataSourceInService> table, Client client, String managerRoot, Boolean readOnly, Ignite ignite) {
        super(idFieldName, table, client, managerRoot, readOnly, ignite);
    }

    @Override
    protected IgniteCache<String, IDataSource> createCache() throws Exception {
        CacheConfiguration cacheCfg = new CacheConfiguration();
        cacheCfg.setName(this.managerRoot);
        cacheCfg.setCacheMode(CacheMode.REPLICATED);
        cacheCfg.setSqlSchema("PUBLIC");
        cacheCfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        QueryEntity queryEntity = new QueryEntity(String.class, IDataSource.class).addQueryField("id", String.class.getName(), null).addQueryField("name", String.class.getName(), null).addQueryField("url", String.class.getName(), null);
        queryEntity.setIndexes(Arrays.asList(new QueryIndex("id")));
        cacheCfg.setQueryEntities(Arrays.asList(queryEntity));
        return this.ignite.createCache(cacheCfg);
    }

    @Override
    protected IDataSourceInService getShell(IDataSource bean) {
        return IDataSourceInService.create(this.client, (String)bean.getId(), (String)bean.getId(), bean);
    }
}

