/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.httpstatistic;

import org.apache.commons.lang3.StringUtils;

public class AccessLogPO {
    public String clientIp = "-";
    public String clientApplication = "-";
    public String serverHost = "-";
    public String url = "-";
    public String refer = "-";
    public String method = "GET";
    public String requestPath = "/";
    public String queryString = "-";
    public long contentLength = 0L;
    public int statusCode = 404;
    public String status = "NOT_FOUND";
    public String timestamp = "-";
    public int pid = 0;
    public int costTimeMs = 0;
    public String vtileServiceName = "-";

    public static AccessLogPO parseTokens(String[] tokens) {
        return new AccessLogPO().parseLine(tokens);
    }

    private AccessLogPO parseLine(String[] tokens) {
        try {
            this.timestamp = tokens[IDX_MAP.DATETIME];
            String strPid = tokens[IDX_MAP.PID];
            if (!StringUtils.isEmpty((CharSequence)strPid) && strPid.startsWith("[")) {
                this.pid = AccessLogPO.tryParseInt(strPid.substring(1, strPid.length() - 1));
            }
            this.vtileServiceName = tokens[IDX_MAP.SVC_NAME];
            this.clientIp = tokens[IDX_MAP.CLI_IP];
            this.method = tokens[IDX_MAP.METHOD];
            this.requestPath = tokens[IDX_MAP.PATH];
            this.statusCode = AccessLogPO.tryParseInt(tokens[IDX_MAP.STATUS_CODE]);
            this.contentLength = AccessLogPO.tryParseInt(tokens[IDX_MAP.CONTENT_LEN]);
            String str = tokens[IDX_MAP.COST_TIME];
            if (!StringUtils.isEmpty((CharSequence)str)) {
                this.costTimeMs = AccessLogPO.tryParseInt(str.replace(" ms", ""));
            }
            this.refer = tokens[IDX_MAP.REFER];
            this.clientApplication = tokens[IDX_MAP.CLI_APP];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    private static int tryParseInt(String str) {
        try {
            if (StringUtils.isEmpty((CharSequence)str)) {
                return 0;
            }
            return Integer.parseInt(str.trim());
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static class IDX_MAP {
        private static int ID = 0;
        public static final int DATETIME = ID++;
        public static final int PID = ID++;
        public static final int CLI_IP = ID++;
        public static final int METHOD = ID++;
        public static final int PATH = ID++;
        public static final int STATUS_CODE = ID++;
        public static final int CONTENT_LEN = ID++;
        public static final int COST_TIME = ID++;
        public static final int REFER = ID++;
        public static final int SVC_NAME = ID++;
        public static final int CLI_APP = ID++;

        private IDX_MAP() {
        }
    }
}

