/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.abstractclass;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.exception.UException;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.manager.abstractclass.AbstractManager;
import com.northpool.service.manager.abstractclass.DocumentableBuilder;
import com.northpool.service.manager.abstractclass.EventMessage;
import com.northpool.service.manager.abstractclass.NotFoundException;
import com.northpool.service.manager.abstractclass.ZKException;

public abstract class ServiceManager<T extends Jsonable & Idable<String> & CanStartStop, Builder extends JsonableBuilder<T> & DocumentableBuilder<T>>
extends AbstractManager<T, Builder> {
    public ServiceManager(Builder beanBuilder, String managerRoot) {
        super(beanBuilder, managerRoot);
    }

    protected T startBean2Table(String id) {
        Object t = this.get(id);
        if (t == null) {
            throw new NotFoundException(id);
        }
        ((CanStartStop)t).start();
        return t;
    }

    protected T stopBean2Table(String id) {
        Object t = this.get(id);
        if (t == null) {
            throw new NotFoundException(id);
        }
        ((CanStartStop)t).stop();
        return t;
    }

    protected void rollback2Table(String id, CanStartStop.STATE_TYPE state) throws NotFoundException {
        Object t = this.get(id);
        if (t == null) {
            throw new NotFoundException(id);
        }
        ((CanStartStop)t).rollback(state);
    }

    public void start(String id) throws Exception {
        T t = this.startBean2Table(id);
        try {
            this.doUpdate(t);
            this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.start.name(), new Object[]{id, t});
        }
        catch (ZKException e) {
            UException.printStackTrace((Throwable)e);
            this.rollback2Table(id, CanStartStop.STATE_TYPE.stop);
            throw e;
        }
    }

    public void stop(String id) throws Exception {
        T t = this.stopBean2Table(id);
        try {
            this.doUpdate(t);
            this.eventContainer.syncFireEvent(EventMessage.EVENT_TYPE.stop.name(), new Object[]{id, t});
        }
        catch (ZKException e) {
            e.printStackTrace();
            this.rollback2Table(id, CanStartStop.STATE_TYPE.run);
            throw e;
        }
    }
}

