/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.xmlloader.raster_service;

import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_source.DataScourceShell;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.raster_service.RasterServiceBean;
import com.northpool.service.config.raster_service.dataset.RasterDataSetBean;
import com.northpool.service.config.raster_service.layer.RasterLayerBean;
import com.northpool.service.config.raster_service.layer.RasterLayerLevelBean;
import com.northpool.service.exception.LoadXmlException;
import com.northpool.service.exception.XmlDefException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.xmlloader.XmlLoader;
import com.northpool.service.xmlloader.vectorservice.AbstractXmlLoader;
import com.northpool.spatial.grid.GridManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ImageServiceLoader
extends AbstractXmlLoader
implements XmlLoader<RasterServiceBean> {
    public static final String VERSION = "v1.0";
    public static final String SERVICE_TYPE = "image_service";
    public static final String LAYER_SUFFIX = "_layer";
    public static final String STORAGE_PREFIX = "storage_";

    public ImageServiceLoader(Client client) {
        super(client);
    }

    @Override
    public RasterServiceBean load(InputStream inXml) throws LoadXmlException {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(inXml);
            Element e = document.getRootElement();
            RasterServiceBean imageService = null;
            if ("vindex".equalsIgnoreCase(e.getName())) {
                Element item = (Element)e.element("ImageServices").elements().get(0);
                imageService = this.parseInfo(item);
            } else {
                imageService = this.parseInfo(e);
            }
            return imageService;
        }
        catch (DocumentException e) {
            throw new LoadXmlException("\u52a0\u8f7dXML\u51fa\u9519" + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new XmlDefException(e.getMessage());
        }
    }

    @Override
    public List<RasterServiceBean> loadList(InputStream inXMl) throws LoadXmlException {
        try {
            SAXReader reader = new SAXReader();
            Document document = reader.read(inXMl);
            Element root = document.getRootElement();
            List items = root.element("ImageServices").elements();
            ArrayList<RasterServiceBean> imageServerRegisterBeanArr = new ArrayList<RasterServiceBean>();
            for (Element item : items) {
                RasterServiceBean imageServerRegisterBean = this.parseInfo(item);
                imageServerRegisterBeanArr.add(imageServerRegisterBean);
            }
            return imageServerRegisterBeanArr;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoadXmlException(e.getMessage());
        }
    }

    @Override
    protected String getValidateXMLPath() {
        return this.getClass().getResource("").getPath() + "image_service_register.xsd";
    }

    private RasterServiceBean parseInfo(Element item) throws Exception {
        RasterServiceBean imageService = RasterServiceBean.initImage();
        this.getInfoByStr(item, imageService, "Id");
        try {
            String gridTreeName = "";
            if (item.elementText("Grid") != null) {
                gridTreeName = item.elementText("Grid");
            } else {
                String gridBase = "degree";
                if (item.elementText("GridUnit") != null) {
                    gridBase = item.elementText("GridUnit");
                }
                gridTreeName = "tdt_" + gridBase + "_base512";
            }
            if (GridManager.getQuadtreeGrid((String)gridTreeName) == null) {
                throw new RuntimeException("\u6ca1\u6709\u627e\u5230\u7f51\u683c " + gridTreeName);
            }
            imageService.setGridTreeName(gridTreeName);
            Map<String, IDataSourceInService> dataSourceShellMap = this.getDataSourceMap(item);
            Map<String, RasterDataSetBean> dataSetMap = this.getRasterDataSetMap(item, dataSourceShellMap);
            imageService.setDataSetMap(dataSetMap);
            LinkedHashMap<String, RasterLayerBean> layerMap = this.getLayerMap(item, dataSetMap);
            imageService.setLayerMap(layerMap);
            return imageService;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoadXmlException(imageService.getId() + "\u89e3\u6790" + e.getMessage());
        }
    }

    protected Map<String, IDataSourceInService> getDataSourceMap(Element root) throws Exception {
        HashMap<String, IDataSourceInService> dataSourceMap = new HashMap<String, IDataSourceInService>();
        List items = root.element("DataSources").elements();
        for (Element item : items) {
            IDataSource dataSource = this.createDataSource(item);
            String idInXML = (String)dataSource.getId();
            IDataSourceInService dataScourceShell = this.autoRegisterDataSource(dataSource);
            dataSourceMap.put(idInXML, dataScourceShell);
        }
        return dataSourceMap;
    }

    protected IDataSourceInService autoRegisterDataSource(IDataSource dataSource) throws Exception {
        String mark = dataSource.mark();
        QueryFilter queryFilter = new QueryFilter();
        queryFilter.addFilter("mark", Constants.OPERATION.EQ, new Object[]{mark});
        IDataSourcesManager dataSourcesManager = this.client.getDataSourcesManager();
        IDataSourceInService dataScourceShell = (IDataSourceInService)dataSourcesManager.findOne(queryFilter);
        if (dataScourceShell == null) {
            String id = "autocreate_" + mark;
            dataScourceShell = new DataScourceShell(this.client, id, id, dataSource);
            if (dataSourcesManager.get(id) != null) {
                if (!dataScourceShell.equals(dataSourcesManager.get(id))) {
                    id = id + System.currentTimeMillis();
                    dataScourceShell = new DataScourceShell(this.client, id, id, dataSource);
                    dataSourcesManager.register(dataScourceShell);
                }
                return dataScourceShell;
            }
            try {
                dataSourcesManager.register(dataScourceShell);
            }
            catch (ZKException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            return dataScourceShell;
        }
        return dataScourceShell;
    }

    private LinkedHashMap<String, RasterLayerBean> getLayerMap(Element root, Map<String, RasterDataSetBean> dataSetMap) throws Exception {
        LinkedHashMap<String, RasterLayerBean> layerMap = new LinkedHashMap<String, RasterLayerBean>();
        List items = root.element("Layers").elements();
        for (Element item : items) {
            RasterLayerBean layer = this.createLayer(item, dataSetMap);
            if (layer == null) continue;
            layerMap.put(layer.getId(), layer);
        }
        return layerMap;
    }

    private RasterLayerBean createLayer(Element info, Map<String, RasterDataSetBean> dataSetMap) throws Exception {
        String layerId = info.attributeValue("Id");
        try {
            RasterLayerBean layer = new RasterLayerBean();
            this.getInfoByStr(info, layer, "Id,BeginLevel,EndLevel");
            Map<Integer, RasterLayerLevelBean> allLayerLevel = new HashMap<Integer, RasterLayerLevelBean>();
            Integer i = layer.getBeginLevel();
            while (i <= layer.getEndLevel()) {
                RasterLayerLevelBean layerLevel = new RasterLayerLevelBean();
                layerLevel.setLevel(i);
                allLayerLevel.put(i, layerLevel);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            allLayerLevel = this.addDataSetToLayerLevel(info, allLayerLevel, dataSetMap);
            layer.setLevelMap(allLayerLevel);
            return layer;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(String.format("\u56fe\u5c42%s:%s", layerId, e.getMessage()));
        }
    }

    private Map<Integer, RasterLayerLevelBean> addDataSetToLayerLevel(Element info, Map<Integer, RasterLayerLevelBean> allLayerLevel, Map<String, RasterDataSetBean> dataSetMap) throws Exception {
        if (info.element("DataSet").elements().size() == 0) {
            String dataSetId = info.element("DataSet").getTextTrim();
            if (dataSetMap.get(dataSetId) == null) {
                throw new Exception(String.format("\u6ca1\u6709\u627e\u5230\u6570\u636e\u96c6%s", dataSetId));
            }
            allLayerLevel.entrySet().forEach(entry -> ((RasterLayerLevelBean)entry.getValue()).setDataSetId(dataSetId));
        } else {
            List items = info.element("DataSet").elements();
            Object fieldsList = null;
            for (Element item : items) {
                Integer end;
                String dataSetId = this.getDataSetId(item);
                RasterDataSetBean dataSet = dataSetMap.get(dataSetId);
                if (dataSet == null) {
                    throw new Exception(String.format("\u6ca1\u6709\u627e\u5230\u6570\u636e\u96c6%s", dataSetId));
                }
                Integer begin = this.getInteger(item, "begin");
                if (begin == null) {
                    begin = this.getInteger(item, "Begin");
                }
                if ((end = this.getInteger(item, "end")) == null) {
                    end = this.getInteger(item, "End");
                }
                Integer level = begin;
                while (level <= end) {
                    RasterLayerLevelBean layerLevel = allLayerLevel.get(level);
                    layerLevel.setDataSetId(dataSetId);
                    Integer n = level;
                    Integer n2 = level = Integer.valueOf(level + 1);
                }
            }
        }
        return allLayerLevel;
    }

    private String getDataSetId(Element item) {
        String dataSetName = item.elements().isEmpty() ? item.getStringValue() : item.elementText("DataSetId");
        return dataSetName;
    }
}

