/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.client;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.northpool.commons.conf.BaseConfig;
import com.northpool.devtool.AbnormalCheck.CpuCheck;
import com.northpool.devtool.AbnormalCheck.MongoCheck;
import com.northpool.devtool.AbnormalCheck.ZookeeperCheck;
import com.northpool.devtool.model.ZookeeperInfo;
import com.northpool.resources.MongodbDataSourceManager;
import com.northpool.resources.datasource.db.JDBCPoolManager;
import com.northpool.resources.utils.MongoClientURI;
import com.northpool.service.manager.ManagerFactory;
import com.northpool.service.manager.cell.ITileDataCellManager;
import com.northpool.service.manager.data_service.IDataServiceManager;
import com.northpool.service.manager.data_sources.IDataSourcesManager;
import com.northpool.service.manager.exception.ManagerDuplicateException;
import com.northpool.service.manager.exception.ManagerNotFoundException;
import com.northpool.service.manager.font.IFontManager;
import com.northpool.service.manager.node.INodeManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.task.ITaskManager;
import com.northpool.service.manager.texture.ITextureManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.service.mapserver.MapServerAccess;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.ForkJoinPool;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.cluster.ClusterState;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.DataPageEvictionMode;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.configuration.PageReplacementMode;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client {
    private static final int DEFAULT_SESSION_TIMEOUT_MS = Integer.getInteger("curator-default-session-timeout", 60000);
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = Integer.getInteger("curator-default-connection-timeout", 15000);
    protected String zkAddress;
    protected CuratorFramework zkClient;
    protected Ignite ignite;
    protected MongoDatabase mongoDatabase = null;
    protected MapServerAccess mapServerAccess;
    protected Logger logger = LoggerFactory.getLogger((String)"Client");
    public static String CMD_REQUEST = "/request";
    public static String CMD_RESPONSE = "/response";
    public static final String CMD_CREATE_TIME = "/time";
    public static final String ROOT = "/northpool_service_root";
    protected IDataSourcesManager dataSourcesManager;
    protected IDataServiceManager dataServiceManager;
    protected IVectorServiceManager vectorServiceManager;
    protected ITextureManager textureManager;
    protected IStyleManager styleManager;
    protected IFontManager fontManager;
    protected ITaskManager taskManager;
    protected ITileDataCellManager tileDataCellManager;
    protected INodeManager nodeManager;
    private Integer httpMaxTotal = Runtime.getRuntime().availableProcessors();
    static Client client;

    public Client(String zkAddress) throws Exception {
        this.zkAddress = zkAddress;
        this.zkClient = this.initZkClient(zkAddress);
        this.logger.info("zk\u6b63\u5728\u8fde\u63a5");
        System.setProperty("javax.net.ssl.trustStore", "mongo");
        System.setProperty("javax.net.ssl.trustStorePassword", "changeit");
        System.setProperty("javax.net.ssl.keyStore", "mongoclient");
        System.setProperty("javax.net.ssl.keyStorePassword", "123456");
        this.initManager();
    }

    public static Client getInstance() {
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Client getInstance(String mongoUri, String zkAddress, String mapserverUrl) throws Exception {
        if (client != null) return client;
        Class<Client> clazz = Client.class;
        synchronized (Client.class) {
            if (client != null) return client;
            client = new Client(mongoUri, zkAddress, mapserverUrl);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return client;
        }
    }

    public Client(String mongoUri, String zkAddress, String mapserverUrl) throws Exception {
        String trustStore = System.getenv("trustStore");
        String trustStorePassword = System.getenv("trustStorePassword");
        String keyStore = System.getenv("keyStore");
        String keyStorePassword = System.getenv("keyStorePassword");
        if (trustStore != null && trustStorePassword != null) {
            System.setProperty("javax.net.ssl.trustStore", trustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        }
        if (keyStore != null && keyStorePassword != null) {
            System.setProperty("javax.net.ssl.keyStore", keyStore);
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePassword);
        }
        CpuCheck.getInst().check();
        this.mongoDatabase = this.initMongoClient(mongoUri);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{zkAddress})) {
            this.zkAddress = zkAddress;
            this.zkClient = this.initZkClient(zkAddress);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        this.checkConsistency();
        this.initManager();
        client = this;
    }

    private void checkConsistency() {
        if (null == this.zkClient) {
            throw new RuntimeException("zookeeper \u672a\u8fde\u63a5");
        }
        String key = "/northpool_service_root/vtile_cluster";
        try {
            byte[] readData = (byte[])this.zkClient.getData().forPath(key);
            String val = new String(readData);
            if (BaseConfig.VERSION.equals(val)) {
                return;
            }
            this.logger.error("\u77e2\u91cf\u74e6\u7247\u5185\u6838\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5907\u4efd\u597d\u4e1a\u52a1\u5e93\u540e\uff0c\u91cd\u65b0\u914d\u7f6e\u6b63\u786e\u7684\u4e1a\u52a1\u5e93\u73af\u5883");
        }
        catch (KeeperException.NoNodeException nnex) {
            this.logger.error("\u8282\u70b9\u4e0d\u5b58\u5728\uff1a" + key + ", \u5f53\u524d\u73af\u5883\u53ef\u80fd\u5c5e\u4e8e\u8001\u7248\u672c\u77e2\u91cf\u74e6\u7247\u4e1a\u52a1\u5e93\u914d\u7f6e\u3002\u5efa\u8bae\u5907\u4efd\u597d\u5f53\u524d\u4e1a\u52a1\u5e93\u548czookeeper\u6570\u636e\u540e\uff0c\u91cd\u8bd5\u542f\u52a8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.shutdown();
        }
        try {
            this.logger.warn("\u8bf7\u7acb\u5373\u9000\u51fa\u77e2\u91cf\u74e6\u7247\u7cfb\u7edf\u5e76\u5907\u4efd\u4e1a\u52a1\u5e93\uff01\u82e5\u65e0\u64cd\u4f5c\uff0c1\u5206\u949f\u4e4b\u540e\u81ea\u52a8\u7ee7\u7eed\u542f\u52a8\u5f53\u524d\u7248\u672c\u7cfb\u7edf\uff0c\u53ef\u80fd\u4f1a\u8986\u76d6\u76f8\u5173\u4e1a\u52a1\u6570\u636e\u4fe1\u606f\uff01");
            Thread.sleep(60000L);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            byte[] data = BaseConfig.VERSION.getBytes();
            this.zkClient.create().forPath(key, data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Client(String mongoUri, String zkAddress, String mapserverUrl, boolean isDebug) throws Exception {
        if (!isDebug) {
            throw new Exception("\u6b64\u6784\u9020\u51fd\u6570\u53ea\u80fd\u7528\u4e8eDEBUG\u6a21\u5f0f");
        }
        this.mongoDatabase = this.initMongoClient(mongoUri);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{zkAddress})) {
            this.zkAddress = zkAddress;
            this.zkClient = this.initZkClient(zkAddress);
        }
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        ManagerFactory.setLoader(Thread.currentThread().getContextClassLoader());
        this.dataSourcesManager = ManagerFactory.getManager(IDataSourcesManager.class, this);
        this.dataServiceManager = ManagerFactory.getManager(IDataServiceManager.class, this);
        this.vectorServiceManager = ManagerFactory.getManager(IVectorServiceManager.class, this);
    }

    public Client(String igniteAddress, Integer igniteClientPort, String igniteMcastGrp, String mapserverUrl) throws Exception {
        this.initIgniteByMultiCastMode(igniteAddress, igniteClientPort, igniteMcastGrp);
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{mapserverUrl})) {
            MapServerAccess.setUrlPrifix(mapserverUrl);
        }
        this.initManager();
    }

    public void shutdown() {
        this.logger.error("\u7a0b\u5e8f\u5df2\u5173\u95ed\u3002\u3002\u3002");
        System.exit(0);
    }

    private void initIgniteByMultiCastMode(String igniteAddress, Integer igniteClientPort, String igniteMcastGrp) {
        IgniteConfiguration cfg = new IgniteConfiguration();
        String property = System.getProperty("user.dir");
        cfg.setWorkDirectory(property + File.separator + "ignitedb");
        cfg.setClientMode(false);
        cfg.setPeerClassLoadingEnabled(true);
        DataStorageConfiguration storageCfg = new DataStorageConfiguration();
        DataRegionConfiguration defaultDataRegionConfiguration = storageCfg.getDefaultDataRegionConfiguration();
        defaultDataRegionConfiguration.setPersistenceEnabled(true);
        defaultDataRegionConfiguration.setMaxSize(0x3200000L);
        defaultDataRegionConfiguration.setPageReplacementMode(PageReplacementMode.SEGMENTED_LRU);
        defaultDataRegionConfiguration.setPageEvictionMode(DataPageEvictionMode.RANDOM_LRU);
        cfg.setDataStorageConfiguration(storageCfg);
        TcpDiscoveryMulticastIpFinder ipFinder = new TcpDiscoveryMulticastIpFinder();
        if (StringUtils.isNotEmpty((CharSequence)igniteAddress)) {
            ipFinder.setAddresses(Collections.singletonList(igniteAddress));
        }
        if (StringUtils.isNotEmpty((CharSequence)igniteMcastGrp)) {
            ipFinder.setMulticastGroup(igniteMcastGrp);
        }
        cfg.setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)ipFinder));
        if (igniteClientPort != null) {
            ClientConnectorConfiguration clientConnectorCfg = new ClientConnectorConfiguration();
            clientConnectorCfg.setPort(igniteClientPort.intValue());
            clientConnectorCfg.setPortRange(0);
            cfg.setClientConnectorConfiguration(clientConnectorCfg);
        }
        this.ignite = Ignition.start((IgniteConfiguration)cfg);
        this.ignite.cluster().state(ClusterState.ACTIVE);
        this.ignite.cluster().setBaselineTopology(this.ignite.cluster().forServers().nodes());
        this.ignite.resetLostPartitions(this.ignite.cacheNames());
    }

    public void initManager() throws Exception {
        try {
            ManagerFactory.setLoader(Thread.currentThread().getContextClassLoader());
            this.dataSourcesManager = ManagerFactory.getManager(IDataSourcesManager.class, this);
            this.dataServiceManager = ManagerFactory.getManager(IDataServiceManager.class, this);
            this.vectorServiceManager = ManagerFactory.getManager(IVectorServiceManager.class, this);
            this.textureManager = ManagerFactory.getManager(ITextureManager.class, this);
            this.styleManager = ManagerFactory.getManager(IStyleManager.class, this);
            this.fontManager = ManagerFactory.getManager(IFontManager.class, this);
            this.tileDataCellManager = ManagerFactory.getManager(ITileDataCellManager.class, this);
            this.nodeManager = ManagerFactory.getManager(INodeManager.class, this);
        }
        catch (ManagerDuplicateException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ManagerNotFoundException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private synchronized CuratorFramework initZkClient(String zkAddress) {
        ZookeeperCheck.getInst(zkAddress).check();
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        ZookeeperInfo zkInfo = new ZookeeperInfo(zkAddress);
        if (zkInfo.hasAuth().booleanValue()) {
            builder.authorization("digest", (zkInfo.getUser() + ":" + zkInfo.getPassword()).getBytes());
        }
        CuratorFramework client = builder.connectString(zkInfo.getAddress()).retryPolicy((RetryPolicy)new RetryNTimes(10, 5000)).sessionTimeoutMs(DEFAULT_SESSION_TIMEOUT_MS).connectionTimeoutMs(DEFAULT_CONNECTION_TIMEOUT_MS).build();
        client.start();
        return client;
    }

    public MongoDatabase initMongoClient(String uri) {
        MongoClient mongoClient;
        MongoCheck.getInst(uri).check();
        try {
            mongoClient = MongodbDataSourceManager.aquireMongoClient((String)uri);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        MongoClientURI mongoClientURI = new MongoClientURI(uri);
        return mongoClient.getDatabase(mongoClientURI.getDatabase());
    }

    public CuratorFramework getZoo() {
        return this.zkClient;
    }

    public IVectorServiceManager getVectorServiceManager() {
        return this.vectorServiceManager;
    }

    public IDataSourcesManager getDataSourcesManager() {
        return this.dataSourcesManager;
    }

    public IDataServiceManager getDataServiceManager() {
        return this.dataServiceManager;
    }

    public ITextureManager getTextureManager() {
        return this.textureManager;
    }

    public IStyleManager getStyleManager() {
        return this.styleManager;
    }

    public IFontManager getFontManager() {
        return this.fontManager;
    }

    public ITaskManager getTaskManager() {
        return this.taskManager;
    }

    public ITileDataCellManager getTileDataCellManager() {
        return this.tileDataCellManager;
    }

    public INodeManager getNodeManager() {
        return this.nodeManager;
    }

    public String getZkAddress() {
        return this.zkAddress;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public MongoDatabase initMongoClient() {
        return this.mongoDatabase;
    }

    public void setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public MapServerAccess getMapServerAccess() {
        return new MapServerAccess(this.httpMaxTotal, 180000);
    }

    public void setMapServerAccess(MapServerAccess mapServerAccess) {
        this.mapServerAccess = mapServerAccess;
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    public HashMap<String, Object> getPoolMetrics() {
        try {
            LinkedHashMap<String, Object> poolMetrics = new LinkedHashMap<String, Object>();
            poolMetrics.put("mgpools", MongodbDataSourceManager.getMgpoolMetrics());
            poolMetrics.put("dbpools", JDBCPoolManager.getDruidpoolMetrics());
            ForkJoinPool tpool = ForkJoinPool.commonPool();
            HashMap<String, Integer> poolStat = new HashMap<String, Integer>();
            poolStat.put("parallelism", tpool.getParallelism());
            poolStat.put("workersCount", tpool.getPoolSize());
            poolStat.put("runingCount", tpool.getActiveThreadCount());
            poolStat.put("waitingCount", (int)tpool.getQueuedTaskCount());
            poolStat.put("stealCount", (int)tpool.getStealCount());
            poolMetrics.put("commonThreadPool", poolStat);
            return poolMetrics;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }
}

