/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.dao;

import com.github.javaparser.utils.Log;
import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.JsonableBuilder;
import com.northpool.commons.event.EventContainer;
import com.northpool.commons.event.Listener;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.operate.TableOperatorManager;
import com.northpool.resources.exception.IdExistsException;
import com.northpool.service.client.Client;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.dao.EventMessage;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.dao.IMongoDao;
import com.northpool.service.manager.IMetaDataManager;
import com.northpool.service.manager.abstractclass.Json2BeanFailedException;
import com.northpool.service.manager.abstractclass.ZKException;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkDao<T extends Jsonable & Idable<String>, Builder extends JsonableBuilder<T>>
implements IMetaDataDao<T> {
    Logger logger = LoggerFactory.getLogger(AbstractZkDao.class);
    protected QueryHashTableHeap<String, T> table;
    protected String idFieldName;
    protected Client client;
    protected final Boolean readOnly;
    protected String managerRoot;
    protected PathChildrenCache HolderCache;
    protected static final String INFO_FIELD = "version";
    protected Builder beanBuilder;
    protected Boolean isReady = false;
    protected EventContainer<Listener> eventContainer = new EventContainer();
    protected IMetaDataManager<T> manager;
    protected IMongoDao<T> mongoDao;
    protected static boolean hasListener = false;
    protected static CompletableFuture<String> listener;
    protected static CompletableFuture<CompletableFuture> listenerIsSet;
    protected final Integer MAX_MONGO_RETRY = 200;
    protected static ThreadPoolExecutor pool;

    public AbstractZkDao(String idFieldName, Builder beanBuilder, QueryHashTableHeap<String, T> table, Client client, String managerRoot, Boolean readOnly) {
        this.idFieldName = idFieldName;
        this.table = table;
        this.readOnly = readOnly;
        this.managerRoot = "/northpool_service_root" + "/" + managerRoot;
        this.client = client;
        this.beanBuilder = beanBuilder;
    }

    @Override
    public void init() throws Exception {
        this.createRoot();
        this.syncToZK();
        this.addZKListener();
        this.isReady = true;
    }

    @Override
    public List<T> findAll() {
        return this.mongoDao.find((Bson)new BsonDocument());
    }

    @Override
    public T findOne(String id) {
        return this.mongoDao.findone(id);
    }

    private void createRoot() throws Exception {
        if (this.client.getZoo().checkExists().forPath(this.managerRoot) == null) {
            ((ACLBackgroundPathAndBytesable)this.client.getZoo().create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.managerRoot);
        }
    }

    private synchronized void syncToZK() throws Exception {
        this.isReady = false;
        this.createRoot();
        List nodes = (List)this.client.getZoo().getChildren().forPath(this.managerRoot);
        nodes = nodes.stream().map(path -> {
            int index = path.lastIndexOf("/");
            if (index != -1) {
                return path.substring(index);
            }
            return path;
        }).collect(Collectors.toList());
        List<T> all = this.findAll();
        if (all != null && !all.isEmpty()) {
            for (Jsonable t : all) {
                if (nodes.contains(((Idable)t).getId())) continue;
                try {
                    this.insert2Zk(t);
                }
                catch (KeeperException.NodeExistsException ex) {
                    Log.error((String)("\u5f02\u5e38\uff1a\u540c\u6b65mongo\u5143\u6570\u636e\u4fe1\u606f\u5230zookeeper\u5931\u8d25\uff0czookeeper\u4e2d\u5df2\u5b58\u5728" + this.managerRoot + "\u5b9e\u4f53\uff0cId=" + (String)((Idable)t).getId()), (Supplier[])new Supplier[0]);
                }
            }
        }
        this.isReady = true;
    }

    @Override
    public void insert(T t) throws Exception {
        this.mongoDao.insertOne(t);
        this.insert2Zk(t);
    }

    protected void insert2Zk(T t) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        List<CuratorOp> iList = this.createBeanNode(transaction, t);
        this.client.getZoo().transaction().forOperations(iList);
    }

    private String getVersionFromZK(String id) throws Exception {
        byte[] info_byte;
        String path = this.path(id);
        String data_path = path + "/" + INFO_FIELD;
        try {
            info_byte = (byte[])this.client.getZoo().getData().forPath(data_path);
        }
        catch (Exception e) {
            return null;
        }
        return new String(info_byte, "utf-8");
    }

    private T getFromMongo(String id) throws Exception {
        try {
            T bean = this.mongoDao.findone(id);
            return bean;
        }
        catch (Exception e) {
            this.logger.info(this.managerRoot + "/" + id + "\u53cd\u5e8f\u5217\u5316\u5931\u8d25:" + e.getMessage());
            if (id.startsWith("temp_")) {
                this.delete(id);
            }
            throw new Json2BeanFailedException(e);
        }
    }

    protected void saveBeanToHashTable(T bean) {
        this.table.insert(bean);
    }

    protected void removeBeanToHashTable(String pk) {
        this.table.remove((Serializable)((Object)pk));
    }

    protected void updateBeanToHashTable(T bean) {
        this.table.update(bean);
    }

    private void addZKListener() throws Exception {
        String listenterPath = this.managerRoot;
        this.HolderCache = new PathChildrenCache(this.client.getZoo(), listenterPath, true);
        this.HolderCache.getListenable().addListener((client, event) -> {
            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_SUSPENDED) return;
            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_RECONNECTED) return;
            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_LOST) {
                return;
            }
            ChildData data = event.getData();
            String path = new String(data.getData(), "utf-8");
            int index = path.lastIndexOf("/");
            String id = path;
            if (index != -1) {
                id = path.substring(index);
            }
            Object future = null;
            switch (event.getType()) {
                case CHILD_ADDED: {
                    T bean = this.getFromMongo(id);
                    Integer retryTimes = 0;
                    while (bean == null) {
                        if (retryTimes > this.MAX_MONGO_RETRY) {
                            throw new RuntimeException("\u8d85\u8fc7\u6700\u5927\u91cd\u8bd5\u6b21\u6570\uff0cMongo\u4e1a\u52a1\u5e93\u548czookeeper\u6570\u636e\u4e0d\u540c\u6b65\uff0c\u8bf7\u68c0\u67e5\u5f15\u64ce\u6216\u77e2\u91cf\u74e6\u7247\u7ba1\u7406\u7cfb\u7edf\u7684Mongo\u4e1a\u52a1\u5e93\u914d\u7f6e\u662f\u5426\u4e00\u81f4");
                        }
                        this.logger.warn(this.getClass().getName() + ":\u4ecemongo\u518d\u6b21\u83b7\u53d6id\u4e3a" + id + "\u7684\u6570\u636e");
                        bean = this.getFromMongo(id);
                        Thread.sleep(100L);
                        Integer n = retryTimes;
                        Integer n2 = retryTimes = Integer.valueOf(retryTimes + 1);
                    }
                    try {
                        if (this.table.get((Serializable)((Object)id)) == null) {
                            this.saveBeanToHashTable(bean);
                        }
                        if (bean instanceof IDataService) {
                            IDataService dataService = (IDataService)bean;
                            this.logger.info("\u5237\u65b0\u6570\u636e\u670d\u52a1\u8868" + dataService.getDataSource());
                            TableOperatorManager.getInstance().remove((IDataSource)dataService.getDataSource().getBean(), dataService.getTableName());
                            ((IDataSource)dataService.getDataSource().getBean()).getTable(dataService.getTableName()).reload();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (e.getCause() == null) throw e;
                        if (!(e.getCause() instanceof IdExistsException)) throw e;
                    }
                    this.triggerEvent(id, event.getType());
                    return;
                }
                case CHILD_REMOVED: {
                    boolean isExists = this.exists(id);
                    if (!isExists) {
                        this.removeBeanToHashTable(id);
                    } else {
                        IVersionAble service;
                        String version = this.getVersionFromZK(id);
                        Jsonable cacheBean = (Jsonable)this.table.get((Serializable)((Object)id));
                        if (cacheBean instanceof IVersionAble && ObjectUtils.notEqual((Object)(service = (IVersionAble)cacheBean).getVersion(), (Object)version)) {
                            this.removeBeanToHashTable(id);
                        }
                    }
                    this.triggerEvent(path, event.getType());
                    return;
                }
            }
        }, (Executor)pool);
        this.HolderCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
    }

    private void triggerEvent(String id, PathChildrenCacheEvent.Type eventType) throws ExecutionException, InterruptedException {
        if (hasListener && this.manager != null) {
            CompletableFuture<String> future = null;
            EventMessage message = new EventMessage();
            try {
                future = AbstractZkDao.getListener();
                listener = null;
                listenerIsSet = null;
                message.setBeanType(this.managerRoot);
                message.setEventType(eventType.name());
                message.setId(id);
                if (eventType != PathChildrenCacheEvent.Type.CHILD_REMOVED) {
                    message.setBean(this.manager.getJSON(id));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                future.completeExceptionally(e);
            }
            future.complete(message.toString());
        }
    }

    @Override
    public boolean exists(String id) throws ZKException {
        boolean isExists = false;
        try {
            boolean bl = isExists = this.client.getZoo().checkExists().forPath(this.path(id)) != null;
            if (isExists && this.findOne(id) == null) {
                this.removeFromZk(id);
                isExists = false;
            }
        }
        catch (Exception e) {
            throw new ZKException(e);
        }
        return isExists;
    }

    protected String path(String id) {
        String path = this.managerRoot + "/" + id;
        return path;
    }

    private void isReady() throws ZKException {
        if (!this.isReady.booleanValue()) {
            throw new ZKException("ZK\u5ba2\u6237\u7aef\u6ca1\u6709\u51c6\u5907\u597d");
        }
    }

    protected List<CuratorOp> createBeanNode(TransactionOp transaction, T t) throws Exception {
        String id = (String)((Idable)t).getId();
        String path = this.path(id);
        ArrayList<CuratorOp> iList = new ArrayList<CuratorOp>();
        CuratorOp createOp1 = (CuratorOp)((ACLPathAndBytesable)transaction.create().withMode(CreateMode.PERSISTENT)).forPath(path, id.getBytes("utf-8"));
        iList.add(createOp1);
        CuratorOp createOp2 = (CuratorOp)transaction.create().forPath(path + "/id", ((String)((Idable)t).getId()).getBytes("utf-8"));
        iList.add(createOp2);
        if (t instanceof IVersionAble) {
            String version = ((IVersionAble)t).getVersion();
            if (version == null) {
                version = new Date().getTime() + "";
            }
            CuratorOp createOp3 = (CuratorOp)transaction.create().forPath(path + "/" + INFO_FIELD, version.getBytes("utf-8"));
            iList.add(createOp3);
        }
        this.AddExtendsInfo2BeanNode(path, iList, transaction, t);
        return iList;
    }

    protected List<CuratorOp> deleteBeanNode(TransactionOp transaction, String id) throws Exception {
        String path = this.path(id);
        ArrayList<CuratorOp> iList = new ArrayList<CuratorOp>();
        List nodes = (List)this.client.getZoo().getChildren().forPath(path);
        for (String node : nodes) {
            String sub_path = path + "/" + node;
            CuratorOp delete_sub_node = (CuratorOp)transaction.delete().forPath(sub_path);
            iList.add(delete_sub_node);
        }
        CuratorOp delete = (CuratorOp)transaction.delete().forPath(path);
        iList.add(delete);
        return iList;
    }

    protected abstract void AddExtendsInfo2BeanNode(String var1, List<CuratorOp> var2, TransactionOp var3, T var4) throws Exception;

    @Override
    public void delete(String id) throws Exception {
        this.mongoDao.deleteone(id);
        this.removeFromZk(id);
    }

    private void removeFromZk(String id) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        List<CuratorOp> iList = this.deleteBeanNode(transaction, id);
        this.client.getZoo().transaction().forOperations(iList);
    }

    @Override
    public void update(T t) throws Exception {
        String id = (String)((Idable)t).getId();
        String path = this.path(id);
        this.mongoDao.updateOne(id, t);
        if (this.client.getZoo().checkExists().forPath(path) == null) {
            this.insert2Zk(t);
        } else {
            this.update2Zk(t, id);
        }
    }

    protected void update2Zk(T t, String id) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        ArrayList<CuratorOp> iListUpdate = new ArrayList<CuratorOp>();
        List<CuratorOp> iListDelete = this.deleteBeanNode(transaction, id);
        iListUpdate.addAll(iListDelete);
        List<CuratorOp> iListAdd = this.createBeanNode(transaction, t);
        iListUpdate.addAll(iListAdd);
        this.client.getZoo().transaction().forOperations(iListUpdate);
    }

    public static CompletableFuture<String> getListener() throws ExecutionException, InterruptedException {
        if (listener != null) {
            return listener;
        }
        listenerIsSet = new CompletableFuture();
        return listenerIsSet.get();
    }

    public static void setListener(Consumer callback, Function exception) {
        hasListener = true;
        listener = new CompletableFuture();
        if (callback != null) {
            listener.thenAcceptAsync(callback);
        }
        if (exception != null) {
            listener.exceptionally(exception);
        }
        if (listenerIsSet != null) {
            listenerIsSet.complete(listener);
        }
    }

    static {
        pool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100000), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                throw new RuntimeException("\u961f\u5217\u5df2\u6ee1");
            }
        });
    }
}

