/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.httpstatistic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.node.config.INodeService;
import com.northpool.node.statistics.StatisticsLog;
import com.northpool.service.client.Client;
import com.northpool.service.httpstatistic.AccessLogPO;
import com.northpool.service.httpstatistic.HttpStatisticIndices;
import com.northpool.service.manager.node.INodeManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessLogMonitor
implements Runnable {
    private static Logger Log = LoggerFactory.getLogger(AccessLogMonitor.class);
    private static int INTERVAL_SECONDS = 3600;
    private static boolean DELETE_LOGFILE_AFTER_USE = true;
    private static boolean ARCHIVE_LOGFILE = true;
    private String logPath;
    private String options;
    private boolean isWorking;

    public AccessLogMonitor(String logPath, String options) {
        this.logPath = logPath;
        this.options = options;
        this.isWorking = true;
    }

    public static void setLogMonitorOn(String logPath, String options) {
        AccessLogMonitor monitor = new AccessLogMonitor(logPath, options);
        AccessLogMonitor.parseOptions(options);
        Log.info("Setting HTTP access-log monitor on");
        Thread thd = new Thread(monitor);
        thd.setDaemon(true);
        thd.start();
    }

    private static void parseOptions(String options) {
        try {
            int optInterval;
            if (StringUtils.isEmpty((CharSequence)options)) {
                return;
            }
            JSONObject opt = JSON.parseObject((String)options);
            if (opt.containsKey((Object)"interval") && (optInterval = opt.getInteger("interval").intValue()) > 0) {
                INTERVAL_SECONDS = optInterval;
            }
            if (opt.containsKey((Object)"archiveLogs")) {
                boolean archiveLog;
                ARCHIVE_LOGFILE = archiveLog = opt.getBoolean("archiveLogs").booleanValue();
            }
            if (opt.containsKey((Object)"deleteLogs")) {
                boolean deleteLog;
                DELETE_LOGFILE_AFTER_USE = deleteLog = opt.getBoolean("deleteLogs").booleanValue();
            }
        }
        catch (Exception ex) {
            Log.error("Failed to parse Options. " + ex.getMessage(), (Throwable)ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.isWorking) {
            try {
                Thread.sleep(INTERVAL_SECONDS * 1000);
                this.statisticLogs();
                this.update2ZK();
            }
            catch (Exception ex) {
                Log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        Log.info("http access log monitor exited.");
    }

    private void update2ZK() throws Exception {
        Client client = Client.getInstance();
        if (client == null) {
            return;
        }
        INodeManager manager = client.getNodeManager();
        INodeService node = manager.getLocalNode();
        StatisticsLog staIndices = HttpStatisticIndices.commitIndices();
        client.getNodeManager().refreshStatisticsLog("Mapserver", node.getName(), staIndices);
        Log.info("\u66f4\u65b0\u6e32\u67d3\u5f15\u64ce\u8bbf\u95ee\u65e5\u5fd7\u622a\u5355\u6570\u636e");
    }

    private void printStaIndices() {
        StatisticsLog staIndices = HttpStatisticIndices.commitIndices();
        String json = JSON.toJSONString((Object)staIndices);
        Log.info(json);
    }

    private void statisticLogs() {
        Log.info("\u6267\u884c\u65e5\u5fd7\u7edf\u8ba1");
        List<File> logFiles = this.getLogFiles();
        if (null == logFiles || 0 == logFiles.size()) {
            return;
        }
        logFiles.forEach(file -> this.processLogFile((File)file));
        HttpStatisticIndices.flushBuffer();
        if (ARCHIVE_LOGFILE) {
            this.archiveLogFiles(logFiles);
        } else if (DELETE_LOGFILE_AFTER_USE) {
            for (File f : logFiles) {
                AccessLogMonitor.deleteLogFile(f);
            }
        }
    }

    private void processLogFile(File file) {
        String delimiter = " \\| ";
        if (null == file) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            long lineCount = 0L;
            String line = br.readLine();
            while (null != line) {
                String[] tokens;
                if (StringUtils.isEmpty((CharSequence)line) || (tokens = line.split(" \\| ")).length < 3) continue;
                AccessLogPO acclog = AccessLogPO.parseTokens(tokens);
                HttpStatisticIndices.consumeAsync(acclog);
                ++lineCount;
                line = br.readLine();
            }
            br.close();
            Log.info(file.getName() + " processed line count: " + lineCount);
        }
        catch (Exception ex) {
            Log.error("\u89e3\u6790\u65e5\u5fd7\u6587\u4ef6\u51fa\u9519: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private List<File> getLogFiles() {
        String rootDir = System.getProperty("user.dir");
        String accessLogFileName = "access.log";
        ArrayList<File> logFiles = new ArrayList<File>();
        String logdir = this.logPath;
        File logDirectory = new File(logdir);
        if (logDirectory.exists()) {
            File[] files;
            for (File m : files = logDirectory.listFiles()) {
                String name;
                if (m.isDirectory() || !(name = m.getName()).startsWith(accessLogFileName)) continue;
                logFiles.add(m);
            }
        }
        if (0 == logFiles.size()) {
            Log.error(logdir + " \u76ee\u5f55\u4e0b\u6ca1\u6709\u627e\u5230accesslog\u65e5\u5fd7\u6587\u4ef6! PWD=" + rootDir);
        }
        return logFiles;
    }

    private void archiveLogFiles(List<File> logFiles) {
        try {
            if (1 == logFiles.size() && logFiles.get(0).length() < 10L) {
                return;
            }
            String separator = this.logPath.endsWith(File.separator) ? "" : File.separator;
            String destDir = this.logPath + separator + "archive_acclogs" + separator;
            String zipName = "accesslog_" + System.currentTimeMillis() + ".zip";
            File zipFile = new File(destDir + zipName);
            File directory = new File(destDir);
            if (!directory.exists()) {
                directory.mkdirs();
            }
            try {
                File[] oldZips = directory.listFiles((dir, name) -> name.endsWith(".zip"));
                if (null != oldZips && oldZips.length > 1) {
                    int zipCount = oldZips.length;
                    long totalSize = Arrays.stream(oldZips).mapToLong(f -> f.length()).sum();
                    long MAX_SIZE = 0x40000000L;
                    long MAX_COUNT = 100L;
                    if (totalSize > 0x40000000L || (long)zipCount > 100L) {
                        for (File f2 : oldZips) {
                            f2.delete();
                        }
                    }
                }
            }
            catch (Exception oldZips) {
                // empty catch block
            }
            FileInputStream input = null;
            ZipOutputStream zipOut = null;
            zipOut = new ZipOutputStream(new FileOutputStream(zipFile));
            for (File f3 : logFiles) {
                input = new FileInputStream(f3);
                zipOut.putNextEntry(new ZipEntry(f3.getName()));
                IOUtils.copy((InputStream)input, (OutputStream)zipOut);
                ((InputStream)input).close();
                if (!DELETE_LOGFILE_AFTER_USE) continue;
                AccessLogMonitor.deleteLogFile(f3);
            }
            zipOut.close();
        }
        catch (Exception ex) {
            Log.error("\u65e5\u5fd7\u6587\u4ef6\u6253\u5305\u5f52\u6863\u51fa\u9519\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    private static void deleteLogFile(File file) {
        try {
            file.delete();
        }
        catch (Exception e) {
            Log.error("\u5220\u9664\u65e5\u5fd7\u6587\u4ef6 " + file.getName() + " \u51fa\u9519:" + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        Log4jUtil.init2();
        String logdir = "H:\\mapserver3.x-node14\\log\\";
        AccessLogMonitor.setLogMonitorOn(logdir, "{\"interval\": 30, \"deleteLogs\":false,\"archiveLogs\":false}");
        try {
            Thread.sleep(3600000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

