/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.data_service;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.Markable;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ISpatialField;
import com.northpool.resources.datatable.ITable;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.IBeanShell;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.config.IService;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.DataServiceShell;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.data_service.tileInfo.IAreaTileInfo;
import com.northpool.service.config.data_service.tileInfo.IFeatureTileInfo;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.spatial.Constants;
import java.util.List;
import java.util.Map;

public interface IDataService
extends IService,
Jsonable,
Markable,
Idable<String>,
IDocumentAble,
CanStartStop,
IVersionAble,
IBeanShell<DataServiceBean> {
    public List<FieldsConfig> getFields();

    public IDataSourceInService getDataSource();

    public String getDataSourceId();

    public Boolean getReadOnly();

    public Map<String, IField> getFieldMap();

    public ISpatialField getSpatialField();

    public ISpatialField getSpatialFieldByTable();

    public Constants.GEO_TYPE getGeoType();

    public int getOriginSrid();

    public String getSpatialFieldOriName();

    public String getSpatialFieldName();

    public FieldsConfig getIdField();

    public String getIdFieldName();

    public Map<String, String> getAliasMap();

    public String[] getAliasFiledArr();

    public String getTableName();

    public String getName();

    public ITable getTable() throws Exception;

    public void refresh();

    public static IDataService create(Client client, DataServiceBean dataService) {
        return new DataServiceShell(client, dataService);
    }

    public void addStorageInfo(IStorageInfo var1);

    public IStorageInfo getStorageInfo();

    public IAreaTileInfo getAreaTileInfo();

    public void addAreaTileInfo(IAreaTileInfo var1);

    public IFeatureTileInfo getFeatureTileInfo();

    public void addFeatureTileInfo(IFeatureTileInfo var1);

    public String getStorageName();

    public String getAreaStorageName();

    public String getFeatureStorageName();

    public String getLabelStorageName();

    public Client getClient();

    public void setFilter(String var1);
}

