/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.devtool.model;

import com.northpool.devtool.model.abstractclass.AbstractNetConnect;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperInfo
extends AbstractNetConnect {
    private static Logger logger = LoggerFactory.getLogger(ZookeeperInfo.class);
    String address;
    String root;
    String user;
    String password;
    Integer timeout;

    public ZookeeperInfo(String address) {
        this(address, null, null);
    }

    public ZookeeperInfo(String address, String root, Integer timeout) {
        super(address);
        this.root = root;
        this.timeout = timeout;
        if (StringUtils.isNotBlank((CharSequence)address) && address.contains("@")) {
            int index = address.lastIndexOf("@");
            String[] authStr = address.substring(0, index).split(":");
            if (authStr.length != 2) {
                throw new RuntimeException("zookeeper \u7528\u6237\u540d\u5bc6\u7801\u683c\u5f0f\u9519\u8bef");
            }
            this.address = address.substring(index + 1);
            this.user = authStr[0];
            this.password = authStr[1];
        } else {
            this.address = address;
        }
    }

    public Boolean hasAuth() {
        if (StringUtils.isNotBlank((CharSequence)this.user) && StringUtils.isNotBlank((CharSequence)this.password)) {
            return true;
        }
        return false;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getRoot() {
        return this.root;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void init(String uri) {
        try {
            String[] zkParams = uri.split("@");
            URI _uri = new URI("http://" + zkParams[zkParams.length - 1]);
            this.ip = _uri.getHost();
            this.port = _uri.getPort();
        }
        catch (URISyntaxException e) {
            logger.error("zookeeper \u5730\u5740\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5");
        }
    }
}

