/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service.layer;

import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.layer.Label;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.layer.LayerLevelBean;
import com.northpool.service.config.vector_service.layer.LayerLevelShell;
import com.northpool.spatial.Constants;
import java.util.Map;
import java.util.stream.Collectors;

public class LayerShell
implements ILayer {
    protected LayerBean layer;
    protected Client client;
    protected Map<String, DataSetBean> dataSetHashMap;
    protected Map<Integer, ILayerLevel> layerLevelMap;

    public LayerShell(Client client, LayerBean layer, Map<String, DataSetBean> map) {
        this.client = client;
        this.layer = layer;
        this.dataSetHashMap = map;
        this.layerLevelMap = this.createLayerLevelMap(this.layer.levelMap);
    }

    protected Map<Integer, ILayerLevel> createLayerLevelMap(Map<Integer, LayerLevelBean> levelMap) {
        return levelMap.entrySet().stream().map(entry -> {
            LayerLevelShell layerLevelShell;
            LayerLevelBean layerLevel = (LayerLevelBean)entry.getValue();
            try {
                layerLevelShell = new LayerLevelShell(this.client, layerLevel, this.dataSetHashMap);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return layerLevelShell;
        }).collect(Collectors.toMap(LayerLevelShell::getLevel, layerLevelShell -> layerLevelShell));
    }

    @Override
    public String getId() {
        return this.layer.getId();
    }

    @Override
    public String getDataServiceId() {
        String layerId = this.layer.getId();
        if (this.dataSetHashMap.containsKey(layerId)) {
            return this.dataSetHashMap.get(layerId).getDataServiceId();
        }
        return null;
    }

    @Override
    public IDataService getDataService() {
        String dataServiceId = this.getDataServiceId();
        return (IDataService)this.client.getDataServiceManager().get(dataServiceId);
    }

    @Override
    public Integer getBeginLevel() {
        return this.layer.getBeginLevel();
    }

    @Override
    public Integer getEndLevel() {
        return this.layer.getEndLevel();
    }

    @Override
    public Map<Integer, ILayerLevel> getLevelMap() {
        return this.layerLevelMap;
    }

    @Override
    public boolean isHaveLabel() {
        return this.layer.haveLabel;
    }

    @Override
    public Label getLabel() {
        return this.layer.label;
    }

    @Override
    public Boolean getLabelOnly() {
        return this.layer.labelOnly;
    }

    @Override
    public Boolean getCutOutScreen() {
        return this.layer.getCutOutScreen();
    }

    @Override
    public LayerBean getBean() {
        return this.layer;
    }

    @Override
    public Constants.LAYER_TYPE getLayerType() {
        return this.layer.getLayerType();
    }
}

