/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.devtool.model;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JvmInfo {
    String version;
    String home;
    String userDir;
    String tmpDir;
    String startTime;
    String runTime;
    String heapInitMemory;
    String heapUsageMemory;
    String heapCommitMemory;
    String heapMaxMemory;
    String nonHeapInitMemory;
    String nonHeapUsageMemory;
    String nonHeapCommitMemory;
    String nonHeapMaxMemory;
    RuntimeMXBean runtimeMX = ManagementFactory.getRuntimeMXBean();
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    public JvmInfo() {
        this.version = System.getProperty("java.version");
        this.home = System.getProperty("java.home");
        this.tmpDir = System.getProperty("java.io.tmpdir");
        this.userDir = System.getProperty("user.dir");
        this.startTime = this.dateFormat.format(new Date(this.runtimeMX.getStartTime()));
        MemoryMXBean memorymbean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memorymbean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memorymbean.getNonHeapMemoryUsage();
        this.heapInitMemory = JvmInfo.kb2mb(heapMemoryUsage.getInit());
        this.heapUsageMemory = JvmInfo.kb2mb(heapMemoryUsage.getUsed());
        this.heapMaxMemory = JvmInfo.kb2mb(heapMemoryUsage.getInit());
        this.heapCommitMemory = JvmInfo.kb2mb(heapMemoryUsage.getCommitted());
        this.nonHeapInitMemory = JvmInfo.kb2mb(nonHeapMemoryUsage.getInit());
        this.nonHeapUsageMemory = JvmInfo.kb2mb(nonHeapMemoryUsage.getUsed());
        this.nonHeapMaxMemory = JvmInfo.kb2mb(nonHeapMemoryUsage.getMax());
        this.nonHeapCommitMemory = JvmInfo.kb2mb(nonHeapMemoryUsage.getCommitted());
    }

    public String getVersion() {
        return this.version;
    }

    public String getHome() {
        return this.home;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getRunTime() {
        return JvmInfo.formatDuring(this.runtimeMX.getUptime());
    }

    public String getHeapInitMemory() {
        return this.heapInitMemory;
    }

    public String getHeapUsageMemory() {
        return this.heapUsageMemory;
    }

    public String getHeapCommitMemory() {
        return this.heapCommitMemory;
    }

    public String getHeapMaxMemory() {
        return this.heapMaxMemory;
    }

    public String getNonHeapInitMemory() {
        return this.nonHeapInitMemory;
    }

    public String getNonHeapUsageMemory() {
        return this.nonHeapUsageMemory;
    }

    public String getNonHeapCommitMemory() {
        return this.nonHeapCommitMemory;
    }

    public String getNonHeapMaxMemory() {
        return this.nonHeapMaxMemory;
    }

    public String getUserDir() {
        return this.userDir;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    static String kb2mb(Long kb) {
        return Math.toIntExact(kb / 1024L / 1024L) + " MB";
    }

    public static String formatDuring(long mss) {
        long days = mss / 86400000L;
        long hours = mss % 86400000L / 3600000L;
        long minutes = mss % 3600000L / 60000L;
        long seconds = mss % 60000L / 1000L;
        return days + " \u5929 " + hours + " \u5c0f\u65f6 " + minutes + " \u5206\u949f " + seconds + " \u79d2 ";
    }
}

