/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.data_service;

import com.northpool.resources.datatable.FieldEncoder;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ISpatialField;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.ITableOperator;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoBean;
import com.northpool.service.config.data_service.tileInfo.AreaTileInfoShell;
import com.northpool.service.config.data_service.tileInfo.FeatureTileInfoBean;
import com.northpool.service.config.data_service.tileInfo.FeatureTileInfoShell;
import com.northpool.service.config.data_service.tileInfo.IAreaTileInfo;
import com.northpool.service.config.data_service.tileInfo.IFeatureTileInfo;
import com.northpool.service.config.data_source.IDataSourceInService;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import com.northpool.spatial.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;

public class DataServiceShell
implements IDataService {
    private Client client;
    private DataServiceBean dataService;
    private IStorageInfo storageInfo;
    private IAreaTileInfo areaTileInfo;
    private IFeatureTileInfo featureTileInfo;
    private Map<String, String> fieldsMap;

    public DataServiceShell(Client client, DataServiceBean dataService) {
        this.client = client;
        this.dataService = dataService;
        this.storageInfo = this.createStorageInfo(dataService.getStorageInfo());
        this.areaTileInfo = this.createAreaTileInfo(dataService.getAreaTileInfo());
        this.featureTileInfo = this.createFeatureTileInfo(dataService.getFeatureTileInfo());
    }

    public String getMark() {
        return this.mark();
    }

    public String mark() {
        return this.dataService.id;
    }

    @Override
    public void start() {
        this.dataService.state = CanStartStop.STATE_TYPE.run;
    }

    @Override
    public void stop() {
        this.dataService.state = CanStartStop.STATE_TYPE.stop;
    }

    @Override
    public String state() {
        return this.dataService.state.name();
    }

    @Override
    public CanStartStop.STATE_TYPE getState() {
        return this.dataService.state;
    }

    @Override
    public void rollback(CanStartStop.STATE_TYPE state) {
        this.dataService.state = state;
    }

    @Override
    public Boolean getReadOnly() {
        return this.dataService.readonly;
    }

    @Override
    public String getId() {
        return this.dataService.id;
    }

    @Override
    public String getVersion() {
        return this.dataService.version;
    }

    @Override
    public void setVersion(String version) {
        this.dataService.setVersion(version);
    }

    @Override
    public Constants.SERVICE_TYPE getServiceType() {
        return this.dataService.serviceType;
    }

    public String toJson() {
        this.getFields();
        return this.dataService.toJson();
    }

    private IStorageInfo createStorageInfo(StorageInfoBean storageInfo) {
        if (storageInfo != null) {
            return new StorageInfoShell(this.client, storageInfo);
        }
        return null;
    }

    private IFeatureTileInfo createFeatureTileInfo(FeatureTileInfoBean featureTileInfo) {
        if (featureTileInfo == null) {
            return null;
        }
        FeatureTileInfoShell iFeatureTileInfo = new FeatureTileInfoShell(this.client, featureTileInfo);
        return iFeatureTileInfo;
    }

    private IAreaTileInfo createAreaTileInfo(AreaTileInfoBean areaTileInfoBean) {
        if (areaTileInfoBean == null) {
            return null;
        }
        AreaTileInfoShell iAreaTileInfo = new AreaTileInfoShell(this.client, areaTileInfoBean);
        return iAreaTileInfo;
    }

    @Override
    public void addStorageInfo(IStorageInfo storageInfo) {
        this.storageInfo = storageInfo;
        this.getBean().setStorageInfo(storageInfo.getBean());
    }

    @Override
    public IStorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    @Override
    public IAreaTileInfo getAreaTileInfo() {
        return this.areaTileInfo;
    }

    @Override
    public void addAreaTileInfo(IAreaTileInfo areaTileInfo) {
        this.areaTileInfo = areaTileInfo;
        this.getBean().setAreaTileInfo(areaTileInfo.getBean());
    }

    @Override
    public IFeatureTileInfo getFeatureTileInfo() {
        return this.featureTileInfo;
    }

    @Override
    public void addFeatureTileInfo(IFeatureTileInfo featureTileInfo) {
        this.featureTileInfo = featureTileInfo;
        this.getBean().setFeatureTileInfo(featureTileInfo.getBean());
    }

    @Override
    public String getStorageName() {
        return this.dataService.getName() + "_" + this.dataService.getId();
    }

    @Override
    public String getAreaStorageName() {
        return this.dataService.getName() + "_area_" + this.dataService.getId();
    }

    @Override
    public String getFeatureStorageName() {
        return this.dataService.getName() + "_feature_" + this.dataService.getId();
    }

    @Override
    public String getLabelStorageName() {
        return this.dataService.getName() + LayerBean.LABEL_SUFFIX + "_" + this.dataService.getId();
    }

    @Override
    public Client getClient() {
        return this.client;
    }

    @Override
    public void setFilter(String filter) {
        this.dataService.setFilter(filter);
    }

    @Override
    public List<FieldsConfig> getFields() {
        if (this.dataService.getFields() == null || this.dataService.getFields().isEmpty()) {
            ArrayList<FieldsConfig> fields = new ArrayList<FieldsConfig>();
            Map<String, IField> fieldsMap = this.getFieldMap();
            IField idField = this.getIdFieldByTable();
            ISpatialField spatialField = this.getSpatialFieldByTable();
            FieldsConfig fieldsConfig = null;
            boolean isId = false;
            Iterator<String> it = this.dataService.aliasMap.values().iterator();
            int index = 0;
            while (it.hasNext()) {
                String fieldName = it.next();
                if (fieldName.equals(spatialField.getFieldName())) continue;
                fieldsConfig = new FieldsConfig();
                fieldsConfig.setIndex(index);
                fieldsConfig.setName(fieldName);
                fieldsConfig.setRemarks(fieldsMap.get(fieldName).getRemarks());
                isId = fieldName.equals(idField.getFieldName());
                fieldsConfig.setId(isId);
                fieldsConfig.setType(fieldsMap.get(fieldName).getType().name().toLowerCase());
                fields.add(fieldsConfig);
                ++index;
            }
            this.dataService.setFields(fields);
        }
        if (this.dataService.getGeoType() == null) {
            ISpatialField spatialField = this.getSpatialFieldByTable();
            this.dataService.setGeoType(spatialField.getGeoType().name());
        }
        return this.dataService.getFields();
    }

    @Override
    public IDataSourceInService getDataSource() {
        String dataSourceId = this.dataService.dataSourceId;
        IDataSourceInService dataSource = (IDataSourceInService)this.client.getDataSourcesManager().get(dataSourceId);
        if (dataSource == null) {
            throw new RuntimeException(String.format("\u6ca1\u6709dataSourceId\u4e3a %s \u7684\u6570\u636e\u6e90", dataSourceId));
        }
        return dataSource;
    }

    @Override
    public String getDataSourceId() {
        return this.dataService.getDataSourceId();
    }

    protected ITableOperator getBuilder() {
        IDataSourceInService dataSource = this.getDataSource();
        try {
            return dataSource.getTableBuilder(this.dataService.tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public ISpatialField getSpatialField() {
        ITableOperator builder = this.getBuilder();
        IColumn column = (IColumn)builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName());
        if (column == null) {
            column = (IColumn)builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName().toUpperCase());
        }
        if (column == null) {
            new RuntimeException(String.format("%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5%s", builder.mark(), this.dataService.getSpatialOriginFieldName()));
        }
        IColumn spatialColumn = column;
        List i = this.dataService.getAliasMap().entrySet().stream().filter(entry -> {
            String fieldOrigin = (String)entry.getKey();
            return fieldOrigin.equalsIgnoreCase(this.dataService.getSpatialOriginFieldName());
        }).map(entry -> IField.createSpatialField((String)((String)entry.getValue()), (IColumn)spatialColumn)).collect(Collectors.toList());
        if (i.isEmpty()) {
            throw new RuntimeException(String.format("%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5%s", builder.mark(), this.dataService.getSpatialOriginFieldName()));
        }
        return (ISpatialField)i.get(0);
    }

    @Override
    public ISpatialField getSpatialFieldByTable() {
        ITableOperator builder = this.getBuilder();
        IColumn column = (IColumn)builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName());
        if (column == null) {
            column = (IColumn)builder.getColumnMap().get(this.dataService.getSpatialOriginFieldName().toUpperCase());
        }
        if (column == null) {
            new RuntimeException(String.format("%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5%s", builder.mark(), this.dataService.getSpatialOriginFieldName()));
        }
        IColumn spatialColumn = column;
        List i = this.dataService.getAliasMap().entrySet().stream().filter(entry -> {
            String fieldOrigin = (String)entry.getKey();
            return fieldOrigin.equalsIgnoreCase(this.dataService.getSpatialOriginFieldName());
        }).map(entry -> IField.createSpatialField((String)((String)entry.getValue()), (IColumn)spatialColumn)).collect(Collectors.toList());
        if (i.isEmpty()) {
            throw new RuntimeException(String.format("%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5%s", builder.mark(), this.dataService.getSpatialOriginFieldName()));
        }
        return (ISpatialField)i.get(0);
    }

    @Override
    public Constants.GEO_TYPE getGeoType() {
        if (this.dataService.getGeoType() == null) {
            ISpatialField spatialField = this.getSpatialFieldByTable();
            this.dataService.setGeoType(spatialField.getGeoType().name());
        }
        return Constants.GEO_TYPE.valueOf((String)this.dataService.getGeoType());
    }

    @Override
    public int getOriginSrid() {
        return this.dataService.getOriginSrid();
    }

    @Override
    public String getSpatialFieldOriName() {
        return this.dataService.getSpatialOriginFieldName();
    }

    @Override
    public String getSpatialFieldName() {
        return this.dataService.getSpatialFieldName();
    }

    private IField getIdFieldByTable() {
        List i;
        ITableOperator builder = this.getBuilder();
        IColumn column = (IColumn)builder.getColumnMap().get(builder.getPKColumn());
        if (column == null) {
            new RuntimeException(String.format("%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5%s", builder.mark(), builder.getPKColumn()));
        }
        if ((i = this.dataService.getAliasMap().entrySet().stream().filter(entry -> {
            String fieldOrigin = (String)entry.getKey();
            return fieldOrigin.equalsIgnoreCase(builder.getPKColumn());
        }).map(entry -> IField.createField((String)((String)entry.getValue()), (IColumn)column)).collect(Collectors.toList())).isEmpty()) {
            throw new RuntimeException(String.format("%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5%s", builder.mark(), builder.getPKColumn()));
        }
        return (IField)i.get(0);
    }

    @Override
    public FieldsConfig getIdField() {
        List<FieldsConfig> fieldsConfigs = this.getFields();
        return fieldsConfigs.stream().filter(fieldsConfig -> fieldsConfig.getId()).findFirst().get();
    }

    @Override
    public Map<String, IField> getFieldMap() {
        ITableOperator builder = this.getBuilder();
        LinkedHashMap<String, IField> map = new LinkedHashMap<String, IField>();
        this.dataService.getAliasMap().entrySet().forEach(entry -> {
            String fieldAlias = (String)entry.getValue();
            String fieldOrigin = (String)entry.getKey();
            IColumn column = (IColumn)builder.getColumnMap().get(fieldOrigin);
            if (column == null) {
                column = (IColumn)builder.getColumnMap().get(fieldOrigin.toUpperCase());
            }
            map.put(fieldAlias, IField.createField((String)((String)entry.getValue()), (IColumn)column));
        });
        return map;
    }

    @Override
    public String getIdFieldName() {
        return this.getIdField().getName();
    }

    @Override
    public Map<String, String> getAliasMap() {
        return this.dataService.aliasMap;
    }

    @Override
    public String[] getAliasFiledArr() {
        String[] arr = (String[])this.dataService.getAliasMap().entrySet().stream().map(entry -> (String)entry.getValue()).toArray(String[]::new);
        return arr;
    }

    @Override
    public DataServiceBean getBean() {
        return this.dataService;
    }

    @Override
    public String getTableName() {
        return this.dataService.tableName;
    }

    @Override
    public String getName() {
        return this.dataService.getName();
    }

    @Override
    public ITable getTable() throws Exception {
        IDataSourceInService dataSource = this.getDataSource();
        List<FieldsConfig> fieldsConfigs = this.getFields();
        if (this.fieldsMap == null) {
            this.fieldsMap = this.revertMapKV(this.getAliasMap());
        }
        List fieldNames = fieldsConfigs.stream().map(fieldsConfig -> this.fieldsMap.get(fieldsConfig.getName())).collect(Collectors.toList());
        fieldNames.add(this.getSpatialFieldOriName());
        String[] fieldsArr = (String[])fieldNames.stream().toArray(String[]::new);
        ITable table = dataSource.getTableBuilder(this.dataService.tableName).getTable(fieldsArr);
        return table;
    }

    private Map<String, String> revertMapKV(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>(map.size());
        Iterator<String> iterator = map.keySet().iterator();
        String key = null;
        while (iterator.hasNext()) {
            key = iterator.next();
            result.put(map.get(key), key);
        }
        return result;
    }

    @Override
    public void refresh() {
        IDataService dataService = (IDataService)this.client.getDataServiceManager().get(this.getId());
        if (dataService == null) {
            return;
        }
        this.dataService = (DataServiceBean)dataService.getBean();
        IDataSourceInService dataSourceInService = this.getDataSource();
        dataSourceInService.refresh();
    }

    public FieldEncoder getFieldEncoder() {
        final Map<String, String> aliasMap = this.getAliasMap();
        return new FieldEncoder(){

            public String encode(String fieldInDB) {
                return (String)aliasMap.get(fieldInDB.toLowerCase());
            }

            public String getFieldEncoderName() {
                return "";
            }
        };
    }

    @Override
    public Document toDocument() {
        return Document.parse((String)this.toJson());
    }

    public boolean equals(Object o) {
        DataServiceShell bean = (DataServiceShell)o;
        return this.dataService.equals(bean.getBean());
    }
}

