/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service;

import com.northpool.bean.Idable;
import com.northpool.bean.Jsonable;
import com.northpool.bean.Markable;
import com.northpool.service.client.Client;
import com.northpool.service.config.CanStartStop;
import com.northpool.service.config.IBeanShell;
import com.northpool.service.config.IDocumentAble;
import com.northpool.service.config.IService;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.ProjConfigBean;
import com.northpool.service.config.vector_service.ProjectedMapInfo;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.VectorServiceShell;
import com.northpool.service.config.vector_service.layer.CacheTileLayerBean;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.utfgrid.IUtfgridInfo;
import com.northpool.spatial.grid.IGridSystem;
import java.util.List;
import java.util.Map;

public interface IVectorService
extends IService,
Jsonable,
Markable,
Idable<String>,
IDocumentAble,
CanStartStop,
ICacheable,
IVersionAble,
IBeanShell<VectorServiceBean> {
    public void addUtfgridInfo(IUtfgridInfo var1);

    public void addCacheInfo(ICacheable var1);

    @Override
    public String getId();

    public String getName();

    @Override
    public String getVersion();

    public IGridSystem getGridTree();

    public String getBbox();

    public Integer getBeginLevel();

    public Integer getEndLevel();

    public Map<String, ILayer> getLayerMap();

    public Boolean isSinglelayer();

    public Boolean allowCache();

    public Client getClient();

    public void refresh();

    public static IVectorService create(Client client, VectorServiceBean vectorService) {
        return new VectorServiceShell(client, vectorService);
    }

    public void addStorageInfo(IStorageInfo var1);

    public void addStorageInfo(IStorageInfo var1, Map<String, CacheTileLayerBean> var2);

    public ICacheable getCacheInfo();

    public IStorageInfo getStorageInfo();

    public IUtfgridInfo getUtfgridInfo();

    public List<FieldsConfig> getLayerFields(ILayer var1);

    public String getLayerIdFieldName(ILayer var1);

    public String getLayerIdFieldType(ILayer var1);

    public String getLayerGeometryType(ILayer var1);

    public int[] getOrigin();

    public double[] getResolutions();

    public List<String> getDataServiceIds();

    public Map<String, CacheTileLayerBean> getCacheTileLayers();

    public void setProjConfig(String var1);

    public ProjConfigBean getProjConfig();

    public ProjectedMapInfo getProjectedMeta();
}

