/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.devtool.AbnormalCheck;

import com.northpool.devtool.AbnormalCheck.IAbnormalCheck;
import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.utils.NetUtils;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortCheck
extends AbstractCheck
implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(PortCheck.class);
    String host = "127.0.0.1";
    Integer port;
    static PortCheck inst;

    public PortCheck(Integer port) {
        this.port = port;
    }

    public static PortCheck getInst(Integer port) {
        if (inst == null) {
            inst = new PortCheck(port);
        } else {
            PortCheck.inst.port = port;
        }
        return inst;
    }

    @Override
    public void check() {
        try {
            boolean flag = NetUtils.isPortUsing(this.host, this.port);
            if (flag) {
                logger.error("\u7aef\u53e3\u5360\u7528\uff1a{}, \u8bf7\u6e05\u7406\u5360\u7528\u7684\u7aef\u53e3\u8fdb\u7a0b\u6216\u4f7f\u7528\u5176\u4ed6\u7684\u7aef\u53e3\u542f\u52a8", (Object)this.port);
                logger.error("\u914d\u7f6e\u9879\u4e3a server.port: {}", (Object)8080);
                super.shutdown();
            }
        }
        catch (UnknownHostException e) {
            logger.error(e.getMessage());
        }
    }
}

