/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.node;

import com.northpool.node.config.INodeService;
import com.northpool.node.config.NodeBean;
import com.northpool.node.config.NodeBuilder;
import com.northpool.node.observer.ConcreteNodeMessage;
import com.northpool.service.client.Client;
import com.northpool.service.config.IVersionAble;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.manager.IMetaNodeManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeZkDao
implements IMetaDataDao<INodeService> {
    Logger log = LoggerFactory.getLogger(this.getClass());
    protected QueryHashTableHeap<String, INodeService> table;
    protected final String idFieldName = "id";
    protected Client client;
    protected Boolean readOnly = false;
    protected String managerRoot = "node";
    protected PathChildrenCache HolderCache;
    protected ConcreteNodeMessage nodeMessage;
    protected static final String DATA_FIELD = "data";
    protected static final String VERSION_FIELD = "version";

    public NodeZkDao(QueryHashTableHeap<String, INodeService> table, Client client, IMetaNodeManager<INodeService> manager, ConcreteNodeMessage nodeMessage) {
        this.table = table;
        this.managerRoot = "/northpool_service_root" + "/" + this.managerRoot;
        this.client = client;
        this.nodeMessage = nodeMessage;
    }

    @Override
    public void init() throws Exception {
        this.createRoot();
        if (StringUtils.isNotBlank((CharSequence)this.client.getMapServerAccess().getUrlPrifix())) {
            this.addZKListener();
        }
    }

    private void createRoot() throws Exception {
        if (this.client.getZoo().checkExists().forPath(this.managerRoot) == null) {
            ((ACLBackgroundPathAndBytesable)this.client.getZoo().create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(this.managerRoot);
        }
    }

    @Override
    public void insert(INodeService data) throws Exception {
        if (this.exists(data.getId())) {
            this.log.debug("\u66f4\u65b0\u8282\u70b9\u670d\u52a1\u4fe1\u606f");
            this.update(data);
        } else {
            this.log.debug("\u65b0\u589e\u8282\u70b9\u670d\u52a1\u4fe1\u606f");
            TransactionOp transaction = this.client.getZoo().transactionOp();
            List<CuratorOp> iList = this.createBeanNode(transaction, data);
            this.client.getZoo().transaction().forOperations(iList);
        }
    }

    @Override
    public void update(INodeService data) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        ArrayList<CuratorOp> iListUpdate = new ArrayList<CuratorOp>();
        List<CuratorOp> iListDelete = this.deleteBeanNode(transaction, data.getId());
        iListUpdate.addAll(iListDelete);
        List<CuratorOp> iListAdd = this.createBeanNode(transaction, data);
        iListUpdate.addAll(iListAdd);
        this.client.getZoo().transaction().forOperations(iListUpdate);
    }

    @Override
    public void delete(String id) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        List<CuratorOp> iList = this.deleteBeanNode(transaction, id);
        this.client.getZoo().transaction().forOperations(iList);
    }

    @Override
    public boolean exists(String id) throws Exception {
        return this.client.getZoo().checkExists().forPath(this.path(id)) != null;
    }

    @Override
    public List<INodeService> findAll() throws Exception {
        List nodes = (List)this.client.getZoo().getChildren().forPath(this.managerRoot);
        ArrayList<INodeService> list = new ArrayList<INodeService>();
        for (String node : nodes) {
            INodeService nodeService = this.findOne(node);
            list.add(nodeService);
        }
        return list;
    }

    @Override
    public INodeService findOne(String id) throws Exception {
        byte[] bytes = (byte[])this.client.getZoo().getData().forPath(this.managerRoot + "/" + id + "/data");
        byte[] versionBytes = (byte[])this.client.getZoo().getData().forPath(this.managerRoot + "/" + id + "/" + VERSION_FIELD);
        INodeService nodeService = NodeBuilder.getInstance().fromBytes(bytes);
        nodeService.setVersion(new String(versionBytes, "utf-8"));
        return nodeService;
    }

    protected List<CuratorOp> createBeanNode(TransactionOp transaction, INodeService t) throws Exception {
        String id = t.getId();
        String path = this.path(id);
        ArrayList<CuratorOp> iList = new ArrayList<CuratorOp>();
        CuratorOp createOp1 = (CuratorOp)((ACLPathAndBytesable)transaction.create().withMode(CreateMode.PERSISTENT)).forPath(path, id.getBytes("utf-8"));
        iList.add(createOp1);
        CuratorOp createOp2 = (CuratorOp)transaction.create().forPath(path + "/id", t.getId().getBytes("utf-8"));
        iList.add(createOp2);
        if (t instanceof IVersionAble) {
            String version = t.getVersion();
            if (version == null) {
                version = new Date().getTime() + "";
            }
            CuratorOp createOp3 = (CuratorOp)transaction.create().forPath(path + "/" + VERSION_FIELD, version.getBytes("utf-8"));
            iList.add(createOp3);
        }
        CuratorOp createOp3 = (CuratorOp)transaction.create().forPath(path + "/data", t.toJson().getBytes("utf-8"));
        iList.add(createOp3);
        return iList;
    }

    public String path(String id) {
        String path = this.managerRoot + "/" + id;
        return path;
    }

    protected List<CuratorOp> deleteBeanNode(TransactionOp transaction, String id) throws Exception {
        String path = this.path(id);
        ArrayList<CuratorOp> iList = new ArrayList<CuratorOp>();
        List nodes = (List)this.client.getZoo().getChildren().forPath(path);
        for (String node : nodes) {
            String sub_path = path + "/" + node;
            CuratorOp delete_sub_node = (CuratorOp)transaction.delete().forPath(sub_path);
            iList.add(delete_sub_node);
        }
        CuratorOp delete = (CuratorOp)transaction.delete().forPath(path);
        iList.add(delete);
        return iList;
    }

    private String getVersionFromZK(String id) throws Exception {
        byte[] info_byte;
        String path = this.path(id);
        String data_path = path + "/" + VERSION_FIELD;
        try {
            info_byte = (byte[])this.client.getZoo().getData().forPath(data_path);
        }
        catch (Exception e) {
            return null;
        }
        return new String(info_byte, "utf-8");
    }

    private void addZKListener() throws Exception {
        String listenterPath = this.managerRoot;
        this.HolderCache = new PathChildrenCache(this.client.getZoo(), listenterPath, true);
        this.HolderCache.getListenable().addListener((client, event) -> {
            if (event.getType() == PathChildrenCacheEvent.Type.CONNECTION_SUSPENDED || event.getType() == PathChildrenCacheEvent.Type.CONNECTION_RECONNECTED || event.getType() == PathChildrenCacheEvent.Type.CONNECTION_LOST) {
                return;
            }
            ChildData data = event.getData();
            String id = new String(data.getData(), "utf-8");
            switch (event.getType()) {
                case CHILD_ADDED: {
                    INodeService nodeService = this.findOne(id);
                    this.nodeMessage.setNodeBean((NodeBean)nodeService.getBean());
                    break;
                }
            }
        });
        this.HolderCache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
    }
}

