/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.config.vector_service.layer;

import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.inmemoryold.IArrayFilter;
import com.northpool.resources.inmemoryold.QueryFilterToInMemory;
import com.northpool.service.client.Client;
import com.northpool.service.config.vector_service.dataset.DataSetBean;
import com.northpool.service.config.vector_service.dataset.DataSetShell;
import com.northpool.service.config.vector_service.dataset.IDataSet;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.layer.ISimplify;
import com.northpool.service.config.vector_service.layer.LayerLevelBean;
import com.northpool.service.config.vector_service.layer.SimplifyBean;
import com.northpool.service.config.vector_service.layer.SimplifyShell;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LayerLevelShell
implements ILayerLevel {
    protected LayerLevelBean layerLevel;
    protected Client client;
    protected IArrayFilter arrayFilter;
    protected IDataSet dataSet;
    protected ISimplify[] simplifyArray;

    public LayerLevelShell(Client client, LayerLevelBean layerLevel, Map<String, DataSetBean> dataSetHashMap) throws Exception {
        this.client = client;
        this.layerLevel = layerLevel;
        String filterSQL = layerLevel.getFilterSQL();
        this.arrayFilter = this.createArrayFilter(filterSQL);
        DataSetBean dataSet = dataSetHashMap.get(this.layerLevel.dataSetId);
        if (dataSet == null) {
            throw new RuntimeException(String.format("\u6ca1\u6709\u627e\u5230dataset%s", this.layerLevel.dataSetId));
        }
        this.dataSet = this.createDataSet(client, dataSet);
        this.simplifyArray = this.createISimplifyArr();
    }

    protected ISimplify[] createISimplifyArr() {
        if (this.layerLevel.getSimplifyArr() == null) {
            return null;
        }
        return (ISimplify[])Arrays.asList(this.layerLevel.getSimplifyArr()).stream().map(simplify -> {
            try {
                return new SimplifyShell((SimplifyBean)simplify);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }).toArray(ISimplify[]::new);
    }

    protected IDataSet createDataSet(Client client, DataSetBean dataSet) {
        return new DataSetShell(client, dataSet);
    }

    protected IArrayFilter createArrayFilter(String filterSQL) throws Exception {
        IArrayFilter arrayFilter = null;
        if (StringUtils.isNotBlank((CharSequence)filterSQL)) {
            try {
                QueryFilter queryFilter = new QueryFilter();
                queryFilter.addSQL(filterSQL);
                arrayFilter = new QueryFilterToInMemory(queryFilter).toArrayFilter();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("\u5c42\u7ea7:" + this.layerLevel.level + " \u8fc7\u6ee4\u6761\u4ef6:" + filterSQL + "\u89e3\u6790\u51fa\u9519");
            }
        }
        return arrayFilter;
    }

    @Override
    public Double getSimplifyForLayerLevel() {
        return this.layerLevel.simplifyForLayerLevel;
    }

    @Override
    public Double getSimplify(String[] attrNames, Object[] values) {
        return this.getSimplify(attrNames, values);
    }

    @Override
    public Boolean isFeatureSave(String[] attrNames, Object[] values) throws Exception {
        if (this.arrayFilter == null) {
            return true;
        }
        return this.arrayFilter.isSave(attrNames, values);
    }

    @Override
    public String getFilterExpression() {
        return this.layerLevel.getFilterSQL();
    }

    @Override
    public void setFilterExpression(String filterExpression) throws Exception {
        this.layerLevel.setFilterSQL(filterExpression);
        this.arrayFilter = this.createArrayFilter(filterExpression);
    }

    @Override
    public Integer getLevel() {
        return this.layerLevel.getLevel();
    }

    @Override
    public IArrayFilter getFilter() {
        return this.arrayFilter;
    }

    @Override
    public Boolean isVirtual() {
        return this.layerLevel.virtual;
    }

    @Override
    public IDataSet getDataSet() {
        return this.dataSet;
    }

    @Override
    public Integer getLineCutBase() {
        return this.layerLevel.getLineCutBase();
    }

    @Override
    public Integer getMinCutPixel() {
        return this.layerLevel.getMinCutPixel();
    }

    @Override
    public Integer getMinCutPoint() {
        return this.layerLevel.getMinCutPoint();
    }

    @Override
    public ISimplify[] getSimplifyArr() {
        return this.simplifyArray;
    }

    public static void main(String[] args) throws Exception {
        String filterSQL = "1 = 2";
        IArrayFilter arrayFilter = null;
        if (filterSQL != null && !"".equalsIgnoreCase(filterSQL)) {
            try {
                QueryFilter queryFilter = new QueryFilter();
                queryFilter.addSQL(filterSQL);
                arrayFilter = new QueryFilterToInMemory(queryFilter).toArrayFilter();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        boolean issave = arrayFilter.isSave(new String[]{"11"}, (Object[])new String[]{"name"});
        System.out.println(issave);
    }
}

