/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.dao.style;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.service.client.Client;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBuilder;
import com.northpool.service.dao.AbstractZkDao;
import com.northpool.service.dao.style.StyleMongoDao;
import com.northpool.service.manager.IMetaDataManager;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.framework.api.ACLPathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleZkDao
extends AbstractZkDao<IStyleService, StyleBuilder> {
    Logger logger = LoggerFactory.getLogger(StyleZkDao.class);

    public StyleZkDao(String idFieldName, StyleBuilder beanBuilder, QueryHashTableHeap<String, IStyleService> table, Client client, String managerRoot, Boolean readOnly, IMetaDataManager<IStyleService> manager) {
        super(idFieldName, beanBuilder, table, client, managerRoot, readOnly);
        this.manager = manager;
        this.mongoDao = new StyleMongoDao(client.initMongoClient(), this.idFieldName, beanBuilder);
    }

    @Override
    protected List<CuratorOp> createBeanNode(TransactionOp transaction, IStyleService t) throws Exception {
        String id = (String)t.getId();
        String path = this.path(id);
        ArrayList<CuratorOp> iList = new ArrayList<CuratorOp>();
        CuratorOp createOp1 = (CuratorOp)((ACLPathAndBytesable)transaction.create().withMode(CreateMode.PERSISTENT)).forPath(path, id.getBytes("utf-8"));
        iList.add(createOp1);
        CuratorOp createOp2 = (CuratorOp)transaction.create().forPath(path + "/id", ((String)t.getId()).getBytes("utf-8"));
        iList.add(createOp2);
        JSONObject obj = (JSONObject)JSON.toJSON((Object)t.getBean());
        obj.remove((Object)"styleJson");
        obj.remove((Object)"styleLayerJs");
        obj.remove((Object)"styleLabelJs");
        obj.remove((Object)"styleAvoidjs");
        obj.remove((Object)"queryLayer");
        obj.remove((Object)"queryLabel");
        obj.remove((Object)"mapboxStyle");
        CuratorOp createOp3 = (CuratorOp)transaction.create().forPath(path + "/data", obj.toJSONString().getBytes("utf-8"));
        iList.add(createOp3);
        this.AddExtendsInfo2BeanNode(path, (List<CuratorOp>)iList, transaction, t);
        return iList;
    }

    @Override
    public void insert(IStyleService styleService) throws Exception {
        if (this.mongoDao.findone((String)styleService.getId()) == null) {
            this.mongoDao.insertOne(styleService);
        }
        TransactionOp transaction = this.client.getZoo().transactionOp();
        List<CuratorOp> iList = this.createBeanNode(transaction, styleService);
        this.client.getZoo().transaction().forOperations(iList);
    }

    @Override
    public void update(IStyleService styleService) throws Exception {
        TransactionOp transaction = this.client.getZoo().transactionOp();
        ArrayList<CuratorOp> iListUpdate = new ArrayList<CuratorOp>();
        List<CuratorOp> iListDelete = this.deleteBeanNode(transaction, (String)styleService.getId());
        iListUpdate.addAll(iListDelete);
        List<CuratorOp> iListAdd = this.createBeanNode(transaction, styleService);
        iListUpdate.addAll(iListAdd);
        this.client.getZoo().transaction().forOperations(iListUpdate);
    }

    @Override
    protected void AddExtendsInfo2BeanNode(String path, List<CuratorOp> iList, TransactionOp transaction, IStyleService iStyleService) throws Exception {
    }
}

