/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.devtool.AbnormalCheck;

import com.northpool.devtool.AbnormalCheck.IAbnormalCheck;
import com.northpool.devtool.AbnormalCheck.abstractclass.AbstractCheck;
import com.northpool.devtool.utils.NetUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapserverCheck
extends AbstractCheck
implements IAbnormalCheck {
    private static Logger logger = LoggerFactory.getLogger(MapserverCheck.class);
    Integer TIME_OUT = 3000;
    String url = "127.0.0.1:80";
    static MapserverCheck inst;

    public MapserverCheck(String url) {
        this.url = url;
    }

    public static MapserverCheck getInst(String url) {
        if (inst == null) {
            inst = new MapserverCheck(url);
        } else {
            MapserverCheck.inst.url = url;
        }
        return inst;
    }

    @Override
    public void check() {
        try {
            boolean flag;
            URI uri = new URI(this.url);
            int port = uri.getPort();
            if (port <= 0) {
                port = 80;
            }
            if (!(flag = NetUtils.testIpAndPort(uri.getHost(), port, this.TIME_OUT))) {
                logger.error("Mapserver \u5730\u5740\u65e0\u6cd5\u8bbf\u95ee\uff1a{}", (Object)this.url);
                logger.error("1.\u8bf7\u6392\u67e5Mapserver\u670d\u52a1\u662f\u5426\u6b63\u5e38\u542f\u52a8");
                logger.error("2.\u68c0\u67e5\u7f51\u7edcip/\u7aef\u53e3\u662f\u5426\u5f00\u653e");
                throw new RuntimeException("Mapserver \u5f15\u64ce\u65e0\u6cd5\u8bbf\u95ee");
            }
        }
        catch (URISyntaxException e) {
            logger.error("Mapserver \u5730\u5740\u683c\u5f0f\u9519\u8bef\uff1a {}", (Object)this.url);
        }
    }
}

