/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service;

import com.mongodb.client.MongoDatabase;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.service.client.Client;
import com.northpool.service.netty.websocket.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaServer {
    private static Logger LOG = LoggerFactory.getLogger(MetaServer.class);
    private static AppConfig _config;
    private static Client _client;
    private static MongoDatabase _buziMgDb;

    public static void main(String[] args) {
        try {
            MetaServer.setUp(args);
            MetaServer.launchWSService();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private static void setUp(String[] args) throws Exception {
        System.out.println("=== parsing config ===");
        Log4jUtil.init2();
        Log4jUtil.setShowSql((boolean)true);
        Log4jUtil.enableDiagnose((boolean)true);
        AppConfig conf = new AppConfig();
        conf.loadConfig(args);
        _config = conf;
        _client = new Client(conf.mogoBuziDB, conf.zkUrl, conf.mapserverUrl);
        _buziMgDb = _client.getMongoDatabase();
        System.out.println("=== config completed ===");
    }

    private static void launchWSService() throws Exception {
        int tcpPort = 3000;
        LOG.info("\u51c6\u5907\u5f00\u542fWebSocket\u670d\u52a1\uff0c\u7aef\u53e3\uff1a" + tcpPort);
        new WebSocketServer(_client).bind(tcpPort);
    }

    public static class AppConfig {
        public String buziPgUrl = "jdbc:postgresql://172.16.83.221:5432/vtile2024";
        public String buziPgUser = "atlas";
        public String buziPgPwd = "Atlas@221";
        public String mogoBuziDB = "mongodb://172.16.83.221:27017/vtile2024";
        public String zkUrl = "localhost:2181";
        public String mapserverUrl = "http://172.16.83.221:8091/mapserver";

        public void loadConfig(String[] args) {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                System.out.println("\u53c2\u6570" + i + ": " + args[i]);
            }
            System.out.println("=================");
        }
    }
}

