/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.service.manager.vector_service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.FieldsConfig;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.data_service.tileInfo.IFeatureTileInfo;
import com.northpool.service.config.style.IStyleService;
import com.northpool.service.config.style.StyleBean;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.VectorServiceBean;
import com.northpool.service.config.vector_service.VectorServiceBuilder;
import com.northpool.service.config.vector_service.layer.CacheTileLayerBean;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.LayerBean;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.utfgrid.IUtfgridInfo;
import com.northpool.service.dao.IMetaDataDao;
import com.northpool.service.dao.vector_service.VectorServiceIgniteDao;
import com.northpool.service.dao.vector_service.VectorServiceZkDao;
import com.northpool.service.manager.abstractclass.ServiceManager;
import com.northpool.service.manager.style.IStyleManager;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.Constants;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.structure.queryhashtable.QueryHashTableHeap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorServiceManager
extends ServiceManager<IVectorService, VectorServiceBuilder>
implements IVectorServiceManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String MANAGER_ROOT = "vector_service";

    public VectorServiceManager() {
        super(new VectorServiceBuilder(), MANAGER_ROOT);
    }

    @Override
    protected IMetaDataDao<IVectorService> getMetaDataDao() throws Exception {
        if (this.metaDataDao == null) {
            if (this.client.getZoo() != null) {
                VectorServiceZkDao metaDataDao = new VectorServiceZkDao(this.idFieldName, (VectorServiceBuilder)this.beanBuilder, (QueryHashTableHeap<String, IVectorService>)this.table, this.client, this.managerRoot, this.readOnly, this);
                metaDataDao.init();
                this.metaDataDao = metaDataDao;
            } else if (this.client.getIgnite() != null) {
                VectorServiceIgniteDao igniteDao = new VectorServiceIgniteDao(this.idFieldName, (QueryHashTableHeap<String, IVectorService>)this.table, this.client, this.managerRoot, this.readOnly, this.client.getIgnite(), this);
                igniteDao.init();
                this.metaDataDao = igniteDao;
            }
        }
        return this.metaDataDao;
    }

    @Override
    public void register(IVectorService vectorService) throws Exception {
        this.checkInvalid(vectorService);
        super.doAdd(vectorService);
    }

    protected void checkInvalid(IVectorService vectorService) {
    }

    @Override
    public IVectorService get(String id) {
        IVectorService service = (IVectorService)super.get(id);
        return service;
    }

    @Override
    public String getJSON(String id) {
        IUtfgridInfo utfgridInfo;
        ICacheable cacheInfo;
        IVectorService vectorService;
        long queryStart = 0L;
        if (Log4jUtil.isDiagnoseEnable()) {
            queryStart = System.currentTimeMillis();
            this.logger.info(Log4jUtil.MARKER_DIAG, "\u670d\u52a1 ({}) JSON\u67e5\u8be2\u5f00\u59cb", (Object)id);
        }
        if ((vectorService = this.get(id)) == null) {
            return null;
        }
        if (Log4jUtil.isDiagnoseEnable()) {
            double querySeconds = (double)(System.currentTimeMillis() - queryStart) * 1.0 / 1000.0;
            this.logger.info(Log4jUtil.MARKER_DIAG, "\u670d\u52a1 ({}) JSON\u67e5\u8be2\u7ed3\u675f, \u8017\u65f6: {} s", (Object)id, (Object)String.format("%.3f", querySeconds));
        }
        JSONObject jsonService = (JSONObject)JSON.toJSON((Object)vectorService.getBean());
        this.addGrid(jsonService, vectorService);
        this.addLabelLayer(jsonService, vectorService);
        this.addFiledsAndStorageToLayers(jsonService, vectorService);
        IStorageInfo storageInfo = vectorService.getStorageInfo();
        if (storageInfo != null) {
            this.addStorageInfoToService(jsonService, storageInfo);
        }
        if ((cacheInfo = vectorService.getCacheInfo()) != null) {
            this.addCacheInfoToService(jsonService, cacheInfo);
        }
        if ((utfgridInfo = vectorService.getUtfgridInfo()) != null) {
            this.addUtfgridInfoToService(jsonService, utfgridInfo);
        }
        return JSON.toJSONString((Object)jsonService, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
    }

    private void addGrid(JSONObject jsonService, IVectorService vectorService) {
        try {
            if (vectorService.getOrigin() != null && vectorService.getResolutions() != null) {
                return;
            }
            IGridSystem gridSystem = vectorService.getGridTree();
            int[] origin = new int[]{(int)gridSystem.getMinX(), (int)gridSystem.getMaxY()};
            double[] resolutions = gridSystem.getResolutions();
            jsonService.put("origin", (Object)origin);
            jsonService.put("resolutions", (Object)resolutions);
        }
        catch (Exception ex) {
            this.logger.warn("\u6dfb\u52a0\u91d1\u5b57\u5854\u4fe1\u606f\u5931\u8d25", (Throwable)ex);
        }
    }

    private void addLabelLayer(JSONObject jsonService, IVectorService vectorService) {
        Map<String, ILayer> layerMap = vectorService.getLayerMap();
        JSONObject jsonLayerMap = jsonService.getJSONObject("layerMap");
        JSONObject cacheLayerMap = new JSONObject(new LinkedHashMap());
        Map<String, CacheTileLayerBean> cacheTileLayers = vectorService.getCacheTileLayers();
        Iterator<ILayer> iterator = layerMap.values().iterator();
        JSONObject resultLayerMap = new JSONObject(new LinkedHashMap());
        while (iterator.hasNext()) {
            JSONObject mapLayer;
            ILayer layer = iterator.next();
            Boolean hasCacheLayer = false;
            CacheTileLayerBean cacheLayer = null;
            if (cacheTileLayers != null) {
                cacheLayer = cacheTileLayers.get(layer.getDataServiceId());
            }
            if (cacheLayer != null && !cacheLayer.getId().equals(layer.getId())) {
                cacheLayerMap.put(cacheLayer.getId(), (Object)layer.getId());
                hasCacheLayer = true;
            }
            resultLayerMap.put(layer.getId(), jsonLayerMap.get((Object)layer.getId()));
            if (layer.getLabel() == null || layer.getLabel().getType() == Constants.LABEL_TYPE.point) continue;
            JSONObject layerObj = (JSONObject)JSON.toJSON((Object)layer.getBean());
            layerObj.put("labelOnly", (Object)true);
            layerObj.put("id", (Object)(layer.getId() + LayerBean.LABEL_SUFFIX));
            resultLayerMap.put(layer.getId() + LayerBean.LABEL_SUFFIX, (Object)layerObj);
            if (hasCacheLayer.booleanValue()) {
                cacheLayerMap.put(cacheLayer.getId() + LayerBean.LABEL_SUFFIX, (Object)(layer.getId() + LayerBean.LABEL_SUFFIX));
            }
            if ((mapLayer = resultLayerMap.getJSONObject(layer.getId())) == null) continue;
            mapLayer.put("haveLabel", (Object)false);
            mapLayer.remove((Object)"label");
        }
        jsonService.put("layerMap", (Object)resultLayerMap);
        jsonService.put("cacheLayerMap", (Object)cacheLayerMap);
    }

    private void addUtfgridInfoToService(JSONObject jsonService, IUtfgridInfo utfgridInfo) {
        JSONObject utfObj = (JSONObject)JSON.toJSON((Object)utfgridInfo.getBean());
        IStorageInfo storageInfo = utfgridInfo.getStorageInfo();
        if (storageInfo != null) {
            JSONObject storageJsonObj = (JSONObject)JSON.toJSON((Object)storageInfo.getDataSource().getBean());
            storageJsonObj.put("storageName", (Object)storageInfo.getStorageName());
            storageJsonObj.put("startLevel", (Object)storageInfo.getStartLevel());
            storageJsonObj.put("endLevel", (Object)storageInfo.getEndLevel());
            storageJsonObj.put("completed", (Object)storageInfo.isCompleted());
            utfObj.put("storageInfo", (Object)storageJsonObj);
        }
        jsonService.put("utfgridInfo", (Object)utfObj);
    }

    private void addCacheInfoToService(JSONObject jsonService, ICacheable cacheInfo) {
        JSONObject obj = new JSONObject();
        obj.put("dataCacheSource", cacheInfo.getDataCacheSource().getBean());
        obj.put("imgCacheSource", cacheInfo.getImgCacheSource().getBean());
        obj.put("needDataCache", (Object)cacheInfo.needDataCache());
        obj.put("needImgCache", (Object)cacheInfo.needImgCache());
        obj.put("imgScript", (Object)cacheInfo.getImgScript());
        obj.put("dataScript", (Object)cacheInfo.getDataScript());
        jsonService.put("cacheInfo", (Object)obj);
    }

    private void addStorageInfoToService(JSONObject jsonService, IStorageInfo storageInfo) {
        JSONObject storageJsonObj = (JSONObject)JSON.toJSON((Object)storageInfo.getDataSource().getBean());
        storageJsonObj.put("storageName", (Object)storageInfo.getStorageName());
        storageJsonObj.put("startLevel", (Object)storageInfo.getStartLevel());
        storageJsonObj.put("endLevel", (Object)storageInfo.getEndLevel());
        storageJsonObj.put("completed", (Object)storageInfo.isCompleted());
        jsonService.put("storageInfo", (Object)storageJsonObj);
    }

    private void addFiledsAndStorageToLayers(JSONObject jsonService, IVectorService vectorService) {
        JSONObject layerMap = jsonService.getJSONObject("layerMap");
        layerMap.forEach((layerName, layer) -> {
            IStorageInfo storageInfo;
            ILayer iLayer;
            String name = layerName;
            if (layerName.endsWith(LayerBean.LABEL_SUFFIX)) {
                name = layerName.substring(0, layerName.length() - 3);
            }
            if ((iLayer = vectorService.getLayerMap().get(name)) == null) {
                throw new RuntimeException("\u670d\u52a1\u4e2d\u672a\u627e\u5230\u56fe\u5c42: " + name);
            }
            List<FieldsConfig> fieldsConfigs = vectorService.getLayerFields(iLayer);
            String idFieldName = vectorService.getLayerIdFieldName(iLayer);
            String ideFieldType = vectorService.getLayerIdFieldType(iLayer);
            String geometryType = vectorService.getLayerGeometryType(iLayer);
            if (layerName.endsWith(LayerBean.LABEL_SUFFIX) && geometryType.contains("POLYGON")) {
                geometryType = Constants.GEO_TYPE.POINT.name();
            }
            JSONObject jsonLayer = (JSONObject)layer;
            jsonLayer.put("fields", fieldsConfigs);
            jsonLayer.put("geometryType", (Object)geometryType);
            jsonLayer.put("idField", (Object)idFieldName);
            jsonLayer.put("idFieldType", (Object)ideFieldType);
            IDataService dataService = iLayer.getLevelMap().values().iterator().next().getDataSet().getDataService();
            IFeatureTileInfo featureTileInfo = dataService.getFeatureTileInfo();
            if (featureTileInfo != null) {
                JSONObject featureTileInfoObj = (JSONObject)JSON.toJSON((Object)featureTileInfo.getBean());
                featureTileInfoObj.remove((Object)"storageInfo");
                jsonLayer.put("featureTileInfo", (Object)featureTileInfoObj);
            }
            if ((storageInfo = dataService.getStorageInfo()) == null) {
                return;
            }
            String storageName = storageInfo.getStorageName();
            if (layerName.endsWith(LayerBean.LABEL_SUFFIX)) {
                storageName = storageInfo.getLabelStorageName();
            }
            if (storageName == null) {
                return;
            }
            JSONObject storageJsonObj = (JSONObject)JSON.toJSON((Object)storageInfo.getDataSource().getBean());
            storageJsonObj.put("storageName", (Object)storageName);
            storageJsonObj.put("startLevel", (Object)storageInfo.getStartLevel());
            storageJsonObj.put("endLevel", (Object)storageInfo.getEndLevel());
            storageJsonObj.put("completed", (Object)storageInfo.isCompleted());
            jsonLayer.put("storageInfo", (Object)storageJsonObj);
        });
    }

    @Override
    public void unRegister(String id) throws Exception {
        super.doRemove(id);
    }

    @Override
    public void update(IVectorService vectorService) throws Exception {
        this.checkInvalid(vectorService);
        super.doUpdate(vectorService);
    }

    @Override
    public boolean checkVersion(String id, String version) {
        IVectorService vectorService = this.get(id);
        if (vectorService != null) {
            return Objects.equals(version, vectorService.getVersion());
        }
        return false;
    }

    @Override
    public void rename(String oldName, String newName) throws Exception {
        IStorageInfo utfStorageInfo;
        IUtfgridInfo utfgridInfo;
        IVectorService old = this.get(oldName);
        if (old == null) {
            throw new RuntimeException("\u670d\u52a1 " + oldName + " \u4e0d\u5b58\u5728");
        }
        IVectorService newService = this.get(newName);
        if (newService != null) {
            throw new RuntimeException("\u670d\u52a1 " + newService + " \u5df2\u5b58\u5728");
        }
        IStyleManager styleManager = this.client.getStyleManager();
        QueryFilter filter = new QueryFilter();
        filter.addFilter("ownServer", Constants.OPERATION.EQ, new Object[]{oldName});
        List<IStyleService> styles = styleManager.list(filter);
        for (IStyleService style : styles) {
            ((StyleBean)style.getBean()).setOwnServer(newName);
            styleManager.update(style);
        }
        IStorageInfo storageInfo = old.getStorageInfo();
        if (storageInfo != null) {
            storageInfo.rename(newName);
            storageInfo.renameLabel(newName);
        }
        if ((utfgridInfo = old.getUtfgridInfo()) != null && (utfStorageInfo = utfgridInfo.getStorageInfo()) != null) {
            utfStorageInfo.rename(newName + "_utfgrid");
        }
        this.unRegister(oldName);
        ((VectorServiceBean)old.getBean()).setId(newName);
        this.register(old);
    }

    @Override
    public void unRegisterCascade(String id) throws Exception {
        IStorageInfo utfStorageInfo;
        IUtfgridInfo utfgridInfo;
        IVectorService service = this.get(id);
        IStorageInfo storageInfo = service.getStorageInfo();
        if (storageInfo != null) {
            storageInfo.drop();
        }
        if ((utfgridInfo = service.getUtfgridInfo()) != null && (utfStorageInfo = utfgridInfo.getStorageInfo()) != null) {
            utfStorageInfo.drop();
        }
        IStyleManager styleManager = this.client.getStyleManager();
        QueryFilter filter = new QueryFilter();
        filter.addFilter("ownServer", Constants.OPERATION.EQ, new Object[]{id});
        List<IStyleService> styles = styleManager.list(filter);
        String[] styleIds = (String[])styles.stream().map(style -> (String)style.getId()).toArray(String[]::new);
        ICacheable cacheInfo = service.getCacheInfo();
        if (cacheInfo != null) {
            for (String styleId : styleIds) {
                cacheInfo.drop(id, styleId);
            }
        }
        styleManager.remove(styleIds);
        this.unRegister(id);
    }

    @Override
    public String getCachedKeys() {
        if (null == this.table) {
            return null;
        }
        List keys = this.table.keySet();
        return JSON.toJSONString((Object)keys);
    }
}

