/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.handler.update;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.ServerTileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.options.TileCutOptions;
import com.northpool.gis.vector_cut.screenloction.tools.varint.VarintReader;
import com.northpool.gis.vector_cut.screenloction.writer.VarintWriter;
import com.northpool.gis.vector_cut.screenloction.writer.Writer;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.handler.update.AbstractUpdateHandler;
import com.northpool.tiledispatch.consumer.saver.ITileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.northpool.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class VectorServerUpdateHandler
extends AbstractUpdateHandler {
    long timestamp;
    IDocumentEncoder encoder;
    Map<String, Integer> proSizeMap;

    public VectorServerUpdateHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, long timestamp, boolean removeOldTile) {
        super(executor, bufferSize, removeOldTile);
        this.cell = cell;
        this.saver = saver;
        this.proSizeMap = this.getProSizeMap();
        this.timestamp = timestamp;
        this.encoder = new TileDataDocumentEncoder();
    }

    private Map<String, Integer> getProSizeMap() {
        ServerTileCutterCell serverCell = (ServerTileCutterCell)this.cell;
        IVectorService vectorService = serverCell.getServer();
        Map layerMap = vectorService.getLayerMap();
        HashMap<String, Integer> proSizeMap = new HashMap<String, Integer>(layerMap.size());
        layerMap.forEach((k, v) -> proSizeMap.put((String)k, vectorService.getLayerFields(v).size() - 1));
        return proSizeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleItem(GridExtent extent, String extraFilter) {
        if (this.resume && this.saver.hasRecord(extent, this.timestamp) || this.cancel) {
            this.count.countDown();
            return;
        }
        if (this.error) {
            this.count.countDown();
            return;
        }
        JSONObject filterObj = JSON.parseObject((String)extraFilter);
        List<Object[]> data = null;
        try {
            data = (List<Object[]>)this.cell.cut((Object)extent, new TileCutOptions(extraFilter));
            int down = this.cell.getDown();
            GridExtent[] extents = extent.getDown(down);
            if (filterObj != null && this.proSizeMap.size() != 1 && filterObj.size() != this.proSizeMap.size()) {
                Map<String, byte[]> oldData = this.saver.getTiles(Arrays.asList(extents), null);
                data = this.mergeData(extent.getGrid(), data, oldData, filterObj);
            } else {
                data.forEach(item -> {
                    Object[] arr = item;
                    arr[1] = ((Writer)arr[1]).getData();
                });
            }
            if (this.removeOldTile) {
                this.removeOldTile(extent);
            } else {
                this.updateOldTileEndTime(extent, data, this.timestamp);
            }
            this.saver.updateEndTimeAndSave(data, this.timestamp, this.encoder);
        }
        catch (Throwable e) {
            if (this.errorHandler != null) {
                this.errorHandler.handle(extent);
            } else {
                this.e = e;
                this.error = true;
            }
        }
        finally {
            this.count.countDown();
        }
    }

    private List<Object[]> mergeData(IGridSystem grid, List<Object[]> data, Map<String, byte[]> oldDataMap, JSONObject filterObj) {
        int dataSize = data == null ? 0 : data.size();
        ArrayList<Object[]> list = new ArrayList<Object[]>(dataSize);
        HashSet<String> keys = new HashSet<String>(dataSize);
        HashMap<String, VarintWriter> writerMap = new HashMap<String, VarintWriter>(dataSize);
        if (data != null) {
            String key = null;
            Iterator<Object> iterator = data.iterator();
            while (iterator.hasNext()) {
                Object[] item;
                Object[] arr = item = iterator.next();
                GridExtent extent = (GridExtent)arr[0];
                VarintWriter writer = (VarintWriter)arr[1];
                key = extent.getKey();
                writerMap.put(key, writer);
                keys.add(key);
            }
        }
        keys.addAll(oldDataMap.keySet());
        byte[] content = null;
        for (String extentKey : keys) {
            byte[] oldData;
            VarintWriter writer;
            if (data == null || !writerMap.containsKey(extentKey)) {
                if (!oldDataMap.containsKey(extentKey)) continue;
                writer = new VarintWriter();
                oldData = oldDataMap.get(extentKey);
                try {
                    this.addOldNotUpdateLayerIntoNewWriter(filterObj, writer, oldData);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                content = writer.getData();
            } else {
                writer = (VarintWriter)writerMap.get(extentKey);
                if (oldDataMap.containsKey(extentKey)) {
                    oldData = oldDataMap.get(extentKey);
                    try {
                        this.addOldNotUpdateLayerIntoNewWriter(filterObj, writer, oldData);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                content = writer.getData();
            }
            list.add(new Object[]{this.getExtentFromKey(grid, extentKey), content});
        }
        return list;
    }

    private void addOldNotUpdateLayerIntoNewWriter(JSONObject filterObj, VarintWriter writer, byte[] oldData) throws Exception {
        VarintReader reader = new VarintReader(ByteBuffer.wrap(oldData), 4, this.proSizeMap);
        this.proSizeMap.keySet().forEach(layerName -> {
            ByteBuffer bytes;
            if (!filterObj.containsKey(layerName) && (bytes = reader.getLayerBuffer(layerName)) != null) {
                writer.addLayer(layerName, bytes.array());
            }
        });
    }

    private GridExtent getExtentFromKey(IGridSystem grid, String key) {
        String[] splits = key.split("_");
        Integer level = Integer.valueOf(splits[0]);
        Integer x = Integer.valueOf(splits[1]);
        Integer y = Integer.valueOf(splits[2]);
        return grid.getExtent(level.intValue(), x.intValue(), y.intValue());
    }
}

