/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.saver.endocer;

import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;

public class TileDataDocumentEncoder
implements IDocumentEncoder<Object[]> {
    public static final int MAX_DATA_SIZE = 0xFFFC00;

    @Override
    public List<Document> encode(Object[] datas) {
        return this.encode(datas, (Long)null);
    }

    @Override
    public List<Document> encode(Object[] datas, Long beginTime) {
        GridExtent extent = (GridExtent)datas[0];
        if (datas[1] != null) {
            byte[] bytes = (byte[])datas[1];
            ArrayList<byte[]> bytesList = new ArrayList<byte[]>();
            if (bytes.length > 0xFFFC00) {
                byte[] split;
                int num = bytes.length / 0xFFFC00;
                for (int i = 0; i < num; ++i) {
                    split = new byte[0xFFFC00];
                    System.arraycopy(bytes, 0xFFFC00 * i, split, 0, 0xFFFC00);
                    bytesList.add(split);
                }
                int surplus = bytes.length % 0xFFFC00;
                if (surplus != 0) {
                    split = new byte[surplus];
                    System.arraycopy(bytes, 0xFFFC00 * num, split, 0, surplus);
                    bytesList.add(split);
                }
            } else {
                bytesList.add(bytes);
            }
            ArrayList<Document> docs = new ArrayList<Document>(bytesList.size());
            bytesList.forEach(byteArr -> {
                Document doc = new Document();
                doc.put(MongoTileSaver.rName, (Object)extent.getX());
                doc.put(MongoTileSaver.cName, (Object)extent.getY());
                doc.put(MongoTileSaver.lName, (Object)extent.getLevel());
                doc.put(MongoTileSaver.fvectorName, byteArr);
                if (beginTime != null) {
                    doc.put(MongoTileSaver.beginTime, (Object)beginTime);
                }
                docs.add(doc);
            });
            return docs;
        }
        return null;
    }
}

