/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.producer;

import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.cell.layout.ITileLayoutPrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.gis.vector_cut.screenloction.cell.options.TileCutOptions;
import com.northpool.service.manager.task.exception.TaskCancelException;
import com.northpool.service.manager.task.log.ITaskLogger;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.northpool.tiledispatch.consumer.scroll.ITileScroll;
import com.northpool.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.northpool.tiledispatch.consumer.scroll.TileRangeScroll;
import com.northpool.tiledispatch.exception.ProduceException;
import com.northpool.tiledispatch.exception.TileCutProduceException;
import com.northpool.tiledispatch.producer.abstractclass.AbstractTileProducer;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileImgCacheProducer
extends AbstractTileProducer {
    private MongoTileSaver tileSaver;
    private ITileLayoutPrecutter<GridExtent, List> layoutCell;
    protected IDocumentEncoder encoder;
    private static Logger logger = LoggerFactory.getLogger(TileImgCacheProducer.class);

    public TileImgCacheProducer(ITileLayoutPrecutter tileLayoutCell, MongoTileSaver tileSaver, ExecutorService executor, int beginLevel, int endLevel, IGridSystem grid, String bbox, String name, IDocumentEncoder encoder) {
        this.tileSaver = tileSaver;
        this.layoutCell = tileLayoutCell;
        this.executor = executor;
        this.grid = grid;
        this.name = name;
        this.beginLevel = beginLevel;
        this.endLevel = endLevel;
        this.bbox = StringUtils.isNotEmpty((CharSequence)bbox) ? bbox : grid.getBBox();
        this.encoder = encoder;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.tileSaver.init();
        this.layoutCell.init();
        this.init = true;
    }

    @Override
    public void produce() throws ProduceException, TaskCancelException {
        try {
            this.layoutCell.setFilterLevel(Integer.valueOf(this.beginLevel));
            int _start = this.beginLevel - 1;
            int _end = this.beginLevel == this.endLevel ? this.endLevel : this.endLevel - 1;
            this._produce(this.bbox, _start, _end, true);
        }
        catch (TaskCancelException | TileCutProduceException e) {
            e.printStackTrace();
            this.e = e;
            this.error = true;
            throw e;
        }
    }

    public void _produce(String bbox, int beginLevel, int endLevel, boolean isnew) throws TileCutProduceException, TaskCancelException {
        if (isnew) {
            TileRangeScroll tileRangeScroll = new TileRangeScroll(beginLevel, bbox, this.grid);
            tileRangeScroll.init();
            this.produce(tileRangeScroll);
        }
        for (int i = beginLevel + 1; i <= endLevel; ++i) {
            logger.info("produce next level grids...");
            Integer filterLevel = null;
            if (!this.layoutCell.isSameFilter()) {
                filterLevel = this.layoutCell.getFilterLevel();
            }
            TileLayoutScroll scroll = new TileLayoutScroll(i, this.grid, this.tileSaver, filterLevel, true);
            scroll.init();
            this.produce(scroll);
        }
    }

    private void produce(ITileScroll scroll) throws TileCutProduceException, TaskCancelException {
        int nPercent10;
        long c1 = System.currentTimeMillis();
        int nTotal = scroll.getCount().intValue();
        String msg = " \u6784\u5efa\u7b2c" + scroll.getLevel() + "\u5c42\u7f51\u683c,  \u5927\u7ea6\u4e2a\u6570 : " + nTotal;
        String log = this.name + msg;
        this.log(log);
        int n = nPercent10 = nTotal > 10 ? nTotal / 10 : 1;
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info(Log4jUtil.MARKER_DIAG, "{} \u7ea7\u9884\u8ba1\u6709 {} \u4e2a\u74e6\u7247", (Object)scroll.getLevel(), (Object)nTotal);
        }
        CountDownLatch count = new CountDownLatch(nTotal);
        AtomicLong nFinished = new AtomicLong(0L);
        AtomicLong nRealTileCount = new AtomicLong(0L);
        ScheduledFuture<?> future = this.logPool.scheduleWithFixedDelay(() -> {
            if (this.error || this.cancel) {
                return;
            }
            String logMsg = this.name + " ||\u521b\u5efa\u56fe\u7247\u7f13\u5b58:" + nFinished.get() + "/" + nTotal;
            this.log(logMsg);
        }, 2L, 60L, TimeUnit.SECONDS);
        int index = 0;
        while (scroll.hasNext()) {
            TileLayout layout = scroll.next();
            GridExtent extent = layout.getExtent();
            String extraFilter = layout.getExtraFilter();
            TileCutOptions options = new TileCutOptions();
            options.setExtraSqlFilter(extraFilter);
            options.setStart(0);
            options.setLimit(1);
            if (this.error || this.cancel) {
                count.countDown();
            } else {
                this.executor.execute(() -> {
                    if (!this.error && !this.cancel) {
                        try {
                            boolean isSameFilter = this.layoutCell.isSameFilter();
                            boolean bNeedCut = false;
                            if (isSameFilter) {
                                bNeedCut = this.tileSaver.hasRecord(extent, null, false) == false;
                            } else {
                                boolean bl = bNeedCut = this.tileSaver.hasRecord(extent, this.layoutCell.getFilterLevel(), true) == false;
                            }
                            if (bNeedCut) {
                                boolean isGridHasData;
                                List layouts = (List)this.layoutCell.cut((Object)extent, options);
                                this.send(layouts);
                                boolean bl = isGridHasData = null != layouts;
                                if (isGridHasData) {
                                    nRealTileCount.incrementAndGet();
                                }
                            }
                            nFinished.incrementAndGet();
                            if (nPercent10 > 1 && 0L == nFinished.get() % (long)nPercent10) {
                                logger.info(Log4jUtil.MARKER_DIAG, "==>\u7b2c{}\u7ea7\u56fe\u7247\u7f13\u5b58\u74e6\u7247\u5927\u7ea6\u8fdb\u5ea6\uff1a{}%", (Object)extent.getLevel(), (Object)(nFinished.get() * 100L / (long)nTotal));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            logger.error(e.getMessage(), (Throwable)e);
                            this.error = true;
                            this.e = e;
                        }
                    }
                    count.countDown();
                });
            }
            ++index;
        }
        int deviation = nTotal - index;
        for (int i = 0; i < deviation; ++i) {
            count.countDown();
        }
        try {
            count.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new TileCutProduceException(e);
        }
        if (future != null) {
            future.cancel(true);
        }
        long nRealCount = nRealTileCount.get();
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info(Log4jUtil.MARKER_DIAG, "{} \u7ea7\u5b9e\u9645\u6709 {} \u4e2a\u74e6\u7247\u5f85\u5904\u7406", (Object)scroll.getLevel(), (Object)nRealCount);
        }
        if (this.error || this.cancel) {
            if (this.cancel) {
                throw (TaskCancelException)this.e;
            }
            logger.error(this.e.getMessage(), this.e);
            throw new TileCutProduceException(this.e.getMessage());
        }
        long c2 = System.currentTimeMillis();
        msg = " \u5b8c\u6210\u7b2c" + scroll.getLevel() + "\u5c42\u7f51\u683c\u6846\u67b6\u6784\u5efa\uff0c\u5f85\u5207\u7f51\u683c\u4e2a\u6570\uff1a" + nRealCount + "\uff0c\u8017\u65f6: " + (c2 - c1) + "ms";
        log = this.name + msg;
        this.log(log);
    }

    @Override
    public void cancel() {
        this.cancel = true;
        String msg = "\u4efb\u52a1\u5728\u74e6\u7247\u6846\u67b6\u6784\u5efa\u9636\u6bb5\u88ab\u53d6\u6d88";
        String log = this.name + msg;
        this.e = new TaskCancelException(log);
    }

    @Override
    public <T> void send(List<T> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        if (Log4jUtil.isDiagnoseEnable() && data.get(0) instanceof GridExtent) {
            logger.info(Log4jUtil.MARKER_DIAG, "\u751f\u4ea7\u74e6\u7247\u6846\u67b6: " + ((GridExtent)data.get(0)).getKey());
        } else if (Log4jUtil.isDiagnoseEnable() && data.get(0) instanceof TileLayout) {
            logger.info(Log4jUtil.MARKER_DIAG, "\u751f\u4ea7\u74e6\u7247\u6846\u67b6: " + ((TileLayout)data.get(0)).getExtent().getKey());
        }
        this.tileSaver.save(data, this.encoder);
    }

    @Override
    public void setLogger(ITaskLogger cutLogger) {
        this.cutLogger = cutLogger;
    }

    public void setGrid(IGridSystem grid) {
        this.grid = grid;
    }
}

