/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.producer;

import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.cell.layout.ITileLayoutPrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.gis.vector_cut.screenloction.cell.options.TileCutOptions;
import com.northpool.service.manager.task.exception.TaskCancelException;
import com.northpool.service.manager.task.log.ITaskLogger;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.northpool.tiledispatch.consumer.scroll.ITileScroll;
import com.northpool.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.northpool.tiledispatch.consumer.scroll.TileRangeScroll;
import com.northpool.tiledispatch.exception.ProduceException;
import com.northpool.tiledispatch.exception.TileCutProduceException;
import com.northpool.tiledispatch.producer.abstractclass.AbstractTileProducer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileLayoutProducer
extends AbstractTileProducer {
    private MongoTileSaver tileSaver;
    private ITileLayoutPrecutter<GridExtent, List> layoutCell;
    protected IDocumentEncoder encoder;
    private boolean isUtfgrid = false;
    private static Logger logger = LoggerFactory.getLogger(TileLayoutProducer.class);

    public TileLayoutProducer(ITileLayoutPrecutter tileLayoutCell, MongoTileSaver tileSaver, ExecutorService executor, int beginLevel, int endLevel, IGridSystem grid, String bbox, String name, IDocumentEncoder encoder) {
        this.tileSaver = tileSaver;
        this.layoutCell = tileLayoutCell;
        this.executor = executor;
        this.grid = grid;
        this.name = name;
        this.beginLevel = beginLevel;
        this.endLevel = endLevel;
        this.bbox = StringUtils.isNotEmpty((CharSequence)bbox) ? bbox : grid.getBBox();
        this.encoder = encoder;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.tileSaver.init();
        this.layoutCell.init();
        this.init = true;
    }

    @Override
    public void produce() throws ProduceException, TaskCancelException {
        try {
            Integer to;
            Integer from;
            if (this.isUtfgrid) {
                from = this.beginLevel;
                to = this.endLevel;
            } else {
                this.layoutCell.setFilterLevel(Integer.valueOf(this.beginLevel));
                from = this.grid.getBeginLevel();
                to = this.beginLevel - 1;
            }
            this._produce(this.bbox, from, to, true);
        }
        catch (TaskCancelException | TileCutProduceException e) {
            e.printStackTrace();
            this.e = e;
            this.error = true;
            throw e;
        }
    }

    public void _produce(String bbox, int beginLevel, int endLevel, boolean isnew) throws TileCutProduceException, TaskCancelException {
        if (isnew) {
            TileRangeScroll tileRangeScroll = new TileRangeScroll(beginLevel, bbox, this.grid);
            tileRangeScroll.init();
            this.filterAndSaveGrids(tileRangeScroll);
        }
        for (int i = beginLevel + 1; i <= endLevel; ++i) {
            logger.info("produce level --" + i + " grids...");
            Integer filterLevel = null;
            if (!this.layoutCell.isSameFilter()) {
                filterLevel = this.layoutCell.getFilterLevel();
            }
            TileLayoutScroll scroll = new TileLayoutScroll(i, this.grid, this.tileSaver, filterLevel, true);
            scroll.init();
            this.filterAndSaveGrids(scroll);
        }
    }

    private void filterAndSaveGrids(ITileScroll scroll) throws TileCutProduceException, TaskCancelException {
        int nPercent10;
        long c1 = System.currentTimeMillis();
        int nTotal = scroll.getCount().intValue();
        String msg = " L-" + scroll.getLevel() + " \u7f51\u683c\u6570\u5927\u7ea6 : " + nTotal;
        this.log(msg);
        int n = nPercent10 = nTotal > 10 ? nTotal / 10 : 1;
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info(Log4jUtil.MARKER_DIAG, "{} \u7ea7\u9884\u8ba1\u6709 {} \u4e2a\u74e6\u7247", (Object)scroll.getLevel(), (Object)nTotal);
        }
        AtomicLong nFinished = new AtomicLong(0L);
        AtomicLong nRealTileCount = new AtomicLong(0L);
        AtomicLong lastPct = new AtomicLong(0L);
        ScheduledFuture<?> logFuture = this.logPool.scheduleWithFixedDelay(() -> {
            if (this.error || this.cancel) {
                return;
            }
            if (nPercent10 > 1 && nFinished.get() / (long)nPercent10 > lastPct.get()) {
                lastPct.updateAndGet(oldVal -> nFinished.get() / (long)nPercent10);
                String logMsg = this.name + " ||\u521b\u5efa\u6846\u67b6:" + nFinished.get() + "/" + nTotal;
                this.log(logMsg);
            }
        }, 2L, 60L, TimeUnit.SECONDS);
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        while (scroll.hasNext()) {
            TileLayout layout = scroll.next();
            GridExtent extent = layout.getExtent();
            String extraFilter = layout.getExtraFilter();
            TileCutOptions options = new TileCutOptions();
            options.setExtraSqlFilter(extraFilter);
            options.setStart(0);
            options.setLimit(1);
            if (this.error || this.cancel) continue;
            CompletableFuture<Void> cutFuture = CompletableFuture.runAsync(() -> {
                try {
                    boolean bNeedCut;
                    boolean isSameFilter = this.layoutCell.isSameFilter();
                    if (isSameFilter) {
                        bNeedCut = this.tileSaver.hasRecord(extent, null, false) == false;
                    } else {
                        boolean bl = bNeedCut = this.tileSaver.hasRecord(extent, this.layoutCell.getFilterLevel(), true) == false;
                    }
                    if (bNeedCut) {
                        boolean isGridHasData;
                        List layouts = (List)this.layoutCell.cut((Object)extent, options);
                        this.send(layouts);
                        boolean bl = isGridHasData = null != layouts;
                        if (isGridHasData) {
                            nRealTileCount.incrementAndGet();
                        }
                    }
                    nFinished.incrementAndGet();
                    if (nPercent10 > 1 && 0L == nFinished.get() % (long)nPercent10) {
                        logger.info(Log4jUtil.MARKER_DIAG, "==>\u7b2c{}\u7ea7\u9884\u5236\u6846\u67b6\u5927\u7ea6\u8fdb\u5ea6\uff1a{}%", (Object)extent.getLevel(), (Object)(nFinished.get() * 100L / (long)nTotal));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage(), (Throwable)e);
                    this.error = true;
                    this.e = e;
                }
            }, this.executor);
            futures.add(cutFuture);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        logFuture.cancel(true);
        long nRealCount = nRealTileCount.get();
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info(Log4jUtil.MARKER_DIAG, "{} \u7ea7\u5b9e\u9645\u6709 {} \u4e2a\u74e6\u7247\u5f85\u5904\u7406", (Object)scroll.getLevel(), (Object)nRealCount);
        }
        if (this.error || this.cancel) {
            if (this.cancel) {
                throw (TaskCancelException)this.e;
            }
            logger.error(this.e.getMessage(), this.e);
            throw new TileCutProduceException(this.e.getMessage());
        }
        if (nRealCount > 0L) {
            long c2 = System.currentTimeMillis();
            msg = " \u5b8c\u6210\u7b2c" + scroll.getLevel() + "\u5c42\u7f51\u683c\u6846\u67b6\u6784\u5efa\uff0c\u5b9e\u9645\u7f51\u683c\u6570\uff1a" + nRealCount + "\uff0c\u8017\u65f6: " + (c2 - c1) + "ms";
            this.log(msg);
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
        String msg = "\u4efb\u52a1\u5728\u74e6\u7247\u6846\u67b6\u6784\u5efa\u9636\u6bb5\u88ab\u53d6\u6d88";
        String log = this.name + msg;
        this.e = new TaskCancelException(log);
    }

    @Override
    public <T> void send(List<T> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        this.tileSaver.save(data, this.encoder);
    }

    @Override
    public void setLogger(ITaskLogger cutLogger) {
        this.cutLogger = cutLogger;
    }

    public void setGrid(IGridSystem grid) {
        this.grid = grid;
    }

    public boolean isUtfgrid() {
        return this.isUtfgrid;
    }

    public void setUtfgrid(boolean utfgrid) {
        this.isUtfgrid = utfgrid;
    }
}

