/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.handler;

import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.tiledispatch.consumer.buffer.IDataBuffer;
import com.northpool.tiledispatch.consumer.handler.abstractclass.AbstractTileHandlerStream;
import com.northpool.tiledispatch.consumer.handler.error.ITileErrorHandler;
import com.northpool.tiledispatch.consumer.saver.ITileSaver;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureTileCutHandler
extends AbstractTileHandlerStream<Object[]> {
    Logger logger = LoggerFactory.getLogger(FeatureTileCutHandler.class);
    protected ITileCutterCell<Object[], List<Object[]>> cell;
    protected IGridSystem grid;
    protected IDataBuffer tileBuffer;
    public static final int BUFFER_SIZE = 30;

    public FeatureTileCutHandler(ExecutorService executor, int bufferSize, IGridSystem grid, ITileCutterCell cell, ITileSaver saver, IDataBuffer<Object[]> dataBuffer) {
        super(executor, bufferSize);
        this.grid = grid;
        this.cell = cell;
        this.tileBuffer = dataBuffer;
    }

    public FeatureTileCutHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, IGridSystem grid, ITileErrorHandler errorHandler, IDataBuffer<Object[]> dataBuffer) {
        super(executor, bufferSize);
        this.grid = grid;
        this.cell = cell;
        this.tileBuffer = dataBuffer;
        this.errorHandler = errorHandler;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        if (this.cell != null) {
            this.cell.init();
        }
        this.tileBuffer.init();
        this.init = true;
    }

    @Override
    public void flush() {
        if (!this.buffer.isEmpty()) {
            int size = this.buffer.size();
            for (int i = 0; i < size; ++i) {
                this.handleItem((Object[])this.buffer.get(i));
            }
            this.buffer.clear();
        }
    }

    @Override
    public void handle(Object[] feature) {
        this.buffer.add(feature);
        if (this.buffer.size() < 30) {
            return;
        }
        int size = this.buffer.size();
        if (this.executor != null) {
            if (this.executor.isShutdown()) {
                this.executor = TileDispatchTaskManager.getInstance().getNewExecutor();
            }
            ArrayList batch = new ArrayList(size);
            batch.addAll(this.buffer);
            this.buffer.clear();
            this.executor.execute(() -> {
                for (int i = 0; i < size; ++i) {
                    Object[] item = (Object[])batch.get(i);
                    this.handleItem(item);
                }
            });
        } else {
            for (int i = 0; i < size; ++i) {
                Object[] item = (Object[])this.buffer.get(i);
                this.handleItem(item);
            }
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleItem(Object[] item) {
        block7: {
            if (this.cancel) {
                return;
            }
            if (this.error) {
                return;
            }
            List data = null;
            try {
                data = (List)this.cell.cut((Object)item, null);
                this.tileBuffer.push(data);
            }
            catch (Throwable e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handle(item);
                    break block7;
                }
                this.logger.error("\u8981\u7d20\u74e6\u7247\u9884\u70ed\u9519\u8bef\uff1a" + StringUtils.join((Object[])ArrayUtils.subarray((Object[])item, (int)0, (int)(item.length - 1)), (String)","), e);
                this.e = e;
                this.error = true;
            }
        }
    }

    @Override
    public void save() {
        try {
            this.tileBuffer.flush();
        }
        catch (Exception e) {
            this.e = e;
            this.error = true;
        }
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        super.awaitTermination(timeout, unit);
    }

    @Override
    public void cancel() {
        this.cell.cancel();
        super.cancel();
    }
}

