/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.task.task;

import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.LayerTileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.layout.ITileLayoutPrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.layout.LayerTilePrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.process.ProcessList;
import com.northpool.gis.vector_cut.screenloction.enums.LAYER_TYPE;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.Constants;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.VectorCutMongoConsumer;
import com.northpool.tiledispatch.consumer.handler.TileListCutHandler;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.GridExtentDocumentEncoder;
import com.northpool.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.northpool.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.northpool.tiledispatch.producer.ITileProducer;
import com.northpool.tiledispatch.producer.TileLayoutProducer;
import com.northpool.tiledispatch.task.stage.TileConsumeStage;
import com.northpool.tiledispatch.task.stage.TileProduceStage;
import com.northpool.tiledispatch.task.stage.abstractclass.AbstractTaskStage;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileLayerCutTask
extends AbstractTileDispatchTask {
    Logger logger = LoggerFactory.getLogger(TileLayerCutTask.class);
    protected ILayer layer;
    protected MongodbDataSource mongodbDataSource;
    protected MongoTileSaver saver;
    protected LAYER_TYPE layerType = LAYER_TYPE.all;
    public static final int CUT_INTERVAL = 4;

    public TileLayerCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel, LAYER_TYPE layerType, String bbox) {
        this(name, layer, grid, dataSource, beginLevel, endLevel, layerType);
        this.bbox = bbox;
    }

    public TileLayerCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel, LAYER_TYPE layerType) {
        super(name + " - " + layerType);
        this.layer = layer;
        this.grid = grid;
        this.beginLevel = beginLevel;
        this.endLevel = endLevel;
        this.layerType = layerType;
        this.mongodbDataSource = dataSource;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        if (this.executor == null) {
            int taskNum = Runtime.getRuntime().availableProcessors();
            this.executor = new ThreadPoolExecutor(taskNum, taskNum, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        ProcessList.clearCache();
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        if (((DataServiceBean)dataService.getBean()).getGridUnit().equals((Object)Constants.GRID_UNIT.meter) && StringUtils.isBlank((CharSequence)this.bbox) && StringUtils.isNotBlank((CharSequence)((DataServiceBean)dataService.getBean()).getBbox())) {
            this.bbox = ((DataServiceBean)dataService.getBean()).getBbox();
        }
        this.buildStages();
        Client client = dataService.getClient();
        if (this.layerType == LAYER_TYPE.layer) {
            IStorageInfo storageInfo = this.createStorageInfo(dataService);
            dataService.addStorageInfo(storageInfo);
            try {
                client.getDataServiceManager().update((Object)dataService);
                this.logger.debug("\u66f4\u65b0\u74e6\u7247\u5b58\u50a8\u4fe1\u606f: {}", (Object)storageInfo.getStorageName());
            }
            catch (Exception e) {
                this.logger.error("\u66f4\u65b0\u74e6\u7247\u5b58\u50a8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    protected void buildStages() {
        int interval = this.beginLevel < 10 ? 2 : 4;
        ArrayList<String> filterList = new ArrayList<String>();
        Integer START_LEVEL = this.beginLevel;
        int start = START_LEVEL;
        while (start <= this.endLevel) {
            AbstractTaskStage stage;
            int end;
            int n = end = start + interval < this.endLevel ? start + interval : this.endLevel;
            if (this.endLevel - end <= 2) {
                end = this.endLevel;
            }
            if (end >= 10) {
                interval = 4;
            }
            boolean needProducer = true;
            String filter = this.getDataSetFilter(start, end);
            if (filterList.size() > 0 && Objects.equals(filter, filterList.get(filterList.size() - 1))) {
                needProducer = false;
            }
            filterList.add(filter);
            Integer filterLevel = null;
            if (needProducer) {
                int gridBeginLevel = start == 1 ? 0 : this.grid.getBeginLevel();
                start = start == 1 ? 0 : start;
                String produceStageName = "\u6784\u5efa" + gridBeginLevel + "\u81f3" + start + "\u7ea7\u522b\u6570\u636e\u670d\u52a1\u74e6\u7247\u6846\u67b6";
                LayerTilePrecutter cell = new LayerTilePrecutter(this.layer);
                cell.setMainLevel(Integer.valueOf(start));
                cell.setDown(end - start);
                ITileProducer producer = this.createProducer(start, end, (ITileLayoutPrecutter)cell);
                if (!cell.isSameFilter()) {
                    filterLevel = start;
                }
                stage = new TileProduceStage(produceStageName, producer, start, end);
                stage.setLogger(this.cutLogger);
                this.stages.add(stage);
            }
            String consumeStageName = "\u751f\u4ea7" + start + "\u81f3" + end + "\u7ea7\u522b\u6570\u636e\u670d\u52a1\uff08" + this.layerType + "\uff09\u74e6\u7247";
            ITileConsumer tileConsumer = this.createConsumer(start, end, filterLevel);
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
            start = end + 1;
        }
    }

    protected ITileConsumer createConsumer(int start, int end, Integer filterLevel) {
        LayerTileCutterCell cutterCell = new LayerTileCutterCell(this.layer, this.layerType);
        cutterCell.setDown(end - start);
        TileListCutHandler handlerStream = new TileListCutHandler(this.executor, 1, (ITileCutterCell)cutterCell, this.saver, new TileDataDocumentEncoder());
        handlerStream.setLogger(this.cutLogger);
        handlerStream.setResume(this.resume);
        TileLayoutScroll scroll = new TileLayoutScroll(start, this.grid, this.saver, filterLevel, true);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    protected ITileProducer createProducer(int start, int end, ITileLayoutPrecutter cell) {
        TileLayoutProducer tileProducer = new TileLayoutProducer(cell, this.saver, this.executor, start, end, this.grid, this.bbox, this.layer.getId(), new GridExtentDocumentEncoder());
        tileProducer.setLogPool(this.logPool);
        tileProducer.setLogger(this.cutLogger);
        tileProducer.init();
        return tileProducer;
    }

    private MongoTileSaver createTileSaver() {
        IStorageInfo storageInfo;
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        if (!this.resume && (storageInfo = dataService.getStorageInfo()) != null) {
            this.log("\u5220\u9664\u74e6\u7247, \u5f00\u59cb");
            storageInfo.drop();
            this.log("\u5220\u9664\u74e6\u7247, \u7ed3\u675f");
        }
        String storageName = dataService.getStorageName();
        if (this.layerType == LAYER_TYPE.label) {
            storageName = dataService.getLabelStorageName();
        }
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        tileSaver.setEnableSharding(true);
        tileSaver.init(this.cutLogger);
        return tileSaver;
    }

    @Override
    public void success() throws Exception {
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        Client client = dataService.getClient();
        IStorageInfo storageInfo = dataService.getStorageInfo();
        storageInfo.setCompleted(true);
        try {
            client.getDataServiceManager().update((Object)dataService);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IVectorServiceManager vectorServiceManager = client.getVectorServiceManager();
        List services = vectorServiceManager.list(new QueryFilter());
        services.stream().filter(service -> {
            for (ILayer layer : service.getLayerMap().values()) {
                for (ILayerLevel level : layer.getLevelMap().values()) {
                    if (!((String)dataService.getId()).equals(level.getDataSet().getDataService().getId())) continue;
                    return true;
                }
            }
            return false;
        }).forEach(service -> {
            ICacheable cacheable = service.getCacheInfo();
            if (cacheable != null && !this.resume) {
                try {
                    cacheable.drop(service.getId(), null);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
        super.success();
    }

    private String getDataSetFilter(Integer beginLevel, Integer endLevel) {
        String filterStr;
        Map levelMap = this.layer.getLevelMap();
        for (int i = beginLevel.intValue(); i <= endLevel; ++i) {
            ILayerLevel layerLevel = (ILayerLevel)levelMap.get(i);
            if (levelMap.get(i) == null) {
                return null;
            }
            if (layerLevel.isVirtual().booleanValue()) continue;
            filterStr = layerLevel.getFilterExpression();
            if (filterStr == null) {
                return null;
            }
            if (!"".equalsIgnoreCase(filterStr)) continue;
            return null;
        }
        ArrayList<String> filters = new ArrayList<String>();
        for (int i = beginLevel.intValue(); i <= endLevel; ++i) {
            if (levelMap.get(i) == null) continue;
            filterStr = ((ILayerLevel)levelMap.get(i)).getFilterExpression();
            filters.add(filterStr);
        }
        if (!filters.isEmpty()) {
            return StringUtils.join(filters, (String)" or ");
        }
        return null;
    }

    private IStorageInfo createStorageInfo(IDataService dataService) {
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(this.mongodbDataSource.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(this.endLevel);
        storageInfoBean.setStorageName(dataService.getStorageName());
        if (this.layer.getLabel() != null && this.layer.getLabel().getType() != Constants.LABEL_TYPE.point) {
            storageInfoBean.setLabelStorageName(dataService.getLabelStorageName());
        }
        storageInfoBean.setCompleted(false);
        return new StorageInfoShell(dataService.getClient(), storageInfoBean);
    }
}

