/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.task.task;

import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.LayerLabelTileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.layout.ITileLayoutPrecutter;
import com.northpool.gis.vector_cut.screenloction.cell.process.ProcessList;
import com.northpool.gis.vector_cut.screenloction.enums.LAYER_TYPE;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.DataServiceBean;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import com.northpool.spatial.grid.Constants;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.VectorCutMongoConsumer;
import com.northpool.tiledispatch.consumer.handler.TileListCutLabelHandler;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.GridExtentDocumentEncoder;
import com.northpool.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.northpool.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.northpool.tiledispatch.executor.DoubleQueueExecutor;
import com.northpool.tiledispatch.producer.ITileProducer;
import com.northpool.tiledispatch.producer.TileLayoutProducer;
import com.northpool.tiledispatch.task.task.TileLayerCutTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileLayerLabelCutTask
extends TileLayerCutTask {
    Logger logger = LoggerFactory.getLogger(TileLayerLabelCutTask.class);
    MongoTileSaver labelSaver;

    public TileLayerLabelCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel, LAYER_TYPE layerType) {
        super(name, layer, grid, dataSource, beginLevel, endLevel, layerType);
    }

    public TileLayerLabelCutTask(String name, ILayer layer, IGridSystem grid, MongodbDataSource dataSource, Integer beginLevel, Integer endLevel, LAYER_TYPE layerType, String bbox) {
        super(name, layer, grid, dataSource, beginLevel, endLevel, layerType, bbox);
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.createTileSaver();
        if (this.executor == null) {
            int taskNum = Runtime.getRuntime().availableProcessors();
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        if (((DataServiceBean)dataService.getBean()).getGridUnit().equals((Object)Constants.GRID_UNIT.meter) && StringUtils.isBlank((CharSequence)this.bbox) && StringUtils.isNotBlank((CharSequence)((DataServiceBean)dataService.getBean()).getBbox())) {
            this.bbox = ((DataServiceBean)dataService.getBean()).getBbox();
        }
        this.buildStages();
        Client client = dataService.getClient();
        IStorageInfo storageInfo = this.createStorageInfo(dataService);
        dataService.addStorageInfo(storageInfo);
        try {
            client.getDataServiceManager().update((Object)dataService);
            this.logger.debug("\u66f4\u65b0\u74e6\u7247\u5b58\u50a8\u4fe1\u606f: {}", (Object)storageInfo.getStorageName());
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u74e6\u7247\u5b58\u50a8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public ITileConsumer createConsumer(int start, int end, Integer filterLevel) {
        LayerLabelTileCutterCell cutterCell = new LayerLabelTileCutterCell(this.layer, this.layerType);
        cutterCell.setDown(end - start);
        TileListCutLabelHandler handlerStream = new TileListCutLabelHandler(this.executor, 1, (ITileCutterCell)cutterCell, this.saver, this.labelSaver, new TileDataDocumentEncoder(), new TileDataDocumentEncoder());
        handlerStream.setResume(this.resume);
        TileLayoutScroll scroll = new TileLayoutScroll(start, this.grid, this.saver, filterLevel, true);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    @Override
    public ITileProducer createProducer(int start, int end, ITileLayoutPrecutter cell) {
        TileLayoutProducer tileProducer = new TileLayoutProducer(cell, this.saver, this.executor, start, end, this.grid, this.bbox, this.layer.getId(), new GridExtentDocumentEncoder());
        tileProducer.setLogPool(this.logPool);
        tileProducer.setLogger(this.cutLogger);
        tileProducer.init();
        return tileProducer;
    }

    private void createTileSaver() {
        IStorageInfo storageInfo;
        IDataService dataService = ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
        if (!this.resume && (storageInfo = dataService.getStorageInfo()) != null) {
            storageInfo.drop();
        }
        String storageName = dataService.getStorageName();
        String labelStorageName = dataService.getLabelStorageName();
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        MongoTileSaver labelTileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), labelStorageName);
        tileSaver.setEnableSharding(true);
        tileSaver.init();
        labelTileSaver.setEnableSharding(true);
        labelTileSaver.init();
        this.saver = tileSaver;
        this.labelSaver = labelTileSaver;
    }

    private IStorageInfo createStorageInfo(IDataService dataService) {
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(this.mongodbDataSource.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(this.endLevel);
        storageInfoBean.setStorageName(dataService.getStorageName());
        storageInfoBean.setLabelStorageName(dataService.getLabelStorageName());
        storageInfoBean.setCompleted(false);
        return new StorageInfoShell(dataService.getClient(), storageInfoBean);
    }
}

