/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.saver;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.resources.MongodbDao;
import com.northpool.resources.MongodbFactory;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.manager.task.log.ITaskLogger;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.saver.ITileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoTileSaver
implements ITileSaver {
    private static Logger LOG = LoggerFactory.getLogger(MongoTileSaver.class);
    private static int INITIALIZE_TIMEOUT_SECONDs = 60;
    public static String lName = "flevel";
    public static String rName = "fx";
    public static String cName = "fy";
    public static String fkey = "fkey";
    public static String zipName = "fziptype";
    public static String fstatis = "fstatis";
    public static String fvectorName = "fdata1";
    public static String futfName = "fdata2";
    public static String isLayout = "fisLayout";
    public static final String layers = "flayers";
    public static final String filterLevel = "ffilterLevel";
    public static String endTime = "_et__";
    public static String beginTime = "_bt__";
    public static String zipType = "snappy";
    protected boolean init = false;
    String uri;
    String ip;
    int port;
    String namespace;
    String storageTableName;
    String userName;
    String password;
    MongodbFactory factory;
    MongodbDao dao;
    boolean enableSharding = false;

    public MongoTileSaver(String uri, String collectionName) {
        this.storageTableName = collectionName;
        this.uri = uri;
    }

    public void setEnableSharding(boolean flag) {
        this.enableSharding = flag;
    }

    @Override
    public void init(ITaskLogger logger) {
        if (this.init) {
            return;
        }
        MongodbDataSource mongodbDataSource = new MongodbDataSource(this.getUri());
        this.factory = mongodbDataSource.factory();
        if (logger != null) {
            logger.log("\u5224\u65ad\u662f\u5426\u5b58\u5728 collection: " + this.storageTableName);
        }
        boolean isExist = this.factory.collectionExist(this.storageTableName);
        this.dao = this.factory.getDao(this.storageTableName);
        if (!isExist) {
            if (logger != null) {
                logger.log("\u521b\u5efa collection: " + this.storageTableName);
            }
            LOG.info("\u521b\u5efa\u74e6\u7247\u96c6\uff1a" + this.storageTableName);
            this.factory.createCollection(this.storageTableName, new CreateCollectionOptions());
            this.dao.createIndex(new String[]{lName});
            this.dao.createIndex(new String[]{"flevel", "fx", "fy"});
            if (this.enableSharding && GlobalTileSettings.ENABLE_MONGO_SHARDING.booleanValue()) {
                try {
                    this.factory.setDBSharding();
                }
                catch (Exception ex) {
                    LOG.error("\u6570\u636e\u5e93\u5f00\u542f\u5206\u7247\u5931\u8d25", (Throwable)ex);
                }
                LOG.info("\u6307\u5b9a\u96c6\u5408{}\u7684\u5206\u7247\u5b57\u6bb5: {}", (Object)this.storageTableName, (Object)"fx");
                try {
                    this.factory.shardCollectionHashed(this.storageTableName, "fx");
                }
                catch (Exception ex) {
                    LOG.error("\u6307\u5b9a\u5206\u7247\u952e\u5931\u8d25", (Throwable)ex);
                }
            }
        }
        if (GlobalTileSettings.MG_WRITECONCERN_DEFAULT) {
            this.dao.setDefaultWriteMode(null);
        }
        this.init = true;
    }

    @Override
    public synchronized void init() {
        if (this.init) {
            return;
        }
        CompletableFuture<Void> promise = CompletableFuture.runAsync(() -> this.init(null));
        try {
            promise.exceptionally(ex -> {
                throw new RuntimeException("\u521d\u59cb\u5316mongo\u74e6\u7247\u96c6" + this.storageTableName + "\u65f6\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)ex);
            });
            promise.get(INITIALIZE_TIMEOUT_SECONDs, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316mongo\u74e6\u7247\u96c6" + this.storageTableName + "\u8d85\u65f6\uff0c\u5efa\u8bae\u68c0\u67e5mongodb\u6570\u636e\u5e93\u914d\u7f6e\u3002", e);
        }
    }

    @Override
    public <T> void save(List<T> data, IDocumentEncoder<T> encoder) {
        if (data == null || data.isEmpty()) {
            return;
        }
        List<Document> documents = this.getDocuments(data, encoder, null);
        this.dao.insert(documents);
    }

    @Override
    public <T> void saveItem(T data, IDocumentEncoder<T> encoder) {
        if (data == null) {
            return;
        }
        List<Document> documents = encoder.encode(data);
        if (documents == null || documents.isEmpty()) {
            return;
        }
        this.dao.insert(documents);
    }

    private <T> List<Document> getDocuments(List<T> data, IDocumentEncoder<T> encoder, Long beginTime) {
        return data.stream().flatMap(item -> {
            List<Document> list = null;
            list = beginTime != null ? encoder.encode(item, beginTime) : encoder.encode(item);
            if (list == null) {
                return null;
            }
            return list.stream();
        }).filter(doc -> doc != null).collect(Collectors.toList());
    }

    @Override
    public void setEndTime(List<GridExtent> extents, long time) {
        if (extents == null || extents.isEmpty()) {
            return;
        }
        List writeModelList = extents.stream().map(extent -> {
            Document data = new Document();
            data.put(rName, (Object)extent.getX());
            data.put(cName, (Object)extent.getY());
            data.put(lName, (Object)extent.getLevel());
            Document exists = new Document("$exists", (Object)false);
            data.put(endTime, (Object)exists);
            Document exists1 = new Document("$exists", (Object)false);
            data.put(isLayout, (Object)exists1);
            ArrayList<Document> btFilters = new ArrayList<Document>();
            btFilters.add(new Document(beginTime, (Object)new Document("$exists", (Object)false)));
            btFilters.add(new Document(beginTime, (Object)new Document("$lt", (Object)time)));
            data.put("$or", btFilters);
            BasicDBObject endTimeObjInc = new BasicDBObject().append("$inc", (Object)new BasicDBObject().append(endTime, (Object)time));
            return new UpdateManyModel((Bson)data, (Bson)endTimeObjInc);
        }).collect(Collectors.toList());
        this.dao.batchUpdate(writeModelList);
    }

    @Override
    public void remove(List<GridExtent> extents) {
        if (extents == null || extents.isEmpty()) {
            return;
        }
        List writeModelList = extents.stream().map(extent -> {
            Document data = new Document();
            data.put(rName, (Object)extent.getX());
            data.put(cName, (Object)extent.getY());
            data.put(lName, (Object)extent.getLevel());
            Document exists1 = new Document("$exists", (Object)false);
            data.put(isLayout, (Object)exists1);
            return new DeleteOneModel((Bson)data);
        }).collect(Collectors.toList());
        this.dao.batchUpdate(writeModelList);
    }

    @Override
    public <T> void updateEndTimeAndSave(List<T> data, long time, IDocumentEncoder<T> encoder) {
        if (data == null || data.isEmpty()) {
            return;
        }
        ArrayList writeModelList = new ArrayList();
        List<Document> documents = this.getDocuments(data, encoder, time);
        List insertOneModels = documents.stream().map(document -> new InsertOneModel(document)).collect(Collectors.toList());
        writeModelList.addAll(insertOneModels);
        this.dao.batchUpdate(writeModelList);
    }

    @Override
    public void setBeginTime(List<GridExtent> extents, long time) {
        List writeModelList = extents.stream().map(extent -> {
            Document data = new Document();
            data.put(rName, (Object)extent.getX());
            data.put(cName, (Object)extent.getY());
            data.put(lName, (Object)extent.getLevel());
            Document exists = new Document("$exists", (Object)false);
            data.put(endTime, (Object)exists);
            Document exists1 = new Document("$exists", (Object)false);
            data.put(isLayout, (Object)exists1);
            BasicDBObject beginTimeObjInc = new BasicDBObject().append("$inc", (Object)new BasicDBObject().append(beginTime, (Object)time));
            return new UpdateManyModel((Bson)data, (Bson)beginTimeObjInc);
        }).collect(Collectors.toList());
        this.dao.batchUpdate(writeModelList);
    }

    private <T> void saveLayout(List<T> data) {
        List documents = data.stream().map(item -> {
            Document doc = new Document();
            GridExtent extent = null;
            if (item instanceof GridExtent) {
                extent = (GridExtent)item;
            } else {
                TileLayout layout = (TileLayout)item;
                extent = layout.getExtent();
                doc.put(layers, (Object)layout.getExtraFilter());
                if (layout.getFilterLevel() != null) {
                    doc.put(filterLevel, (Object)layout.getFilterLevel());
                }
            }
            doc.put(rName, (Object)extent.getX());
            doc.put(cName, (Object)extent.getY());
            doc.put(lName, (Object)extent.getLevel());
            doc.put(isLayout, (Object)1);
            return doc;
        }).collect(Collectors.toList());
        this.dao.insert(documents);
    }

    @Override
    public Map<String, byte[]> getTiles(List<GridExtent> extents, Long time) {
        ArrayList<byte[]> list;
        BasicDBObject queryCondition = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        extents.stream().forEach(extent -> {
            Document doc = new Document();
            doc.put(rName, (Object)extent.getX());
            doc.put(cName, (Object)extent.getY());
            doc.put(lName, (Object)extent.getLevel());
            doc.put(isLayout, (Object)new Document("$exists", (Object)false));
            doc.put(endTime, (Object)new Document("$exists", (Object)false));
            if (time != null) {
                doc.put(endTime, (Object)time);
            }
            values.add((Object)doc);
        });
        Document fields = new Document();
        fields.put(lName, (Object)1);
        fields.put(rName, (Object)1);
        fields.put(cName, (Object)1);
        fields.put(fvectorName, (Object)1);
        queryCondition.put((Object)"$or", (Object)values);
        MongoCursor fi = this.dao.find((Bson)queryCondition);
        HashMap map = new HashMap();
        while (fi.hasNext()) {
            Document doc = (Document)fi.next();
            String key = doc.get((Object)lName) + "_" + doc.get((Object)rName) + "_" + doc.get((Object)cName);
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(((Binary)doc.get((Object)fvectorName)).getData());
                continue;
            }
            list = new ArrayList<byte[]>();
            list.add(((Binary)doc.get((Object)fvectorName)).getData());
            map.put(key, list);
        }
        Iterator iterator = map.keySet().iterator();
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        list = null;
        byte[] item = null;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            list = (ArrayList<byte[]>)map.get(key);
            int size = list.size();
            byte[] content = null;
            if (size > 1) {
                int length = list.stream().collect(Collectors.summingInt(listItem -> ((byte[])listItem).length));
                content = new byte[length];
                int pos = 0;
                for (int i = 0; i < size; ++i) {
                    item = (byte[])list.get(i);
                    System.arraycopy(item, 0, content, pos, item.length);
                    pos += item.length;
                }
            } else {
                content = (byte[])list.get(0);
            }
            result.put(key, content);
        }
        return result;
    }

    @Override
    public Map<String, byte[]> getTiles(Set<String> extentKeys, Long time) {
        List list;
        BasicDBObject query = new BasicDBObject();
        BasicDBList values = new BasicDBList();
        values.addAll(extentKeys);
        query.put((Object)fkey, (Object)new BasicDBObject("$in", (Object)values));
        BasicDBObject fields = new BasicDBObject();
        fields.put((Object)fvectorName, (Object)1);
        fields.put((Object)fkey, (Object)1);
        MongoCursor fi = this.dao.find((Bson)query, (Bson)fields);
        HashMap map = new HashMap();
        while (fi.hasNext()) {
            Document doc = (Document)fi.next();
            String key = doc.getString((Object)fkey);
            if (map.containsKey(key)) {
                ((List)map.get(key)).add(((Binary)doc.get((Object)fvectorName)).getData());
                continue;
            }
            list = new ArrayList<byte[]>();
            list.add(((Binary)doc.get((Object)fvectorName)).getData());
            map.put(key, list);
        }
        Iterator iterator = map.keySet().iterator();
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        list = null;
        byte[] item = null;
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            list = (List)map.get(key);
            int size = list.size();
            byte[] content = null;
            if (size > 1) {
                int length = list.stream().collect(Collectors.summingInt(listItem -> ((byte[])listItem).length));
                content = new byte[length];
                int pos = 0;
                for (int i = 0; i < size; ++i) {
                    item = (byte[])list.get(i);
                    System.arraycopy(item, 0, content, pos, item.length);
                    pos += item.length;
                }
            } else {
                content = (byte[])list.get(0);
            }
            result.put(key, content);
        }
        return result;
    }

    @Override
    public void updateTiles(Map<String, byte[]> tiles) {
        if (tiles == null || tiles.isEmpty()) {
            return;
        }
        ArrayList<UpdateOneModel> writeModelList = new ArrayList<UpdateOneModel>();
        for (String key : tiles.keySet()) {
            byte[] value = tiles.get(key);
            Document data = new Document();
            data.put(fkey, (Object)key);
            UpdateOneModel updateOneModel = new UpdateOneModel((Bson)data, (Bson)new BasicDBObject().append("$set", (Object)new BasicDBObject().append(fvectorName, (Object)new Binary(value))));
            writeModelList.add(updateOneModel);
        }
        this.dao.batchUpdate(writeModelList);
    }

    public Boolean hasRecord(GridExtent extent, Integer filterLevel, boolean isLayout) {
        return this.hasRecord(extent, filterLevel, isLayout, false, null);
    }

    @Override
    public boolean hasRecord(GridExtent extent) {
        return this.hasRecord(extent, null, false, true, null);
    }

    @Override
    public boolean hasRecord(GridExtent extent, Long beginTime) {
        return this.hasRecord(extent, null, false, true, beginTime);
    }

    @Override
    public void removeAndUpdateEndTime(GridExtent extent, Long timestamp, Long nextTime) {
        if (extent == null) {
            return;
        }
        ArrayList<Object> writeModelList = new ArrayList<Object>();
        Document removeFilter = new Document();
        removeFilter.put(rName, (Object)extent.getX());
        removeFilter.put(cName, (Object)extent.getY());
        removeFilter.put(lName, (Object)extent.getLevel());
        removeFilter.put(beginTime, (Object)timestamp);
        Document exists = new Document("$exists", (Object)false);
        removeFilter.put(isLayout, (Object)exists);
        DeleteManyModel deleteManyModel = new DeleteManyModel((Bson)removeFilter);
        Document data = new Document();
        data.put(rName, (Object)extent.getX());
        data.put(cName, (Object)extent.getY());
        data.put(lName, (Object)extent.getLevel());
        data.put(endTime, (Object)timestamp);
        Document exists1 = new Document("$exists", (Object)false);
        data.put(isLayout, (Object)exists1);
        BasicDBObject endTimeObjInc = null;
        endTimeObjInc = nextTime != null ? new BasicDBObject().append("$set", (Object)new BasicDBObject().append(endTime, (Object)nextTime)) : new BasicDBObject().append("$unset", (Object)new BasicDBObject().append(endTime, null));
        UpdateManyModel updateManyModel = new UpdateManyModel((Bson)data, (Bson)endTimeObjInc);
        writeModelList.add(deleteManyModel);
        writeModelList.add(updateManyModel);
        this.dao.batchUpdate(writeModelList);
    }

    private Boolean hasRecord(GridExtent extent, Integer filterLevel, boolean isLayout, boolean isTileData, Long beginTime) {
        Document data = new Document();
        data.put(rName, (Object)extent.getX());
        data.put(cName, (Object)extent.getY());
        data.put(lName, (Object)extent.getLevel());
        if (isLayout) {
            data.put(MongoTileSaver.isLayout, (Object)1);
        } else if (isTileData) {
            data.put(MongoTileSaver.isLayout, (Object)new Document("$exists", (Object)false));
        }
        if (beginTime != null) {
            data.put(MongoTileSaver.beginTime, (Object)beginTime);
        }
        if (filterLevel != null) {
            data.put(filterLevel, (Object)filterLevel);
        }
        Document info = new Document();
        info.put("_id", (Object)1);
        Document o = this.dao.findone((Bson)data, (Bson)info);
        if (o == null) {
            return false;
        }
        return true;
    }

    public void remove(GridExtent extent, boolean isLayout) {
        Document data = new Document();
        data.put(rName, (Object)extent.getX());
        data.put(cName, (Object)extent.getY());
        data.put(lName, (Object)extent.getLevel());
        if (isLayout) {
            data.put(MongoTileSaver.isLayout, (Object)1);
        }
        this.dao.deleteone((Bson)data);
    }

    public MongodbDao getMongoDao() {
        return this.dao;
    }

    public String getUri() {
        if (StringUtils.isEmpty((CharSequence)this.uri)) {
            this.uri = this.ip + ':' + this.port + '/' + this.namespace;
            if (StringUtils.isNotEmpty((CharSequence)this.userName)) {
                this.uri = this.userName + ':' + this.password + '@' + this.uri;
            }
            this.uri = "mongodb://" + this.uri;
        }
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

