/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.task.task.update;

import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.LayerTileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.process.ProcessList;
import com.northpool.gis.vector_cut.screenloction.enums.LAYER_TYPE;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.data_service.IDataService;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.layer.ILayer;
import com.northpool.service.config.vector_service.layer.ILayerLevel;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.manager.vector_service.IVectorServiceManager;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.VectorCutMongoConsumer;
import com.northpool.tiledispatch.consumer.handler.update.VectorLayerUpdateHandler;
import com.northpool.tiledispatch.consumer.saver.ITileSaver;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import com.northpool.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.northpool.tiledispatch.consumer.scroll.ITileScroll;
import com.northpool.tiledispatch.consumer.scroll.WktArrayScroll;
import com.northpool.tiledispatch.executor.DoubleQueueExecutor;
import com.northpool.tiledispatch.task.stage.TileConsumeStage;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractUpdateTask;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TileLayerUpdateTask
extends AbstractUpdateTask {
    ILayer layer;
    MongodbDataSource mongodbDataSource;
    MongoTileSaver saver;
    LAYER_TYPE layerType = LAYER_TYPE.all;
    public static final int CUT_INTERVAL = 4;
    List<String> updateRegions;
    long timestamp;
    IDataService dataService;

    public TileLayerUpdateTask(String name, ILayer layer, IGridSystem grid, LAYER_TYPE layerType, List<String> updateRegions, Long timestamp) {
        super(name);
        this.layer = layer;
        this.grid = grid;
        this.layerType = layerType;
        this.updateRegions = updateRegions;
        this.dataService = this.getDataService();
        IStorageInfo storageInfo = this.dataService.getStorageInfo();
        if (storageInfo == null) {
            throw new RuntimeException("\u672a\u9884\u70ed\u74e6\u7247\u7684\u670d\u52a1\u65e0\u6cd5\u66f4\u65b0");
        }
        this.mongodbDataSource = (MongodbDataSource)storageInfo.getDataSource().getBean();
        this.beginLevel = storageInfo.getStartLevel();
        this.endLevel = storageInfo.getEndLevel();
        this.timestamp = timestamp == null ? new Date().getTime() : timestamp.longValue();
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        this.saver = this.createTileSaver();
        if (this.executor == null) {
            int taskNum = Runtime.getRuntime().availableProcessors();
            this.executor = new DoubleQueueExecutor(taskNum);
        }
        ProcessList.clearCache();
        this.buildStages(LAYER_TYPE.layer);
    }

    private void buildStages(LAYER_TYPE layerType) {
        int interval = this.beginLevel < 10 ? 2 : 4;
        int end = this.beginLevel;
        ArrayList filterList = new ArrayList();
        TileConsumeStage stage = null;
        int start = this.beginLevel;
        while (start <= this.endLevel) {
            int n = end = start + interval < this.endLevel ? start + interval : this.endLevel;
            if (this.endLevel - end <= 2) {
                end = this.endLevel;
            }
            int startLevel = start;
            if (end >= 10) {
                interval = 4;
            }
            Integer filterLevel = null;
            ITileConsumer tileConsumer = this.createConsumer(start, end, filterLevel);
            String consumeStageName = "\u751f\u4ea7" + start + "\u81f3" + end + "\u7ea7\u522b\u74e6\u7247";
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
            start = end + 1;
        }
    }

    private ITileConsumer createConsumer(int start, int end, Integer filterLevel) {
        LayerTileCutterCell cutterCell = new LayerTileCutterCell(this.layer, this.layerType);
        cutterCell.setDown(end - start);
        VectorLayerUpdateHandler handlerStream = new VectorLayerUpdateHandler(this.executor, 1, (ITileCutterCell)cutterCell, (ITileSaver)this.saver, this.timestamp, (IDocumentEncoder)new TileDataDocumentEncoder());
        handlerStream.setResume(this.resume);
        ITileScroll scroll = this.getTileScroll(start);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private ITileScroll getTileScroll(int start) {
        HashMap<String, List<String>> updatesMap = new HashMap<String, List<String>>();
        updatesMap.put(this.layer.getId(), this.updateRegions);
        return new WktArrayScroll(updatesMap, this.grid, start);
    }

    private MongoTileSaver createTileSaver() {
        String storageName = this.dataService.getStorageName();
        if (this.layerType == LAYER_TYPE.label) {
            storageName = this.dataService.getLabelStorageName();
        }
        MongoTileSaver tileSaver = new MongoTileSaver(this.mongodbDataSource.getUri(), storageName);
        tileSaver.init();
        return tileSaver;
    }

    private IDataService getDataService() {
        return ((ILayerLevel)this.layer.getLevelMap().values().iterator().next()).getDataSet().getDataService();
    }

    @Override
    public void success() throws Exception {
        Client client = this.dataService.getClient();
        IVectorServiceManager vectorServiceManager = client.getVectorServiceManager();
        List services = vectorServiceManager.list(new QueryFilter());
        services.stream().filter(service -> {
            for (ILayer layer : service.getLayerMap().values()) {
                for (ILayerLevel level : layer.getLevelMap().values()) {
                    if (!((String)this.dataService.getId()).equals(level.getDataSet().getDataService().getId())) continue;
                    return true;
                }
            }
            return false;
        }).forEach(service -> {
            ICacheable cacheable = service.getCacheInfo();
            if (cacheable != null && !this.resume) {
                try {
                    cacheable.drop(service.getId(), null);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
        super.success();
    }
}

