/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.scroll;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.scroll.TileLayoutScroll;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtfgridMongoDataScroll<T>
extends TileLayoutScroll {
    protected Logger logger = LoggerFactory.getLogger(UtfgridMongoDataScroll.class);
    private MongoCursor iterator;

    public UtfgridMongoDataScroll(int level, IGridSystem grid, MongoTileSaver tileSaver, Integer filterLevel, boolean loged) {
        super(level, grid, tileSaver, filterLevel, loged);
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        this.count = this.getCount(this.level);
        this.iterator = this.getIterator(this.level);
        this.init = true;
    }

    @Override
    public Long getCount() {
        return this.count;
    }

    @Override
    public TileLayout next() {
        Object obj = this.iterator.next();
        String tileKeyStr = UtfgridMongoDataScroll.getKey((Document)obj);
        String tile = tileKeyStr + "_" + this.level;
        return this.getGridExtentByTileKey(tile);
    }

    @Override
    public synchronized boolean hasNext() {
        return this.iterator.hasNext();
    }

    private TileLayout getGridExtentByTileKey(String tileKey) {
        String[] key = tileKey.split("_");
        GridExtent gridExtent = this.grid.getGridExtent(Integer.parseInt(key[2]), Integer.parseInt(key[0]), Integer.parseInt(key[1]));
        return new TileLayout(gridExtent, null);
    }

    public MongoCursor getIterator(int level) {
        Document data = new Document();
        data.put(MongoTileSaver.lName, (Object)level);
        data.put(MongoTileSaver.isLayout, (Object)1);
        Document fields = new Document();
        fields.put(MongoTileSaver.lName, (Object)1);
        fields.put(MongoTileSaver.rName, (Object)1);
        fields.put(MongoTileSaver.cName, (Object)1);
        FindIterable fi = this.tileSaver.getMongoDao().findCollection((Bson)data, (Bson)fields);
        return fi.iterator();
    }

    @Override
    public Long getCount(int level) {
        Document data = new Document();
        data.put(MongoTileSaver.lName, (Object)level);
        data.put(MongoTileSaver.isLayout, (Object)1);
        return this.tileSaver.getMongoDao().count((Bson)data);
    }

    @Override
    public void release() {
        super.release();
        try {
            if (null != this.iterator) {
                this.iterator.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

