/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.handler;

import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.dataholder.IMetricsHolder;
import com.northpool.gis.vector_cut.screenloction.dataholder.bucket.BucketHolder;
import com.northpool.gis.vector_cut.screenloction.dataholder.metrics.ObjectArrayMetricsHolder;
import com.northpool.tiledispatch.consumer.handler.abstractclass.AbstractTileHandlerStream;
import com.northpool.tiledispatch.consumer.handler.error.ITileErrorHandler;
import com.northpool.tiledispatch.consumer.saver.ITileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.IDocumentEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class FeatureAreaHandler
extends AbstractTileHandlerStream<Object[]> {
    Map<Long, Map<String, BucketHolder>> bucketsMap;
    protected ITileCutterCell<Object[], Map<String, ObjectArrayMetricsHolder>> cell;
    protected ITileSaver saver;
    protected IDocumentEncoder encoder;

    public FeatureAreaHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, IDocumentEncoder encoder) {
        super(executor, bufferSize);
        this.cell = cell;
        this.saver = saver;
        this.encoder = encoder;
        this.bucketsMap = new HashMap<Long, Map<String, BucketHolder>>();
    }

    public FeatureAreaHandler(ExecutorService executor, int bufferSize, ITileCutterCell cell, ITileSaver saver, ITileErrorHandler errorHandler, IDocumentEncoder encoder) {
        super(executor, bufferSize);
        this.cell = cell;
        this.saver = saver;
        this.errorHandler = errorHandler;
        this.encoder = encoder;
    }

    @Override
    public void init() {
        if (this.init) {
            return;
        }
        if (this.cell != null) {
            this.cell.init();
        }
        this.saver.init();
        this.init = true;
    }

    @Override
    public void flush() {
        if (this.bucketsMap.isEmpty()) {
            return;
        }
        HashMap extentGroupMap = new HashMap();
        Set<Long> threads = this.bucketsMap.keySet();
        Set<String> extentKeySet = null;
        for (Long thread : threads) {
            Map<String, BucketHolder> threadHolderMap = this.bucketsMap.get(thread);
            extentKeySet = threadHolderMap.keySet();
            for (String extentKey : extentKeySet) {
                if (extentGroupMap.get(extentKey) != null) {
                    ((List)extentGroupMap.get(extentKey)).add(threadHolderMap.get(extentKey));
                    continue;
                }
                ArrayList<BucketHolder> list = new ArrayList<BucketHolder>();
                list.add(threadHolderMap.get(extentKey));
                extentGroupMap.put(extentKey, list);
            }
        }
        ArrayList<Object[]> saveList = new ArrayList<Object[]>(extentGroupMap.size());
        Set allExtentKeys = extentGroupMap.keySet();
        List list = null;
        BucketHolder holder = null;
        for (String extentKey : allExtentKeys) {
            list = (List)extentGroupMap.get(extentKey);
            holder = list.size() > 1 ? BucketHolder.mergeBucketsList((List)list) : (BucketHolder)list.get(0);
            saveList.add(new Object[]{extentKey, holder});
        }
        this.saver.save(saveList, this.encoder);
    }

    @Override
    public void handle(Object[] feature) {
        if (this.executor != null) {
            this.executor.execute(() -> this.handleItem(feature));
        } else {
            this.handleItem(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleItem(Object[] item) {
        block7: {
            if (this.resume || this.cancel) {
                return;
            }
            if (this.error) {
                return;
            }
            Map data = null;
            try {
                data = (Map)this.cell.cut((Object)item, null);
                this.save(data);
            }
            catch (Throwable e) {
                if (this.errorHandler != null) {
                    this.errorHandler.handle(item);
                    break block7;
                }
                this.e = e;
                this.error = true;
            }
        }
    }

    private void save(Map<String, ObjectArrayMetricsHolder> data) {
        Map<String, BucketHolder> bucketHolderMap = this.bucketsMap.get(Thread.currentThread().getId());
        if (bucketHolderMap == null) {
            bucketHolderMap = new HashMap<String, BucketHolder>();
            this.bucketsMap.put(Thread.currentThread().getId(), bucketHolderMap);
        }
        Object extent = null;
        Object key = null;
        BucketHolder holder = null;
        Set<String> keySet = data.keySet();
        for (String extentKey : keySet) {
            if (bucketHolderMap.containsKey(extentKey)) {
                holder = bucketHolderMap.get(extentKey);
                BucketHolder.mergeBuckets((BucketHolder)holder, (IMetricsHolder)((IMetricsHolder)data.get(extentKey)));
                continue;
            }
            holder = BucketHolder.createBucket((IMetricsHolder)((IMetricsHolder)data.get(extentKey)));
            bucketHolderMap.put(extentKey, holder);
        }
    }

    @Override
    public void cancel() {
        this.cell.cancel();
        super.cancel();
    }
}

