/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.consumer.scroll;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.northpool.gis.vector_cut.screenloction.cell.layout.TileLayout;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.spatial.grid.ScanLine;
import com.northpool.spatial.grid.extent.GridExtent;
import com.northpool.tiledispatch.consumer.scroll.ITileScroll;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;

public class WktArrayScroll
implements ITileScroll {
    Map<String, List<String>> layerRegionWktMap;
    Map<String, TileLayout> layoutMap;
    Iterator<TileLayout> iterator;
    private int level;
    IGridSystem grid;

    public WktArrayScroll(Map<String, List<String>> extents, IGridSystem grid, int level) {
        this.layerRegionWktMap = extents;
        this.grid = grid;
        this.level = level;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public TileLayout next() {
        return this.iterator.next();
    }

    @Override
    public void init() {
        this.layoutMap = new HashMap<String, TileLayout>();
        Iterator<String> layerIterator = this.layerRegionWktMap.keySet().iterator();
        double[][] points = null;
        HashMap setMap = new HashMap();
        while (layerIterator.hasNext()) {
            String layerId = layerIterator.next();
            HashSet result = new HashSet();
            List<String> wktList = this.layerRegionWktMap.get(layerId);
            for (int i = 0; i < wktList.size(); ++i) {
                String wkt = wktList.get(i);
                try {
                    Geometry geom = new WKTReader().read(wkt);
                    points = ScanLine.create((Geometry)geom);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(wkt + "\u4e0d\u662f\u6807\u51c6\u7684WKT");
                }
                ScanLine scanLine = new ScanLine(Integer.valueOf(1), new Integer[]{this.level}, this.grid);
                scanLine.calculate(points);
                Set set = (Set)scanLine.getExtents().get(this.level);
                result.addAll(set);
            }
            setMap.put(layerId, result);
        }
        Iterator setKeyIterator = setMap.keySet().iterator();
        String firstSetKey = (String)setKeyIterator.next();
        Set firstSet = (Set)setMap.get(firstSetKey);
        Iterator keysIterator = firstSet.iterator();
        GridExtent extent = null;
        while (keysIterator.hasNext()) {
            String colrow = (String)keysIterator.next();
            int x = Integer.valueOf(colrow.split("_")[0]);
            int y = Integer.valueOf(colrow.split("_")[1]);
            extent = this.grid.getExtent(this.level, x, y);
            JSONObject filterObj = new JSONObject(1);
            filterObj.put(firstSetKey, (Object)"all");
            this.layoutMap.put(colrow, new TileLayout(extent, filterObj.toJSONString()));
        }
        if (this.layerRegionWktMap.size() > 1) {
            while (setKeyIterator.hasNext()) {
                String layerKey = (String)setKeyIterator.next();
                Set colrowSet = (Set)setMap.get(layerKey);
                for (String colrow : colrowSet) {
                    JSONObject obj;
                    if (this.layoutMap.containsKey(colrow)) {
                        TileLayout firstLayout = this.layoutMap.get(colrow);
                        String filter = firstLayout.getExtraFilter();
                        obj = JSON.parseObject((String)filter);
                        obj.put(layerKey, (Object)"all");
                        firstLayout.setExtraFilter(obj.toJSONString());
                        continue;
                    }
                    int x = Integer.valueOf(colrow.split("_")[0]);
                    int y = Integer.valueOf(colrow.split("_")[1]);
                    extent = this.grid.getExtent(this.level, x, y);
                    obj = new JSONObject(1);
                    obj.put(layerKey, (Object)"all");
                    TileLayout newlayout = new TileLayout(extent, obj.toJSONString());
                    this.layoutMap.put(colrow, newlayout);
                }
            }
        }
        this.iterator = this.layoutMap.values().iterator();
    }

    @Override
    public Long getCount() {
        return this.layoutMap.size();
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void release() {
    }
}

