/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.tiledispatch.task.v4;

import com.northpool.commons.conf.GlobalTileSettings;
import com.northpool.diagnose.Log4jUtil;
import com.northpool.gis.vector_cut.screenloction.cell.ITileCutterCell;
import com.northpool.gis.vector_cut.screenloction.cell.process.ProcessList;
import com.northpool.gis.vector_cut.screenloction.cellv4.MapTileBuilderUnit;
import com.northpool.gis.vector_cut.screenloction.cellv4.TileOptimizer;
import com.northpool.resources.datasource.MongodbDataSource;
import com.northpool.service.client.Client;
import com.northpool.service.config.vector_service.ICacheable;
import com.northpool.service.config.vector_service.IVectorService;
import com.northpool.service.config.vector_service.storage.IStorageInfo;
import com.northpool.service.config.vector_service.storage.StorageInfoBean;
import com.northpool.service.config.vector_service.storage.StorageInfoShell;
import com.northpool.spatial.grid.IGridSystem;
import com.northpool.tiledispatch.consumer.ITileConsumer;
import com.northpool.tiledispatch.consumer.VectorCutMongoConsumer;
import com.northpool.tiledispatch.consumer.handler.TileListCutHandler;
import com.northpool.tiledispatch.consumer.saver.MongoTileSaver;
import com.northpool.tiledispatch.consumer.saver.endocer.TileDataDocumentEncoder;
import com.northpool.tiledispatch.consumer.scroll.ITileScroll;
import com.northpool.tiledispatch.consumer.scroll.TileLayoutScroll;
import com.northpool.tiledispatch.executor.DoubleQueueExecutor;
import com.northpool.tiledispatch.task.TileDispatchTaskManager;
import com.northpool.tiledispatch.task.stage.TileConsumeStage;
import com.northpool.tiledispatch.task.task.abstractclass.AbstractTileDispatchTask;
import com.northpool.tiledispatch.task.v4.MapPrecutSchema;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapCutTaskV4
extends AbstractTileDispatchTask {
    private static Logger logger = LoggerFactory.getLogger(MapCutTaskV4.class);
    private IVectorService mapService;
    private boolean withStyleFilter = false;
    private boolean enableBatchLevel = false;
    private String mapName = null;
    private IGridSystem grid = null;
    private String bbox = null;
    private ExecutorService cutThreadPool = null;
    private MapPrecutSchema cutSchema = null;
    private MongoTileSaver tileSaver = null;
    private MongodbDataSource tileMogoDS = null;
    private TileOptimizer tileOptimizer = null;
    public String Force_Level_Stages = null;

    public MapCutTaskV4(IVectorService vectorService) {
        super(vectorService.getId() + "-preheat");
        this.mapService = vectorService;
        this.mapName = vectorService.getId();
        this.grid = vectorService.getGridTree();
        this.bbox = vectorService.getBbox();
    }

    public MapCutTaskV4(IVectorService vectorService, String bbox) {
        this(vectorService);
        this.bbox = bbox;
    }

    public void setPrehotOptions(MongodbDataSource tileMogoDS, int startLevel, int endLevel, boolean withStyle) {
        this.beginLevel = startLevel;
        this.endLevel = endLevel;
        this.tileMogoDS = tileMogoDS;
        this.withStyleFilter = withStyle;
    }

    public void setEnableBatchLevel(boolean isOpen) {
        this.enableBatchLevel = isOpen;
    }

    @Override
    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        int nThreads = TileDispatchTaskManager.getPoolThreadCount();
        this.cutThreadPool = new DoubleQueueExecutor(nThreads);
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u521d\u59cb\u5316\u5730\u56fe\u9884\u70ed\u4efb\u52a1: {}, \u5c42\u7ea7\u8303\u56f4: {}~{}, \u7ebf\u7a0b\u6c60\u5927\u5c0f: {}", new Object[]{this.mapName, this.beginLevel, this.endLevel, nThreads});
        }
        this.creatTileDBSaver();
        this.buildTileOptimizer();
        this.buildTaskShema();
    }

    @Override
    public void success() throws Exception {
        IStorageInfo storageInfo = this.mapService.getStorageInfo();
        storageInfo.setCompleted(true);
        try {
            this.mapService.getClient().getVectorServiceManager().update((Object)this.mapService);
        }
        catch (Exception e) {
            logger.error("\u4fdd\u5b58\u74e6\u7247\u5143\u6570\u636e\u4fe1\u606f\u5230mongo\u4e1a\u52a1\u5e93\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        ICacheable cacheable = this.mapService.getCacheInfo();
        if (cacheable != null && !this.resume) {
            cacheable.drop(this.mapService.getId(), null);
        }
        super.success();
    }

    private void creatTileDBSaver() {
        IStorageInfo storageInfo = this.mapService.getStorageInfo();
        if (!this.resume) {
            try {
                if (storageInfo != null) {
                    storageInfo.drop();
                }
            }
            catch (Exception ex) {
                logger.error("\u5220\u9664\u65e7\u74e6\u7247\u51fa\u9519\uff1a" + ex.getMessage());
            }
        }
        MongodbDataSource tileMogo = this.tileMogoDS;
        String tileCollectionName = this.mapName;
        StorageInfoBean storageInfoBean = new StorageInfoBean();
        storageInfoBean.setDataSourceId(tileMogo.getId());
        storageInfoBean.setStartLevel(this.beginLevel);
        storageInfoBean.setEndLevel(this.endLevel);
        storageInfoBean.setStorageName(tileCollectionName);
        storageInfoBean.setCompleted(false);
        Client client = this.mapService.getClient();
        storageInfo = new StorageInfoShell(client, storageInfoBean);
        this.mapService.addStorageInfo(storageInfo);
        try {
            client.getVectorServiceManager().update((Object)this.mapService);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5730\u56fe\u670d\u52a1" + this.mapName + "\u66f4\u65b0\u4fdd\u5b58\u74e6\u7247\u5b58\u50a8\u5143\u6570\u636e\u5931\u8d25\uff01" + e.getMessage(), (Throwable)e);
        }
        this.tileSaver = new MongoTileSaver(tileMogo.getUri(), tileCollectionName);
        this.tileSaver.setEnableSharding(true);
        this.tileSaver.init();
    }

    private void buildTileOptimizer() {
        this.tileOptimizer = new TileOptimizer(this.tileSaver.getMongoDao());
        this.tileOptimizer.setEnableBatchLevel(this.enableBatchLevel);
    }

    private void buildTaskShema() {
        this.cutSchema = new MapPrecutSchema();
        this.cutSchema.prepare(this.mapService, this.bbox, this.beginLevel, this.endLevel);
        this.cutSchema.refineGrids(this.tileOptimizer, this.resume);
        this.cutSchema.analyzeFilters(this.tileOptimizer);
        this.stages = new ArrayList();
        TileConsumeStage stage = null;
        for (int i = this.beginLevel.intValue(); i <= this.endLevel; ++i) {
            int level = i;
            if (this.isResume() && this.isSkipLevel(level)) {
                logger.info("\u6062\u590d\u7684\u4efb\u52a1\u8df3\u8fc7\u5df2\u5b8c\u6210\u7684\u74e6\u7247\u5c42\u7ea7\uff1a" + level);
                continue;
            }
            int drillDownStep = this.calcDrillDownLevels(level);
            String consumeStageName = "\u751f\u4ea7" + level + "\u7ea7\u5730\u56fe\u74e6\u7247";
            if (drillDownStep > 0) {
                consumeStageName = String.format("\u751f\u4ea7%d~%d\u7ea7\u5730\u56fe\u74e6\u7247 ", level, level + drillDownStep);
                i += drillDownStep;
            }
            ITileConsumer tileConsumer = this.createConsumer(level, level + drillDownStep);
            stage = new TileConsumeStage(consumeStageName, tileConsumer);
            stage.setLogger(this.cutLogger);
            this.stages.add(stage);
        }
        logger.info("\u5df2\u5b8c\u6210\u74e6\u7247\u9884\u70ed\u4efb\u52a1\u89c4\u5212");
        if (Log4jUtil.isDiagnoseEnable()) {
            logger.info("\u74e6\u7247\u9884\u70ed\u533a\u6bb5\u4e2a\u6570\uff1a{}\uff0c\u5b50\u4efb\u52a1\u5217\u8868\u5982\u4e0b\uff1a\n {} ", (Object)this.stages.size(), (Object)StringUtils.join(this.stages.stream().map(sta -> sta.getName()).iterator(), (String)"\n "));
        }
    }

    private boolean isSkipLevel(int level) {
        if (this.enableBatchLevel) {
            return false;
        }
        boolean hasNextLevelTiles = this.tileOptimizer.hasTileAtLevel(level + 1);
        return this.isResume() && hasNextLevelTiles;
    }

    private int calcDrillDownLevels(int currentLevel) {
        if (!this.enableBatchLevel) {
            return 0;
        }
        int maxLevel = this.endLevel;
        if (currentLevel >= maxLevel) {
            return 0;
        }
        int step = 0;
        boolean isAllLevelSameFilter = this.tileOptimizer.isSameFilterAtLevels(currentLevel, maxLevel);
        if (isAllLevelSameFilter) {
            step = maxLevel - currentLevel;
            if (GlobalTileSettings.CUT_LEVEL_SPAN > 0) {
                step = Math.min(step, GlobalTileSettings.CUT_LEVEL_SPAN - 1);
            } else {
                int SPLIT_LEVEL = 12;
                if (currentLevel < 12) {
                    step = 1;
                } else if (currentLevel < 16) {
                    if (currentLevel + step > 16) {
                        step = 15 - currentLevel;
                    }
                } else if (currentLevel > 16) {
                    logger.error("\u9636\u6bb5\u5212\u5206\u4e0d\u5408\u7406\uff01");
                }
            }
        } else {
            boolean isnextLevelSameFilter = this.tileOptimizer.isSameFilterAtLevels(currentLevel, currentLevel + 1);
            if (isnextLevelSameFilter) {
                step = 1;
            }
        }
        if (step < 0) {
            step = 0;
        }
        return step;
    }

    private ITileConsumer createConsumer(int start, int end) {
        ITileScroll scroll = this.getTileScroll(start, end);
        MapTileBuilderUnit cutterCell = new MapTileBuilderUnit(this.mapService, this.cutThreadPool);
        cutterCell.setHasStyle(this.withStyleFilter);
        cutterCell.setMainLevel(Integer.valueOf(start));
        cutterCell.setDown(end - start);
        cutterCell.setOptimizer(this.tileOptimizer);
        TileListCutHandler handlerStream = new TileListCutHandler(this.executor, 1, (ITileCutterCell)cutterCell, this.tileSaver, new TileDataDocumentEncoder());
        handlerStream.setLogger(this.cutLogger);
        handlerStream.setResume(this.resume);
        VectorCutMongoConsumer tileConsumer = new VectorCutMongoConsumer(scroll, handlerStream);
        tileConsumer.setLogPool(this.logPool);
        tileConsumer.setLogger(this.cutLogger);
        tileConsumer.init();
        return tileConsumer;
    }

    private ITileScroll getTileScroll(int start, int end) {
        ITileScroll bboxScroll = this.cutSchema.getScroll(start);
        if (GlobalTileSettings.USE_MONGOTILE_ACCELERATE && start > this.beginLevel && start > 12 && bboxScroll.getCount() > 500000L) {
            return new TileLayoutScroll(start, this.grid, this.tileSaver, null, true);
        }
        return bboxScroll;
    }

    @Override
    public void release() {
        if (this.isReleased) {
            return;
        }
        if (null != this.cutThreadPool && !this.cutThreadPool.isShutdown()) {
            this.cutThreadPool.shutdown();
        }
        this.tileOptimizer.clearAll();
        this.cutSchema.release();
        ProcessList.clearCache();
        logger.info("\u4efb\u52a1\u7f13\u5b58\u5df2\u6e05\u7406");
        super.release();
    }
}

