

/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.arrow.vector.complex.impl;


import static org.apache.arrow.util.Preconditions.checkArgument;
import static org.apache.arrow.util.Preconditions.checkState;

import com.google.flatbuffers.FlatBufferBuilder;

import io.netty.buffer.*;

import org.apache.arrow.memory.*;
import org.apache.arrow.util.Preconditions;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.Types.*;
import org.apache.arrow.vector.types.pojo.*;
import org.apache.arrow.vector.types.pojo.ArrowType.*;
import org.apache.arrow.vector.types.*;
import org.apache.arrow.vector.*;
import org.apache.arrow.vector.holders.*;
import org.apache.arrow.vector.util.*;
import org.apache.arrow.vector.complex.*;
import org.apache.arrow.vector.complex.reader.*;
import org.apache.arrow.vector.complex.impl.*;
import org.apache.arrow.vector.complex.writer.*;
import org.apache.arrow.vector.complex.writer.BaseWriter.StructWriter;
import org.apache.arrow.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.arrow.vector.util.JsonStringArrayList;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZonedDateTime;



/*
 * This class is generated using freemarker and the ComplexCopier.java template.
 */
@SuppressWarnings("unused")
public class ComplexCopier {

  /**
   * Do a deep copy of the value in input into output
   * @param input field to read from
   * @param output field to write to
   */
  public static void copy(FieldReader input, FieldWriter output) {
    writeValue(input, output);
  }

  private static void writeValue(FieldReader reader, FieldWriter writer) {
    final MinorType mt = reader.getMinorType();

      switch (mt) {

      case LIST:
      case MAP:
      case FIXED_SIZE_LIST:
        if (reader.isSet()) {
          writer.startList();
          while (reader.next()) {
            writeValue(reader.reader(), getListWriterForReader(reader.reader(), writer));
          }
          writer.endList();
        }
        break;
      case STRUCT:
        if (reader.isSet()) {
          writer.start();
          for(String name : reader){
            FieldReader childReader = reader.reader(name);
            if(childReader.isSet()){
              writeValue(childReader, getStructWriterForReader(childReader, writer, name));
            }
          }
          writer.end();
        }
        break;


      case TINYINT:
        if (reader.isSet()) {
          NullableTinyIntHolder tinyIntHolder = new NullableTinyIntHolder();
          reader.read(tinyIntHolder);
          if (tinyIntHolder.isSet == 1) {
            writer.writeTinyInt(tinyIntHolder.value);
          }
        }
        break;



      case UINT1:
        if (reader.isSet()) {
          NullableUInt1Holder uInt1Holder = new NullableUInt1Holder();
          reader.read(uInt1Holder);
          if (uInt1Holder.isSet == 1) {
            writer.writeUInt1(uInt1Holder.value);
          }
        }
        break;



      case UINT2:
        if (reader.isSet()) {
          NullableUInt2Holder uInt2Holder = new NullableUInt2Holder();
          reader.read(uInt2Holder);
          if (uInt2Holder.isSet == 1) {
            writer.writeUInt2(uInt2Holder.value);
          }
        }
        break;



      case SMALLINT:
        if (reader.isSet()) {
          NullableSmallIntHolder smallIntHolder = new NullableSmallIntHolder();
          reader.read(smallIntHolder);
          if (smallIntHolder.isSet == 1) {
            writer.writeSmallInt(smallIntHolder.value);
          }
        }
        break;



      case INT:
        if (reader.isSet()) {
          NullableIntHolder intHolder = new NullableIntHolder();
          reader.read(intHolder);
          if (intHolder.isSet == 1) {
            writer.writeInt(intHolder.value);
          }
        }
        break;



      case UINT4:
        if (reader.isSet()) {
          NullableUInt4Holder uInt4Holder = new NullableUInt4Holder();
          reader.read(uInt4Holder);
          if (uInt4Holder.isSet == 1) {
            writer.writeUInt4(uInt4Holder.value);
          }
        }
        break;



      case FLOAT4:
        if (reader.isSet()) {
          NullableFloat4Holder float4Holder = new NullableFloat4Holder();
          reader.read(float4Holder);
          if (float4Holder.isSet == 1) {
            writer.writeFloat4(float4Holder.value);
          }
        }
        break;



      case DATEDAY:
        if (reader.isSet()) {
          NullableDateDayHolder dateDayHolder = new NullableDateDayHolder();
          reader.read(dateDayHolder);
          if (dateDayHolder.isSet == 1) {
            writer.writeDateDay(dateDayHolder.value);
          }
        }
        break;



      case INTERVALYEAR:
        if (reader.isSet()) {
          NullableIntervalYearHolder intervalYearHolder = new NullableIntervalYearHolder();
          reader.read(intervalYearHolder);
          if (intervalYearHolder.isSet == 1) {
            writer.writeIntervalYear(intervalYearHolder.value);
          }
        }
        break;



      case TIMESEC:
        if (reader.isSet()) {
          NullableTimeSecHolder timeSecHolder = new NullableTimeSecHolder();
          reader.read(timeSecHolder);
          if (timeSecHolder.isSet == 1) {
            writer.writeTimeSec(timeSecHolder.value);
          }
        }
        break;



      case TIMEMILLI:
        if (reader.isSet()) {
          NullableTimeMilliHolder timeMilliHolder = new NullableTimeMilliHolder();
          reader.read(timeMilliHolder);
          if (timeMilliHolder.isSet == 1) {
            writer.writeTimeMilli(timeMilliHolder.value);
          }
        }
        break;



      case BIGINT:
        if (reader.isSet()) {
          NullableBigIntHolder bigIntHolder = new NullableBigIntHolder();
          reader.read(bigIntHolder);
          if (bigIntHolder.isSet == 1) {
            writer.writeBigInt(bigIntHolder.value);
          }
        }
        break;



      case UINT8:
        if (reader.isSet()) {
          NullableUInt8Holder uInt8Holder = new NullableUInt8Holder();
          reader.read(uInt8Holder);
          if (uInt8Holder.isSet == 1) {
            writer.writeUInt8(uInt8Holder.value);
          }
        }
        break;



      case FLOAT8:
        if (reader.isSet()) {
          NullableFloat8Holder float8Holder = new NullableFloat8Holder();
          reader.read(float8Holder);
          if (float8Holder.isSet == 1) {
            writer.writeFloat8(float8Holder.value);
          }
        }
        break;



      case DATEMILLI:
        if (reader.isSet()) {
          NullableDateMilliHolder dateMilliHolder = new NullableDateMilliHolder();
          reader.read(dateMilliHolder);
          if (dateMilliHolder.isSet == 1) {
            writer.writeDateMilli(dateMilliHolder.value);
          }
        }
        break;




      case TIMESTAMPSEC:
        if (reader.isSet()) {
          NullableTimeStampSecHolder timeStampSecHolder = new NullableTimeStampSecHolder();
          reader.read(timeStampSecHolder);
          if (timeStampSecHolder.isSet == 1) {
            writer.writeTimeStampSec(timeStampSecHolder.value);
          }
        }
        break;



      case TIMESTAMPMILLI:
        if (reader.isSet()) {
          NullableTimeStampMilliHolder timeStampMilliHolder = new NullableTimeStampMilliHolder();
          reader.read(timeStampMilliHolder);
          if (timeStampMilliHolder.isSet == 1) {
            writer.writeTimeStampMilli(timeStampMilliHolder.value);
          }
        }
        break;



      case TIMESTAMPMICRO:
        if (reader.isSet()) {
          NullableTimeStampMicroHolder timeStampMicroHolder = new NullableTimeStampMicroHolder();
          reader.read(timeStampMicroHolder);
          if (timeStampMicroHolder.isSet == 1) {
            writer.writeTimeStampMicro(timeStampMicroHolder.value);
          }
        }
        break;



      case TIMESTAMPNANO:
        if (reader.isSet()) {
          NullableTimeStampNanoHolder timeStampNanoHolder = new NullableTimeStampNanoHolder();
          reader.read(timeStampNanoHolder);
          if (timeStampNanoHolder.isSet == 1) {
            writer.writeTimeStampNano(timeStampNanoHolder.value);
          }
        }
        break;







      case TIMEMICRO:
        if (reader.isSet()) {
          NullableTimeMicroHolder timeMicroHolder = new NullableTimeMicroHolder();
          reader.read(timeMicroHolder);
          if (timeMicroHolder.isSet == 1) {
            writer.writeTimeMicro(timeMicroHolder.value);
          }
        }
        break;



      case TIMENANO:
        if (reader.isSet()) {
          NullableTimeNanoHolder timeNanoHolder = new NullableTimeNanoHolder();
          reader.read(timeNanoHolder);
          if (timeNanoHolder.isSet == 1) {
            writer.writeTimeNano(timeNanoHolder.value);
          }
        }
        break;



      case INTERVALDAY:
        if (reader.isSet()) {
          NullableIntervalDayHolder intervalDayHolder = new NullableIntervalDayHolder();
          reader.read(intervalDayHolder);
          if (intervalDayHolder.isSet == 1) {
            writer.writeIntervalDay(intervalDayHolder.days, intervalDayHolder.milliseconds);
          }
        }
        break;





      case VARBINARY:
        if (reader.isSet()) {
          NullableVarBinaryHolder varBinaryHolder = new NullableVarBinaryHolder();
          reader.read(varBinaryHolder);
          if (varBinaryHolder.isSet == 1) {
            writer.writeVarBinary(varBinaryHolder.start, varBinaryHolder.end, varBinaryHolder.buffer);
          }
        }
        break;



      case VARCHAR:
        if (reader.isSet()) {
          NullableVarCharHolder varCharHolder = new NullableVarCharHolder();
          reader.read(varCharHolder);
          if (varCharHolder.isSet == 1) {
            writer.writeVarChar(varCharHolder.start, varCharHolder.end, varCharHolder.buffer);
          }
        }
        break;



      case BIT:
        if (reader.isSet()) {
          NullableBitHolder bitHolder = new NullableBitHolder();
          reader.read(bitHolder);
          if (bitHolder.isSet == 1) {
            writer.writeBit(bitHolder.value);
          }
        }
        break;

      }
 }

  private static FieldWriter getStructWriterForReader(FieldReader reader, StructWriter writer, String name) {
    switch (reader.getMinorType()) {
    case TINYINT:
      return (FieldWriter) writer.tinyInt(name);
    case UINT1:
      return (FieldWriter) writer.uInt1(name);
    case UINT2:
      return (FieldWriter) writer.uInt2(name);
    case SMALLINT:
      return (FieldWriter) writer.smallInt(name);
    case INT:
      return (FieldWriter) writer.integer(name);
    case UINT4:
      return (FieldWriter) writer.uInt4(name);
    case FLOAT4:
      return (FieldWriter) writer.float4(name);
    case DATEDAY:
      return (FieldWriter) writer.dateDay(name);
    case INTERVALYEAR:
      return (FieldWriter) writer.intervalYear(name);
    case TIMESEC:
      return (FieldWriter) writer.timeSec(name);
    case TIMEMILLI:
      return (FieldWriter) writer.timeMilli(name);
    case BIGINT:
      return (FieldWriter) writer.bigInt(name);
    case UINT8:
      return (FieldWriter) writer.uInt8(name);
    case FLOAT8:
      return (FieldWriter) writer.float8(name);
    case DATEMILLI:
      return (FieldWriter) writer.dateMilli(name);
    case TIMESTAMPSEC:
      return (FieldWriter) writer.timeStampSec(name);
    case TIMESTAMPMILLI:
      return (FieldWriter) writer.timeStampMilli(name);
    case TIMESTAMPMICRO:
      return (FieldWriter) writer.timeStampMicro(name);
    case TIMESTAMPNANO:
      return (FieldWriter) writer.timeStampNano(name);
    case TIMEMICRO:
      return (FieldWriter) writer.timeMicro(name);
    case TIMENANO:
      return (FieldWriter) writer.timeNano(name);
    case INTERVALDAY:
      return (FieldWriter) writer.intervalDay(name);
    case VARBINARY:
      return (FieldWriter) writer.varBinary(name);
    case VARCHAR:
      return (FieldWriter) writer.varChar(name);
    case BIT:
      return (FieldWriter) writer.bit(name);
    case STRUCT:
      return (FieldWriter) writer.struct(name);
    case FIXED_SIZE_LIST:
    case LIST:
    case MAP:
      return (FieldWriter) writer.list(name);
    default:
      throw new UnsupportedOperationException(reader.getMinorType().toString());
    }
  }

  private static FieldWriter getListWriterForReader(FieldReader reader, ListWriter writer) {
    switch (reader.getMinorType()) {
    case TINYINT:
    return (FieldWriter) writer.tinyInt();
    case UINT1:
    return (FieldWriter) writer.uInt1();
    case UINT2:
    return (FieldWriter) writer.uInt2();
    case SMALLINT:
    return (FieldWriter) writer.smallInt();
    case INT:
    return (FieldWriter) writer.integer();
    case UINT4:
    return (FieldWriter) writer.uInt4();
    case FLOAT4:
    return (FieldWriter) writer.float4();
    case DATEDAY:
    return (FieldWriter) writer.dateDay();
    case INTERVALYEAR:
    return (FieldWriter) writer.intervalYear();
    case TIMESEC:
    return (FieldWriter) writer.timeSec();
    case TIMEMILLI:
    return (FieldWriter) writer.timeMilli();
    case BIGINT:
    return (FieldWriter) writer.bigInt();
    case UINT8:
    return (FieldWriter) writer.uInt8();
    case FLOAT8:
    return (FieldWriter) writer.float8();
    case DATEMILLI:
    return (FieldWriter) writer.dateMilli();
    case TIMESTAMPSEC:
    return (FieldWriter) writer.timeStampSec();
    case TIMESTAMPMILLI:
    return (FieldWriter) writer.timeStampMilli();
    case TIMESTAMPMICRO:
    return (FieldWriter) writer.timeStampMicro();
    case TIMESTAMPNANO:
    return (FieldWriter) writer.timeStampNano();
    case TIMEMICRO:
    return (FieldWriter) writer.timeMicro();
    case TIMENANO:
    return (FieldWriter) writer.timeNano();
    case INTERVALDAY:
    return (FieldWriter) writer.intervalDay();
    case VARBINARY:
    return (FieldWriter) writer.varBinary();
    case VARCHAR:
    return (FieldWriter) writer.varChar();
    case BIT:
    return (FieldWriter) writer.bit();
    case STRUCT:
      return (FieldWriter) writer.struct();
    case FIXED_SIZE_LIST:
    case LIST:
    case MAP:
      return (FieldWriter) writer.list();
    default:
      throw new UnsupportedOperationException(reader.getMinorType().toString());
    }
  }
}
